/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.utests;

import java.io.File;
import loci.common.Location;
import loci.common.services.DependencyException;
import loci.common.services.ServiceException;
import loci.common.services.ServiceFactory;
import loci.formats.FormatException;
import loci.formats.ImageReader;
import loci.formats.MetadataTools;
import loci.formats.meta.MetadataRetrieve;
import loci.formats.meta.MetadataStore;
import loci.formats.ome.OMEXMLMetadata;
import loci.formats.out.JPEG2000Writer;
import loci.formats.services.OMEXMLService;
import org.testng.AssertJUnit;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class LosslessJPEG2000Test {
    private static final byte[] PIXELS_8 = new byte[]{119};
    private static final byte[] PIXELS_16 = new byte[]{0, 119};
    private static final String FILE_8 = "8.jp2";
    private static final String FILE_16 = "16.jp2";

    @BeforeMethod
    public void setUp() throws Exception {
        OMEXMLMetadata metadata16;
        OMEXMLMetadata metadata8;
        File temp8 = File.createTempFile("test", ".jp2");
        File temp16 = File.createTempFile("test", ".jp2");
        temp8.deleteOnExit();
        temp16.deleteOnExit();
        Location.mapId((String)FILE_8, (String)temp8.getAbsolutePath());
        Location.mapId((String)FILE_16, (String)temp16.getAbsolutePath());
        try {
            ServiceFactory factory = new ServiceFactory();
            OMEXMLService service = (OMEXMLService)factory.getInstance(OMEXMLService.class);
            metadata8 = service.createOMEXMLMetadata();
        }
        catch (DependencyException exc) {
            throw new FormatException("Could not create OME-XML store.", (Throwable)exc);
        }
        catch (ServiceException exc) {
            throw new FormatException("Could not create OME-XML store.", (Throwable)exc);
        }
        MetadataTools.populateMetadata((MetadataStore)metadata8, (int)0, (String)"foo", (boolean)false, (String)"XYCZT", (String)"uint8", (int)1, (int)1, (int)1, (int)1, (int)1, (int)1);
        JPEG2000Writer writer8 = new JPEG2000Writer();
        writer8.setMetadataRetrieve((MetadataRetrieve)metadata8);
        writer8.setId(FILE_8);
        writer8.saveBytes(0, PIXELS_8);
        writer8.close();
        try {
            ServiceFactory factory = new ServiceFactory();
            OMEXMLService service = (OMEXMLService)factory.getInstance(OMEXMLService.class);
            metadata16 = service.createOMEXMLMetadata();
        }
        catch (DependencyException exc) {
            throw new FormatException("Could not create OME-XML store.", (Throwable)exc);
        }
        catch (ServiceException exc) {
            throw new FormatException("Could not create OME-XML store.", (Throwable)exc);
        }
        MetadataTools.populateMetadata((MetadataStore)metadata16, (int)0, (String)"foo", (boolean)false, (String)"XYCZT", (String)"uint16", (int)1, (int)1, (int)1, (int)1, (int)1, (int)1);
        JPEG2000Writer writer16 = new JPEG2000Writer();
        writer16.setMetadataRetrieve((MetadataRetrieve)metadata16);
        writer16.setId(FILE_16);
        writer16.saveBytes(0, PIXELS_16);
        writer16.close();
    }

    @Test
    public void testEquivalentPixels8Bit() throws Exception {
        ImageReader reader = new ImageReader();
        reader.setId(FILE_8);
        byte[] plane = reader.openBytes(0);
        AssertJUnit.assertEquals((int)plane.length, (int)PIXELS_8.length);
        for (int q = 0; q < plane.length; ++q) {
            AssertJUnit.assertEquals((byte)plane[q], (byte)PIXELS_8[q]);
        }
        reader.close();
    }

    @Test
    public void testEquivalentPixels16Bit() throws Exception {
        ImageReader reader = new ImageReader();
        reader.setId(FILE_16);
        byte[] plane = reader.openBytes(0);
        AssertJUnit.assertEquals((int)plane.length, (int)PIXELS_16.length);
        for (int q = 0; q < plane.length; ++q) {
            AssertJUnit.assertEquals((byte)plane[q], (byte)PIXELS_16[q]);
        }
        reader.close();
    }
}

