/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.utests;

import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import loci.formats.utests.SPWModelMock;
import ome.xml.model.Annotation;
import ome.xml.model.Image;
import ome.xml.model.MapAnnotation;
import ome.xml.model.MapPair;
import ome.xml.model.OME;
import ome.xml.model.OMEModel;
import ome.xml.model.OMEModelImpl;
import ome.xml.model.Pixels;
import ome.xml.model.StructuredAnnotations;
import org.testng.AssertJUnit;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class MapAnnotationTest {
    private OME ome = new OME();

    @BeforeClass
    public void setUp() throws Exception {
        Image image = new Image();
        image.setID("Image:0");
        Pixels pixels = new Pixels();
        pixels.setID("Pixels:0");
        image.setPixels(pixels);
        ArrayList<MapPair> map = new ArrayList<MapPair>();
        map.add(new MapPair("a", "1"));
        map.add(new MapPair("d", "2"));
        map.add(new MapPair("c", "3"));
        map.add(new MapPair("b", "4"));
        map.add(new MapPair("e", "5"));
        map.add(new MapPair("c", "6"));
        MapAnnotation mapAnnotation = new MapAnnotation();
        mapAnnotation.setID("Annotation:0");
        mapAnnotation.setValue(map);
        StructuredAnnotations structuredAnnotations = new StructuredAnnotations();
        structuredAnnotations.addMapAnnotation(mapAnnotation);
        this.ome.setStructuredAnnotations(structuredAnnotations);
        image.linkAnnotation((Annotation)mapAnnotation);
        this.ome.addImage(image);
    }

    @Test
    public void testMapAnnotationValid() throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder parser = factory.newDocumentBuilder();
        Document document = parser.newDocument();
        Element root = this.ome.asXMLElement(document);
        SPWModelMock.postProcess(root, document, false);
        OMEModelImpl model = new OMEModelImpl();
        this.ome = new OME(document.getDocumentElement(), (OMEModel)model);
        model.resolveReferences();
    }

    @Test
    public void testMapAnnotationValueContent() throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder parser = factory.newDocumentBuilder();
        Document document = parser.newDocument();
        Element root = this.ome.asXMLElement(document);
        SPWModelMock.postProcess(root, document, false);
        OMEModelImpl model = new OMEModelImpl();
        this.ome = new OME(document.getDocumentElement(), (OMEModel)model);
        model.resolveReferences();
        AssertJUnit.assertNotNull((Object)this.ome);
        AssertJUnit.assertEquals((String)this.ome.getImage(0).getPixels().getID(), (String)"Pixels:0");
        AssertJUnit.assertNotNull((Object)this.ome.getImage(0).getLinkedAnnotation(0));
        MapAnnotation mapAnnotation = (MapAnnotation)this.ome.getImage(0).getLinkedAnnotation(0);
        List dataMap = mapAnnotation.getValue();
        AssertJUnit.assertEquals((int)6, (int)dataMap.size());
        AssertJUnit.assertEquals((String)"a", (String)((MapPair)dataMap.get(0)).getName());
        AssertJUnit.assertEquals((String)"1", (String)((MapPair)dataMap.get(0)).getValue());
        AssertJUnit.assertEquals((String)"d", (String)((MapPair)dataMap.get(1)).getName());
        AssertJUnit.assertEquals((String)"2", (String)((MapPair)dataMap.get(1)).getValue());
        AssertJUnit.assertEquals((String)"c", (String)((MapPair)dataMap.get(2)).getName());
        AssertJUnit.assertEquals((String)"3", (String)((MapPair)dataMap.get(2)).getValue());
        AssertJUnit.assertEquals((String)"b", (String)((MapPair)dataMap.get(3)).getName());
        AssertJUnit.assertEquals((String)"4", (String)((MapPair)dataMap.get(3)).getValue());
        AssertJUnit.assertEquals((String)"e", (String)((MapPair)dataMap.get(4)).getName());
        AssertJUnit.assertEquals((String)"5", (String)((MapPair)dataMap.get(4)).getValue());
        AssertJUnit.assertEquals((String)"c", (String)((MapPair)dataMap.get(5)).getName());
        AssertJUnit.assertEquals((String)"6", (String)((MapPair)dataMap.get(5)).getValue());
    }
}

