/*
 * Decompiled with CFR 0.152.
 */
package loci.common.utests;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import loci.common.Location;
import loci.common.utests.TestUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.AssertJUnit;
import org.testng.SkipException;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class LocationTest {
    private static final boolean IS_WINDOWS = System.getProperty("os.name").startsWith("Windows");
    private static final Logger LOGGER = LoggerFactory.getLogger(LocationTest.class);
    private Location[] files;
    private Location[] rootFiles;
    private boolean[] exists;
    private boolean[] isDirectory;
    private boolean[] isHidden;
    private String[] mode;
    private LocalRemoteType[] isRemote;
    private static boolean runHttpRemoteTests;
    private static boolean runS3RemoteTests;

    @BeforeClass
    public void setup() throws IOException {
        File tmpDirectory = new File(System.getProperty("java.io.tmpdir"), System.currentTimeMillis() + "-location-test");
        boolean success = tmpDirectory.mkdirs();
        tmpDirectory.deleteOnExit();
        File hiddenFile = File.createTempFile(".hiddenTest", null, tmpDirectory);
        hiddenFile.deleteOnExit();
        File invalidFile = File.createTempFile("invalidTest", null, tmpDirectory);
        String invalidPath = invalidFile.getAbsolutePath();
        invalidFile.delete();
        File validFile = File.createTempFile("validTest", null, tmpDirectory);
        validFile.deleteOnExit();
        this.files = new Location[]{new Location(validFile.getAbsolutePath()), new Location(invalidPath), new Location(tmpDirectory), new Location("http://www.openmicroscopy.org/"), new Location("https://www.openmicroscopy.org/"), new Location("https://www.openmicroscopy.org/nonexisting"), new Location("https://www.openmicroscopy.org/nonexisting/:/+/symbols"), new Location(hiddenFile), new Location("s3+http://localhost:31836/bucket-dne"), new Location("s3+http://localhost:31836/bioformats.test.public"), new Location("s3+http://localhost:31836/bioformats.test.public/single-channel.ome.tiff"), new Location("s3+http://localhost:31836/bioformats.test.private/single-channel.ome.tiff"), new Location("s3+http://accesskey:secretkey@localhost:31836/bioformats.test.private/single-channel.ome.tiff")};
        this.rootFiles = new Location[]{new Location("/"), new Location("https://www.openmicroscopy.org"), new Location("s3://s3.example.org")};
        this.exists = new boolean[]{true, false, true, true, true, false, false, true, false, true, true, false, true};
        this.isDirectory = new boolean[]{false, false, true, false, false, false, false, false, false, true, false, false, false};
        this.isHidden = new boolean[]{false, false, false, false, false, false, false, true, false, false, false, false, false};
        this.mode = new String[]{"rw", "", "rw", "r", "r", "", "", "rw", "", "r", "r", "", "r"};
        this.isRemote = new LocalRemoteType[]{LocalRemoteType.LOCAL, LocalRemoteType.LOCAL, LocalRemoteType.LOCAL, LocalRemoteType.HTTP, LocalRemoteType.HTTP, LocalRemoteType.HTTP, LocalRemoteType.HTTP, LocalRemoteType.LOCAL, LocalRemoteType.S3, LocalRemoteType.S3, LocalRemoteType.S3, LocalRemoteType.S3, LocalRemoteType.S3};
    }

    @BeforeClass
    public void checkProperties() throws IOException {
        runHttpRemoteTests = TestUtilities.getPropValueInt("testng.runHttpRemoteTests") > 0;
        boolean bl = runS3RemoteTests = TestUtilities.getPropValueInt("testng.runS3RemoteTests") > 0;
        if (!runHttpRemoteTests) {
            LOGGER.warn("HTTP tests are disabled!");
        }
        if (!runS3RemoteTests) {
            LOGGER.warn("S3 tests are disabled!");
        }
    }

    private void skipIfHttpDisabled(int i) throws SkipException {
        if (this.isRemote[i] == LocalRemoteType.HTTP && !runHttpRemoteTests) {
            throw new SkipException("HTTP tests are disabled " + this.files[i].getName());
        }
    }

    private void skipIfS3Disabled(int i) throws SkipException {
        if (this.isRemote[i] == LocalRemoteType.S3 && !runS3RemoteTests) {
            throw new SkipException("S3 tests are disabled " + this.files[i].getName());
        }
    }

    @Test
    public void testReadWriteMode() {
        for (int i = 0; i < this.files.length; ++i) {
            this.skipIfHttpDisabled(i);
            this.skipIfS3Disabled(i);
            String msg = this.files[i].getName();
            AssertJUnit.assertEquals((String)msg, (boolean)this.mode[i].contains("r"), (boolean)this.files[i].canRead());
            AssertJUnit.assertEquals((String)msg, (boolean)this.mode[i].contains("w"), (boolean)this.files[i].canWrite());
        }
    }

    @Test
    public void testAbsolute() {
        for (Location file : this.files) {
            AssertJUnit.assertEquals((String)file.getName(), (String)file.getAbsoluteFile().getAbsolutePath(), (String)file.getAbsolutePath());
        }
    }

    @Test
    public void testExists() {
        for (int i = 0; i < this.files.length; ++i) {
            this.skipIfHttpDisabled(i);
            this.skipIfS3Disabled(i);
            AssertJUnit.assertEquals((String)this.files[i].getName(), (boolean)this.exists[i], (boolean)this.files[i].exists());
        }
    }

    @Test
    public void testCanonical() throws IOException {
        for (Location file : this.files) {
            AssertJUnit.assertEquals((String)file.getName(), (String)file.getCanonicalFile().getAbsolutePath(), (String)file.getCanonicalPath());
        }
    }

    @Test
    public void testParent() {
        for (Location file : this.files) {
            AssertJUnit.assertEquals((String)file.getName(), (String)file.getParentFile().getAbsolutePath(), (String)file.getParent());
        }
    }

    @Test
    public void testParentRoot() {
        for (Location file : this.rootFiles) {
            AssertJUnit.assertEquals((String)file.getName(), null, (String)file.getParent());
        }
    }

    @Test
    public void testParentNull() {
        Location nullParent = new Location((String)null, "nullParentFile");
        AssertJUnit.assertNull((Object)nullParent.getParentFile());
        nullParent = new Location((Location)null, "nullParentFile");
        AssertJUnit.assertNull((Object)nullParent.getParentFile());
    }

    @Test
    public void testIsDirectory() {
        for (int i = 0; i < this.files.length; ++i) {
            this.skipIfS3Disabled(i);
            AssertJUnit.assertEquals((String)this.files[i].getName(), (boolean)this.isDirectory[i], (boolean)this.files[i].isDirectory());
        }
    }

    @Test
    public void testIsFile() {
        for (int i = 0; i < this.files.length; ++i) {
            this.skipIfHttpDisabled(i);
            this.skipIfS3Disabled(i);
            AssertJUnit.assertEquals((String)this.files[i].getName(), (!this.isDirectory[i] && this.exists[i] ? 1 : 0) != 0, (boolean)this.files[i].isFile());
        }
    }

    @Test
    public void testIsHidden() {
        for (int i = 0; i < this.files.length; ++i) {
            AssertJUnit.assertEquals((String)this.files[i].getName(), (this.isHidden[i] || IS_WINDOWS ? 1 : 0) != 0, (this.files[i].isHidden() || IS_WINDOWS ? 1 : 0) != 0);
        }
    }

    @Test
    public void testListFiles() {
        for (int i = 0; i < this.files.length; ++i) {
            this.skipIfS3Disabled(i);
            String[] completeList = this.files[i].list();
            String[] unhiddenList = this.files[i].list(true);
            Location[] fileList = this.files[i].listFiles();
            if (!this.files[i].isDirectory()) {
                AssertJUnit.assertEquals((String)this.files[i].getName(), null, (Object)completeList);
                AssertJUnit.assertEquals((String)this.files[i].getName(), null, (Object)unhiddenList);
                AssertJUnit.assertEquals((String)this.files[i].getName(), null, (Object)fileList);
                continue;
            }
            AssertJUnit.assertEquals((String)this.files[i].getName(), (int)fileList.length, (int)completeList.length);
            List<String> complete = Arrays.asList(completeList);
            for (String child : unhiddenList) {
                AssertJUnit.assertEquals((String)this.files[i].getName(), (boolean)true, (boolean)complete.contains(child));
                AssertJUnit.assertEquals((String)this.files[i].getName(), (boolean)false, (boolean)new Location(this.files[i], child).isHidden());
            }
            for (int f = 0; f < fileList.length; ++f) {
                AssertJUnit.assertEquals((String)this.files[i].getName(), (String)completeList[f], (String)fileList[f].getName());
            }
        }
    }

    @Test
    public void testToURL() throws IOException {
        for (int i = 0; i < this.files.length; ++i) {
            this.skipIfS3Disabled(i);
            Location file = this.files[i];
            String path = file.getAbsolutePath();
            if (!path.contains("://")) {
                path = IS_WINDOWS ? "file:/" + path : "file://" + path;
            }
            if (file.isDirectory() && !path.endsWith(File.separator)) {
                path = path + File.separator;
            }
            try {
                AssertJUnit.assertEquals((String)file.getName(), (Object)new URL(path), (Object)file.toURL());
                continue;
            }
            catch (MalformedURLException e) {
                AssertJUnit.assertEquals((String)path, (boolean)true, (boolean)path.contains("s3+http://"));
            }
        }
    }

    @Test
    public void testToString() {
        for (Location file : this.files) {
            AssertJUnit.assertEquals((String)file.getName(), (String)file.getAbsolutePath(), (String)file.toString());
        }
    }

    private static enum LocalRemoteType {
        LOCAL,
        HTTP,
        S3;

    }
}

