/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import loci.common.DataTools;
import loci.common.DateTools;
import loci.common.Location;
import loci.common.RandomAccessInputStream;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.in.MetadataLevel;
import loci.formats.meta.MetadataStore;
import ome.units.quantity.Length;
import ome.xml.model.primitives.Timestamp;

public class FujiReader
extends FormatReader {
    private static final String DATE_FORMAT = "ddd MMM dd HH:mm:ss yyyy";
    private String infFile;
    private String pixelsFile;

    public FujiReader() {
        super("Fuji LAS 3000", new String[]{"img", "inf"});
        this.domains = new String[]{"Gel/Blot Imaging"};
        this.hasCompanionFiles = true;
    }

    @Override
    public boolean isThisType(String name, boolean open) {
        if (!super.isThisType(name, open)) {
            return false;
        }
        if (!open) {
            return false;
        }
        String baseName = name.substring(0, name.lastIndexOf("."));
        if (FujiReader.checkSuffix(name, "inf")) {
            return new Location(baseName + ".img").exists();
        }
        if (FujiReader.checkSuffix(name, "img")) {
            return new Location(baseName + ".inf").exists();
        }
        return false;
    }

    @Override
    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        return false;
    }

    @Override
    public boolean isSingleFile(String id) throws FormatException, IOException {
        return false;
    }

    @Override
    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h2) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h2);
        try (RandomAccessInputStream s2 = new RandomAccessInputStream(this.pixelsFile);){
            this.readPlane(s2, x, y, w, h2, buf);
        }
        return buf;
    }

    @Override
    public String[] getSeriesUsedFiles(boolean noPixels) {
        FormatTools.assertId(this.currentId, true, 1);
        if (noPixels) {
            return new String[]{this.infFile};
        }
        return new String[]{this.infFile, this.pixelsFile};
    }

    @Override
    public int fileGroupOption(String id) throws FormatException, IOException {
        return 0;
    }

    @Override
    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.infFile = null;
            this.pixelsFile = null;
        }
    }

    @Override
    protected void initFile(String id) throws FormatException, IOException {
        if (!FujiReader.checkSuffix(id, "inf")) {
            this.initFile(id.substring(0, id.lastIndexOf(".")) + ".inf");
            return;
        }
        super.initFile(id);
        this.infFile = new Location(id).getAbsolutePath();
        this.pixelsFile = this.infFile.substring(0, this.infFile.lastIndexOf(".")) + ".img";
        String[] lines = DataTools.readFile(this.infFile).split("\r{0,1}\n");
        int bits = Integer.parseInt(lines[5]);
        CoreMetadata m4 = (CoreMetadata)this.core.get(0);
        m4.pixelType = FormatTools.pixelTypeFromBytes(bits / 8, false, false);
        m4.sizeX = Integer.parseInt(lines[6]);
        m4.sizeY = Integer.parseInt(lines[7]);
        m4.sizeC = 1;
        m4.sizeT = 1;
        m4.sizeZ = 1;
        m4.imageCount = this.getSizeZ() * this.getSizeC() * this.getSizeT();
        m4.dimensionOrder = "XYCZT";
        for (String line : lines) {
            this.addGlobalMetaList("Line", line);
        }
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this);
        String imageName = lines[1];
        String timestamp = lines[10];
        timestamp = DateTools.formatDate(timestamp, DATE_FORMAT);
        store.setImageName(imageName, 0);
        if (timestamp != null) {
            store.setImageAcquisitionDate(new Timestamp(timestamp), 0);
        }
        double physicalWidth = Double.parseDouble(lines[3]);
        double physicalHeight = Double.parseDouble(lines[4]);
        Length sizeX = FormatTools.getPhysicalSizeX(physicalWidth);
        Length sizeY = FormatTools.getPhysicalSizeY(physicalHeight);
        if (sizeX != null) {
            store.setPixelsPhysicalSizeX(sizeX, 0);
        }
        if (sizeY != null) {
            store.setPixelsPhysicalSizeY(sizeY, 0);
        }
        if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
            String instrument = lines[13];
            String instrumentID = MetadataTools.createLSID("Instrument", 0);
            store.setInstrumentID(instrumentID, 0);
            store.setMicroscopeModel(instrument, 0);
        }
    }
}

