/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import loci.common.DataTools;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.in.BaseTiffReader;
import loci.formats.in.MetadataLevel;
import loci.formats.meta.MetadataStore;
import loci.formats.tiff.IFD;
import loci.formats.tiff.IFDList;
import ome.units.quantity.Length;
import ome.xml.model.primitives.Timestamp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImarisTiffReader
extends BaseTiffReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(ImarisTiffReader.class);

    public ImarisTiffReader() {
        super("Bitplane Imaris 3 (TIFF)", "ims");
        this.suffixSufficient = false;
        this.suffixNecessary = true;
        this.domains = new String[]{"Unknown"};
    }

    @Override
    protected void initFile(String id) throws FormatException, IOException {
        super.initFile(id);
        LOGGER.info("Verifying IFD sanity");
        IFDList tmp = new IFDList();
        for (IFD ifd : this.ifds) {
            long[] byteCounts = ifd.getStripByteCounts();
            long[] offsets = ifd.getStripOffsets();
            for (int i = 0; i < byteCounts.length; ++i) {
                IFD t2 = new IFD(ifd);
                t2.putIFDValue(325, byteCounts[i]);
                t2.putIFDValue(324, offsets[i]);
                tmp.add(t2);
            }
        }
        String comment = ((IFD)this.ifds.get(0)).getComment();
        LOGGER.info("Populating metadata");
        CoreMetadata m4 = (CoreMetadata)this.core.get(0, 0);
        m4.sizeC = this.ifds.size();
        m4.sizeZ = tmp.size() / this.getSizeC();
        m4.sizeT = 1;
        m4.sizeX = (int)((IFD)this.ifds.get(0)).getImageWidth();
        m4.sizeY = (int)((IFD)this.ifds.get(0)).getImageLength();
        this.ifds = tmp;
        m4.imageCount = this.getSizeC() * this.getSizeZ();
        m4.dimensionOrder = "XYZCT";
        m4.interleaved = false;
        m4.rgb = this.getImageCount() != this.getSizeZ() * this.getSizeC() * this.getSizeT();
        m4.pixelType = ((IFD)this.ifds.get(0)).getPixelType();
        LOGGER.info("Parsing comment");
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this);
        if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
            String description = null;
            String creationDate = null;
            ArrayList<Double> emWave = new ArrayList<Double>();
            ArrayList<Double> exWave = new ArrayList<Double>();
            ArrayList<String> channelNames = new ArrayList<String>();
            if (comment != null && comment.startsWith("[")) {
                StringTokenizer st = new StringTokenizer(comment, "\n");
                while (st.hasMoreTokens()) {
                    String line = st.nextToken();
                    int equals = line.indexOf(61);
                    if (equals < 0) continue;
                    String key = line.substring(0, equals).trim();
                    String value = line.substring(equals + 1).trim();
                    this.addGlobalMeta(key, value);
                    if (key.equals("Description")) {
                        description = value;
                        continue;
                    }
                    if (key.equals("LSMEmissionWavelength") && !value.equals("0")) {
                        emWave.add(DataTools.parseDouble(value));
                        continue;
                    }
                    if (key.equals("LSMExcitationWavelength") && !value.equals("0")) {
                        exWave.add(DataTools.parseDouble(value));
                        continue;
                    }
                    if (key.equals("Name") && !this.currentId.endsWith(value)) {
                        channelNames.add(value);
                        continue;
                    }
                    if (!key.equals("RecordingDate")) continue;
                    value = value.replaceAll(" ", "T");
                    creationDate = value.substring(0, value.indexOf(46));
                }
                this.metadata.remove("Comment");
            }
            store.setImageDescription(description, 0);
            if (creationDate != null) {
                store.setImageAcquisitionDate(new Timestamp(creationDate), 0);
            }
            for (int i = 0; i < emWave.size(); ++i) {
                Length emission = FormatTools.getEmissionWavelength((Double)emWave.get(i));
                Length excitation = FormatTools.getExcitationWavelength((Double)exWave.get(i));
                if (emission != null) {
                    store.setChannelEmissionWavelength(emission, 0, i);
                }
                if (excitation != null) {
                    store.setChannelExcitationWavelength(excitation, 0, i);
                }
                store.setChannelName((String)channelNames.get(i), 0, i);
            }
        }
    }
}

