/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import loci.common.DataTools;
import loci.common.Location;
import loci.common.RandomAccessInputStream;
import loci.common.services.DependencyException;
import loci.common.services.ServiceFactory;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.codec.CodecOptions;
import loci.formats.codec.JPEGCodec;
import loci.formats.codec.ZlibCodec;
import loci.formats.in.BaseZeissReader;
import loci.formats.in.MetadataLevel;
import loci.formats.meta.DummyMetadata;
import loci.formats.meta.MetadataStore;
import loci.formats.services.POIService;

public class ZeissZVIReader
extends BaseZeissReader {
    public static final int ZVI_MAGIC_BYTES = -791735840;
    private static final long ROI_SIGNATURE = 2449947852680921101L;
    protected transient POIService poi;
    protected String[] files;
    protected transient RandomAccessInputStream currentPlane;
    protected transient int currentPlaneIndex = -1;

    public ZeissZVIReader() {
        super("Zeiss Vision Image (ZVI)", "zvi");
        this.domains = new String[]{"Light Microscopy"};
    }

    @Override
    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        int blockLen = 65536;
        if (!FormatTools.validStream(stream, 65536, false)) {
            return false;
        }
        int magic = stream.readInt();
        return magic == -791735840;
    }

    @Override
    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h2) throws FormatException, IOException {
        int yy;
        byte[] t2;
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h2);
        this.lastPlane = no;
        if (this.poi == null) {
            this.initPOIService();
        }
        int bytes = FormatTools.getBytesPerPixel(this.getPixelType());
        int pixel = bytes * this.getRGBChannelCount();
        CodecOptions options = new CodecOptions();
        options.littleEndian = this.isLittleEndian();
        options.interleaved = this.isInterleaved();
        int index = -1;
        int[] coords = this.getZCTCoords(no);
        for (int q = 0; q < this.coordinates.length; ++q) {
            if (this.coordinates[q][0] != coords[0] || this.coordinates[q][1] != coords[1] || this.coordinates[q][2] != coords[2] || this.coordinates[q][3] != this.getSeries()) continue;
            index = q;
            break;
        }
        LOGGER.trace("no = " + no + ", index = " + index);
        if (index < 0 || index >= this.imageFiles.length) {
            return buf;
        }
        if (this.currentPlane == null || this.currentPlaneIndex != index) {
            if (this.currentPlane != null) {
                this.currentPlane.close();
            }
            this.currentPlane = this.poi.getDocumentStream(this.imageFiles[index]);
            this.currentPlaneIndex = index;
        }
        this.currentPlane.seek(this.offsets[index]);
        int len = w * pixel;
        int row = this.getSizeX() * pixel;
        if (this.isJPEG) {
            t2 = new JPEGCodec().decompress(this.currentPlane, options);
            for (yy = 0; yy < h2; ++yy) {
                System.arraycopy(t2, (yy + y) * row + x * pixel, buf, yy * len, len);
            }
        } else if (this.isZlib) {
            t2 = new ZlibCodec().decompress(this.currentPlane, options);
            for (yy = 0; yy < h2; ++yy) {
                int src = (yy + y) * row + x * pixel;
                int dest = yy * len;
                if (src + len <= t2.length && dest + len <= buf.length) {
                    System.arraycopy(t2, src, buf, dest, len);
                    continue;
                }
                break;
            }
        } else {
            this.readPlane(this.currentPlane, x, y, w, h2, buf);
        }
        if (this.isRGB() && !this.isJPEG) {
            byte[] bb = new byte[bytes];
            for (int i = 0; i < buf.length; i += this.bpp) {
                System.arraycopy(buf, i + 2 * bytes, bb, 0, bytes);
                System.arraycopy(buf, i, buf, i + 2 * bytes, bytes);
                System.arraycopy(bb, 0, buf, i, bytes);
            }
        }
        return buf;
    }

    @Override
    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (this.poi != null) {
            this.poi.close();
        }
        if (this.currentPlane != null) {
            this.currentPlane.close();
        }
        this.poi = null;
        this.files = null;
        this.currentPlane = null;
        this.currentPlaneIndex = -1;
    }

    @Override
    protected void initFile(String id) throws FormatException, IOException {
        super.initFile(id);
        super.initFileMain(id);
        Object[] zs = this.zIndices.toArray(new Integer[this.zIndices.size()]);
        Object[] cs = this.channelIndices.toArray(new Integer[this.channelIndices.size()]);
        Object[] ts = this.timepointIndices.toArray(new Integer[this.timepointIndices.size()]);
        Object[] tiles = this.tileIndices.toArray(new Integer[this.tileIndices.size()]);
        Arrays.sort(zs);
        Arrays.sort(cs);
        Arrays.sort(ts);
        Arrays.sort(tiles);
        for (int i = 0; i < this.coordinates.length; ++i) {
            this.coordinates[i][0] = Arrays.binarySearch(zs, (Object)this.coordinates[i][0]);
            this.coordinates[i][1] = Arrays.binarySearch(cs, (Object)this.coordinates[i][1]);
            this.coordinates[i][2] = Arrays.binarySearch(ts, (Object)this.coordinates[i][2]);
            this.coordinates[i][3] = Arrays.binarySearch(tiles, (Object)this.coordinates[i][3]);
            LOGGER.trace("corrected coordinate #{} = {}", (Object)i, (Object)this.coordinates[i]);
        }
    }

    @Override
    protected void initVars(String id) throws FormatException, IOException {
        super.initVars(id);
        this.initPOIService();
        this.countImages();
    }

    private void initPOIService() throws FormatException, IOException {
        try {
            ServiceFactory factory = new ServiceFactory();
            this.poi = factory.getInstance(POIService.class);
        }
        catch (DependencyException de) {
            throw new FormatException("POI library not found", de);
        }
        this.poi.initialize(Location.getMappedId(this.getCurrentFile()));
    }

    @Override
    protected void fillMetadataPass1(MetadataStore store) throws FormatException, IOException {
        super.fillMetadataPass1(store);
        for (String name : this.files) {
            RandomAccessInputStream s2;
            int imageNum;
            String relPath = name.substring(name.lastIndexOf(File.separator) + 1);
            if (!relPath.toUpperCase().equals("CONTENTS")) continue;
            String dirName = name.substring(0, name.lastIndexOf(File.separator));
            if (dirName.indexOf(File.separator) != -1) {
                dirName = dirName.substring(dirName.lastIndexOf(File.separator) + 1);
            }
            if (name.indexOf("Scaling") == -1 && dirName.equals("Tags")) {
                imageNum = this.getImageNumber(name, -1);
                if (imageNum == -1) {
                    this.parseTags(imageNum, name, new DummyMetadata());
                    continue;
                }
                this.tagsToParse.add(name);
                continue;
            }
            if (dirName.equals("Shapes") && name.indexOf("Item") != -1) {
                imageNum = this.getImageNumber(name, -1);
                if (imageNum == -1) continue;
                try {
                    s2 = this.poi.getDocumentStream(name);
                    try {
                        this.parseROIs(s2, imageNum, name, store);
                    }
                    finally {
                        if (s2 != null) {
                            s2.close();
                        }
                    }
                }
                catch (IOException e) {
                    LOGGER.debug("Could not parse all ROIs.", e);
                }
                continue;
            }
            if (!dirName.equals("Image") && dirName.toUpperCase().indexOf("ITEM") == -1 || (imageNum = this.getImageNumber(dirName, this.getImageCount() == 1 ? 0 : -1)) == -1) continue;
            s2 = this.poi.getDocumentStream(name);
            try {
                s2.order(true);
                if (s2.length() <= 1024L) continue;
                for (int q = 0; q < 11; ++q) {
                    this.getNextTag(s2);
                }
                s2.skipBytes(2);
                int len = s2.readInt() - 20;
                s2.skipBytes(8);
                int zidx = s2.readInt();
                int cidx = s2.readInt();
                int tidx = s2.readInt();
                s2.skipBytes(4);
                int tileIndex = s2.readInt();
                this.zIndices.add(zidx);
                this.timepointIndices.add(tidx);
                this.channelIndices.add(cidx);
                this.tileIndices.add(tileIndex);
                s2.skipBytes(len - 8);
                for (int q = 0; q < 5; ++q) {
                    this.getNextTag(s2);
                }
                s2.skipBytes(4);
                ((CoreMetadata)this.core.get((int)0)).sizeX = s2.readInt();
                ((CoreMetadata)this.core.get((int)0)).sizeY = s2.readInt();
                s2.skipBytes(4);
                if (this.bpp == 0) {
                    this.bpp = s2.readInt();
                } else {
                    s2.skipBytes(4);
                }
                s2.skipBytes(4);
                int valid = s2.readInt();
                String check = s2.readString(4).trim();
                this.isZlib = (valid == 0 || valid == 1) && check.equals("WZL");
                this.isJPEG = (valid == 0 || valid == 1) && !this.isZlib;
                this.offsets[imageNum] = (int)s2.getFilePointer() - 4;
                if (this.isZlib) {
                    int n = imageNum;
                    this.offsets[n] = this.offsets[n] + 8;
                }
                this.coordinates[imageNum][0] = zidx;
                this.coordinates[imageNum][1] = cidx;
                this.coordinates[imageNum][2] = tidx;
                this.coordinates[imageNum][3] = tileIndex;
                LOGGER.trace("imageNum = {}, coordinate = {}", (Object)imageNum, (Object)this.coordinates[imageNum]);
                this.imageFiles[imageNum] = name;
            }
            finally {
                if (s2 != null) {
                    s2.close();
                }
            }
        }
    }

    @Override
    protected void fillMetadataPass3(MetadataStore store) throws FormatException, IOException {
        super.fillMetadataPass3(store);
        if (this.core.size() > 1) {
            Object[] t2 = this.tiles.keySet().toArray(new Integer[this.tiles.size()]);
            Arrays.sort(t2);
            ArrayList<Integer> tmpOffsets = new ArrayList<Integer>();
            ArrayList<String> tmpFiles = new ArrayList<String>();
            int index = 0;
            for (Object key : t2) {
                int nTiles = (Integer)this.tiles.get(key);
                if (nTiles < this.getImageCount()) {
                    this.tiles.remove(key);
                } else {
                    for (int p = 0; p < nTiles; ++p) {
                        tmpOffsets.add(this.offsets[index + p]);
                        tmpFiles.add(this.imageFiles[index + p]);
                    }
                }
                index += nTiles;
            }
            this.offsets = new int[tmpOffsets.size()];
            for (int i = 0; i < this.offsets.length; ++i) {
                this.offsets[i] = (Integer)tmpOffsets.get(i);
            }
            this.imageFiles = tmpFiles.toArray(new String[tmpFiles.size()]);
        }
    }

    @Override
    protected void fillMetadataPass5(MetadataStore store) throws FormatException, IOException {
        super.fillMetadataPass5(store);
        for (String name : this.tagsToParse) {
            int imageNum = this.getImageNumber(name, -1);
            this.parseTags(imageNum, name, store);
        }
    }

    @Override
    protected void countImages() {
        this.files = this.poi.getDocumentList().toArray(new String[0]);
        Arrays.sort(this.files, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                Integer n1 = ZeissZVIReader.this.getImageNumber(o1, -1);
                Integer n2 = ZeissZVIReader.this.getImageNumber(o2, -1);
                return n1.compareTo(n2);
            }
        });
        ((CoreMetadata)this.core.get((int)0)).imageCount = 0;
        for (String file2 : this.files) {
            int imageNumber;
            String uname = file2.toUpperCase();
            if (!(uname = uname.substring(uname.indexOf(File.separator) + 1)).endsWith("CONTENTS") || !uname.startsWith("IMAGE") && uname.indexOf("ITEM") == -1 || this.poi.getFileSize(file2) <= 1024 || (imageNumber = this.getImageNumber(file2, 0)) < this.getImageCount()) continue;
            ++((CoreMetadata)this.core.get((int)0)).imageCount;
        }
        super.countImages();
        this.coordinates = new int[this.getSeriesCount() * this.getImageCount()][4];
    }

    private int getImageNumber(String dirName, int defaultNumber) {
        if (dirName.toUpperCase().indexOf("ITEM") != -1) {
            int open = dirName.indexOf(40);
            int close = dirName.indexOf(41);
            if (open < 0 || close < 0 || close < open) {
                return defaultNumber;
            }
            return Integer.parseInt(dirName.substring(open + 1, close));
        }
        return defaultNumber;
    }

    private String getNextTag(RandomAccessInputStream s2) throws IOException {
        short type = s2.readShort();
        switch (type) {
            case 0: 
            case 1: {
                return "";
            }
            case 2: {
                return String.valueOf(s2.readShort());
            }
            case 3: 
            case 22: {
                return String.valueOf(s2.readInt());
            }
            case 19: 
            case 23: {
                return String.valueOf(s2.readUnsignedInt());
            }
            case 4: {
                return String.valueOf(s2.readFloat());
            }
            case 5: {
                return String.valueOf(s2.readDouble());
            }
            case 7: {
                return String.valueOf(s2.readDouble());
            }
            case 20: {
                String str2 = String.valueOf(s2.readLong());
                return str2;
            }
            case 21: {
                byte[] raw = new byte[8];
                s2.read(raw);
                BigInteger b1 = new BigInteger(1, raw);
                return b1.toString();
            }
            case 8: 
            case 69: {
                int len = s2.readInt();
                return s2.readString(len);
            }
            case 9: 
            case 13: {
                s2.skipBytes(16);
                return "";
            }
            case 11: {
                return String.valueOf(s2.readShort() != 0);
            }
            case 63: 
            case 65: {
                int len = s2.readInt();
                s2.skipBytes(len);
                return "";
            }
            case 66: {
                short len = s2.readShort();
                return s2.readString(len);
            }
        }
        long old = s2.getFilePointer();
        while (s2.readShort() != 3 && s2.getFilePointer() + 2L < s2.length()) {
        }
        long fp = s2.getFilePointer() - 2L;
        s2.seek(old - 2L);
        return s2.readString((int)(fp - old + 2L));
    }

    private void parseTags(int image, String file2, MetadataStore store) throws FormatException, IOException {
        ArrayList<BaseZeissReader.Tag> tags = new ArrayList<BaseZeissReader.Tag>();
        try (RandomAccessInputStream s2 = this.poi.getDocumentStream(file2);){
            s2.order(true);
            s2.seek(8L);
            int count = s2.readInt();
            for (int i = 0; i < count && s2.getFilePointer() + 2L < s2.length(); ++i) {
                String value = DataTools.stripString(this.getNextTag(s2));
                s2.skipBytes(2);
                int tagID = s2.readInt();
                s2.skipBytes(6);
                if (tagID == 1047) continue;
                tags.add(new BaseZeissReader.Tag(tagID, value, BaseZeissReader.Context.MAIN));
            }
            this.parseMainTags(image, store, tags);
        }
    }

    private void parseROIs(RandomAccessInputStream s2, int imageNum, String name, MetadataStore store) throws IOException {
        int roiFound;
        MetadataLevel level = this.getMetadataOptions().getMetadataLevel();
        if (level == MetadataLevel.MINIMUM || level == MetadataLevel.NO_OVERLAYS) {
            return;
        }
        s2.setEncoding("UTF-16LE");
        s2.order(true);
        ArrayList<Long> roiOffsets = new ArrayList<Long>();
        s2.seek(2L);
        int layerversion = s2.readInt();
        LOGGER.debug("LAYER@{} version={}", (Object)(s2.getFilePointer() - 4L), (Object)layerversion);
        String layername = null;
        long tmp = s2.getFilePointer();
        if (s2.readShort() == 8) {
            s2.seek(tmp);
            layername = this.parseROIString(s2);
        }
        if (layername != null) {
            LOGGER.debug("  Name={}", (Object)layername);
        } else {
            LOGGER.debug("  Name=NULL");
        }
        s2.skipBytes(8);
        int roiCount = s2.readShort();
        LOGGER.debug("  ShapeCount@{} count={}", (Object)(s2.getFilePointer() - 2L), (Object)roiCount);
        BaseZeissReader.Layer nlayer = new BaseZeissReader.Layer();
        nlayer.name = layername;
        this.layers.add(nlayer);
        for (roiFound = 0; roiFound < roiCount && s2.getFilePointer() < s2.length() - 8L; ++roiFound) {
            long signature = s2.readLong() & 0xFFFFFFFFFFFFFFFFL;
            while (signature != 2449947852680921101L && s2.getFilePointer() < s2.length()) {
                s2.seek(s2.getFilePointer() - 6L);
                signature = s2.readLong() & 0xFFFFFFFFFFFFFFFFL;
            }
            if (s2.getFilePointer() >= s2.length()) break;
            long roiOffset = s2.getFilePointer() - 8L;
            roiOffsets.add(roiOffset);
            LOGGER.debug("ROI@{}", (Object)roiOffset);
            s2.seek(roiOffset + 26L);
            int length = s2.readInt();
            BaseZeissReader.Shape nshape = new BaseZeissReader.Shape();
            s2.skipBytes((long)length + 6L);
            long shapeAttrOffset = s2.getFilePointer();
            int shapeAttrLength = s2.readInt();
            nshape.type = BaseZeissReader.FeatureType.get(s2.readInt());
            LOGGER.debug("  ShapeAttrs@{} len={}", (Object)shapeAttrOffset, (Object)shapeAttrLength);
            if (shapeAttrLength < 32) break;
            s2.skipBytes(8);
            nshape.x1 = s2.readInt();
            nshape.y1 = s2.readInt();
            nshape.x2 = s2.readInt();
            nshape.y2 = s2.readInt();
            nshape.width = nshape.x2 - nshape.x1;
            nshape.height = nshape.y2 - nshape.y1;
            LOGGER.debug("    Bounding Box");
            if (shapeAttrLength >= 72) {
                s2.skipBytes(16);
                nshape.fillColour = s2.readInt();
                nshape.textColour = s2.readInt();
                nshape.drawColour = s2.readInt();
                nshape.lineWidth = s2.readInt();
                nshape.drawStyle = BaseZeissReader.DrawStyle.get(s2.readInt());
                nshape.fillStyle = BaseZeissReader.FillStyle.get(s2.readInt());
                nshape.strikeout = s2.readInt() != 0;
                LOGGER.debug("    Shape styles");
            }
            if (shapeAttrLength >= 100) {
                nshape.fontWeight = s2.readInt();
                nshape.bold = nshape.fontWeight >= 600;
                nshape.fontSize = s2.readInt();
                nshape.italic = s2.readInt() != 0;
                nshape.underline = s2.readInt() != 0;
                nshape.textAlignment = BaseZeissReader.TextAlignment.get(s2.readInt());
                LOGGER.debug("    Font styles");
            }
            if (shapeAttrLength >= 148) {
                s2.skipBytes(36);
                nshape.lineEndStyle = BaseZeissReader.LineEndStyle.get(s2.readInt());
                nshape.pointStyle = BaseZeissReader.PointStyle.get(s2.readInt());
                nshape.lineEndSize = s2.readInt();
                nshape.lineEndPositions = BaseZeissReader.LineEndPositions.get(s2.readInt());
                LOGGER.debug("    Line styles");
            }
            if (shapeAttrLength >= 152) {
                nshape.displayTag = s2.readInt() != 0;
                LOGGER.debug("    Tag display");
            }
            if (shapeAttrLength >= 152) {
                nshape.charset = BaseZeissReader.Charset.get(s2.readInt());
                LOGGER.debug("    Charset");
            }
            long tmp2 = s2.getFilePointer();
            for (int i = 0; i < 2; ++i) {
                if (s2.readShort() != 8) continue;
                s2.seek(tmp2);
                nshape.text = this.parseROIString(s2);
                break;
            }
            if (nshape.text != null) {
                LOGGER.debug("  Text={}", (Object)nshape.text);
            } else {
                LOGGER.debug("  Text=NULL");
            }
            if (s2.getFilePointer() + 8L > s2.length()) break;
            s2.skipBytes(4);
            LOGGER.debug("  Tag@{}", (Object)s2.getFilePointer());
            nshape.tagID = new BaseZeissReader.Tag(s2.readInt(), BaseZeissReader.Context.MAIN);
            LOGGER.debug("    TagID={}", (Object)nshape.tagID);
            nshape.fontName = this.parseROIString(s2);
            if (nshape.fontName == null) break;
            LOGGER.debug("  Font name={}", (Object)nshape.fontName);
            nshape.name = this.parseROIString(s2);
            if (nshape.name == null) break;
            LOGGER.debug("  Name={}", (Object)nshape.name);
            if (s2.getFilePointer() + 20L > s2.length()) break;
            s2.skipBytes(4);
            nshape.handleSize = s2.readInt();
            s2.skipBytes(2);
            nshape.pointCount = s2.readInt();
            s2.skipBytes(6);
            LOGGER.debug("  Handle size={}", (Object)nshape.handleSize);
            LOGGER.debug("  Point count={}", (Object)nshape.pointCount);
            if (s2.getFilePointer() + (long)(16 * nshape.pointCount) > s2.length()) break;
            nshape.points = new double[nshape.pointCount * 2];
            for (int p = 0; p < nshape.pointCount; ++p) {
                nshape.points[p * 2] = s2.readDouble();
                nshape.points[p * 2 + 1] = s2.readDouble();
            }
            nlayer.shapes.add(nshape);
        }
        if (roiCount != roiFound) {
            LOGGER.warn("Found {} ROIs, but {} ROIs expected", (Object)roiFound, (Object)roiCount);
        }
    }

    protected String parseROIString(RandomAccessInputStream s2) throws IOException {
        while (s2.getFilePointer() < s2.length() - 4L && s2.readShort() != 8) {
        }
        if (s2.getFilePointer() >= s2.length() - 8L) {
            return null;
        }
        int strlen = s2.readInt();
        if ((long)strlen + s2.getFilePointer() > s2.length()) {
            return null;
        }
        String text = null;
        if (strlen >= 2) {
            LOGGER.debug("  String@{} length={}", (Object)s2.getFilePointer(), (Object)strlen);
            text = s2.readString(strlen - 2);
            s2.skipBytes(2);
        } else {
            s2.skipBytes(strlen);
        }
        return text;
    }
}

