/*
 * Decompiled with CFR 0.152.
 */
package loci.plugins.in;

import java.awt.Dialog;
import java.awt.Panel;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import loci.common.DebugTools;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import loci.formats.gui.AWTImageTools;
import loci.formats.gui.BufferedImageReader;
import loci.plugins.BF;

public class ThumbLoader
implements Runnable {
    private BufferedImageReader ir;
    private Panel[] p;
    private Dialog dialog;
    private boolean stop;
    private Thread loader;

    public ThumbLoader(IFormatReader ir, Panel[] p, Dialog dialog) {
        this.ir = BufferedImageReader.makeBufferedImageReader(ir);
        this.p = p;
        this.dialog = dialog;
        this.loader = new Thread((Runnable)this, "BioFormats-ThumbLoader");
        this.loader.start();
    }

    public void stop() {
        if (this.loader == null) {
            return;
        }
        this.stop = true;
        BF.status(false, "Canceling thumbnail generation");
        try {
            this.loader.join();
            this.loader = null;
        }
        catch (InterruptedException exc) {
            exc.printStackTrace();
        }
        BF.status(false, "");
    }

    @Override
    public void run() {
        int i;
        BF.status(false, "Gathering series information");
        int seriesCount = this.ir.getSeriesCount();
        Object[] info = new SeriesInfo[seriesCount];
        for (i = 0; i < seriesCount; ++i) {
            if (this.stop) {
                return;
            }
            this.ir.setSeries(i);
            info[i] = new SeriesInfo(i, this.ir.getSizeX() * this.ir.getSizeY());
        }
        if (this.stop) {
            return;
        }
        Arrays.sort(info);
        for (i = 0; i < seriesCount; ++i) {
            if (this.stop) {
                return;
            }
            int ii = ((SeriesInfo)info[i]).index;
            ThumbLoader.loadThumb(this.ir, ii, this.p[ii], false);
            if (this.dialog == null) continue;
            this.dialog.validate();
        }
    }

    public static void loadThumb(BufferedImageReader thumbReader, int series, Panel panel, boolean quiet) {
        BF.status(quiet, "Reading thumbnail for series #" + (series + 1));
        List<CoreMetadata> core = thumbReader.getCoreMetadataList();
        int index = series;
        for (int i = 0; i <= index; ++i) {
            if (core.get((int)i).resolutionCount <= 1 || i + core.get((int)i).resolutionCount <= index) continue;
            index = i + core.get((int)i).resolutionCount - 1;
            break;
        }
        thumbReader.setSeries(index);
        int z = thumbReader.getSizeZ() / 2;
        int t2 = thumbReader.getSizeT() / 2;
        int ndx = thumbReader.getIndex(z, 0, t2);
        Exception exc = null;
        try {
            BufferedImage thumb = thumbReader.openThumbImage(ndx);
            if (!FormatTools.isFloatingPoint(thumbReader.getPixelType())) {
                thumb = AWTImageTools.autoscale(thumb);
            }
            ImageIcon icon = new ImageIcon(thumb);
            panel.removeAll();
            panel.add(new JLabel(icon));
        }
        catch (FormatException e) {
            exc = e;
        }
        catch (IOException e) {
            exc = e;
        }
        if (exc != null) {
            BF.warn(quiet, "Error loading thumbnail for series #" + (series + 1));
            BF.debug(DebugTools.getStackTrace(exc));
        }
    }

    public class SeriesInfo
    implements Comparable<SeriesInfo> {
        private int index;
        private int size;

        public SeriesInfo(int index, int size) {
            this.index = index;
            this.size = size;
        }

        @Override
        public int compareTo(SeriesInfo info) {
            return this.size - info.size;
        }
    }
}

