/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.ode;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.commons.math.ode.DerivativeException;
import org.apache.commons.math.ode.FirstOrderDifferentialEquations;
import org.apache.commons.math.ode.RungeKuttaStepInterpolator;
import org.apache.commons.math.ode.StepInterpolator;

class DormandPrince853StepInterpolator
extends RungeKuttaStepInterpolator {
    private double[][] yDotKLast;
    private double[][] v;
    private boolean vectorsInitialized;
    private static final double b_01 = 0.054293734116568765;
    private static final double b_06 = 4.450312892752409;
    private static final double b_07 = 1.8915178993145003;
    private static final double b_08 = -5.801203960010585;
    private static final double b_09 = 0.3111643669578199;
    private static final double b_10 = -0.1521609496625161;
    private static final double b_11 = 0.20136540080403034;
    private static final double b_12 = 0.04471061572777259;
    private static final double c14 = 0.1;
    private static final double k14_01 = 0.0018737681664791894;
    private static final double k14_06 = -4.450312892752409;
    private static final double k14_07 = -1.6380176890978755;
    private static final double k14_08 = 5.554964922539782;
    private static final double k14_09 = -0.4353557902216363;
    private static final double k14_10 = 0.30545274794128174;
    private static final double k14_11 = -0.19316434850839564;
    private static final double k14_12 = -0.03714271806722689;
    private static final double k14_13 = -0.008298;
    private static final double c15 = 0.2;
    private static final double k15_01 = -0.022459085953066622;
    private static final double k15_06 = -4.422011983080043;
    private static final double k15_07 = -1.8379759110070617;
    private static final double k15_08 = 5.746280211439194;
    private static final double k15_09 = -0.3111643669578199;
    private static final double k15_10 = 0.1521609496625161;
    private static final double k15_11 = -0.2014737481327276;
    private static final double k15_12 = -0.04432804463693693;
    private static final double k15_13 = -3.4046500868740456E-4;
    private static final double k15_14 = 0.1413124436746325;
    private static final double c16 = 0.7777777777777778;
    private static final double k16_01 = -0.4831900357003607;
    private static final double k16_06 = -9.147934308113573;
    private static final double k16_07 = 5.791903296748099;
    private static final double k16_08 = 9.870193778407696;
    private static final double k16_09 = 0.04556282049746119;
    private static final double k16_10 = 0.1521609496625161;
    private static final double k16_11 = -0.20136540080403034;
    private static final double k16_12 = -0.04471061572777259;
    private static final double k16_13 = -0.0013990241651590145;
    private static final double k16_14 = 2.9475147891527724;
    private static final double k16_15 = -9.15095847217987;
    private static final double[][] d = new double[][]{{-8.428938276109013, 0.5667149535193777, -3.0689499459498917, 2.38466765651207, 2.1170345824450285, -0.871391583777973, 2.2404374302607883, 0.6315787787694688, -0.08899033645133331, 18.148505520854727, -9.194632392478356, -4.436036387594894}, {10.427508642579134, 242.28349177525817, 165.20045171727028, -374.5467547226902, -22.113666853125302, 7.733432668472264, -30.674084731089398, -9.332130526430229, 15.697238121770845, -31.139403219565178, -9.35292435884448, 35.81684148639408}, {19.985053242002433, -387.0373087493518, -189.17813819516758, 527.8081592054236, -11.573902539959631, 6.8812326946963, -1.0006050966910838, 0.7777137798053443, -2.778205752353508, -60.19669523126412, 84.32040550667716, 11.99229113618279}, {-25.69393346270375, -154.18974869023643, -231.5293791760455, 357.6391179106141, 93.4053241836243, -37.45832313645163, 104.0996495089623, 29.8402934266605, -43.53345659001114, 96.32455395918828, -39.17726167561544, -149.72683625798564}};
    private static final long serialVersionUID = 7152276390558450974L;

    public DormandPrince853StepInterpolator() {
        this.yDotKLast = null;
        this.v = null;
        this.vectorsInitialized = false;
    }

    public DormandPrince853StepInterpolator(DormandPrince853StepInterpolator interpolator) {
        super(interpolator);
        if (interpolator.currentState == null) {
            this.yDotKLast = null;
            this.v = null;
            this.vectorsInitialized = false;
        } else {
            int k;
            int dimension = interpolator.currentState.length;
            this.yDotKLast = new double[3][];
            for (k = 0; k < this.yDotKLast.length; ++k) {
                this.yDotKLast[k] = new double[dimension];
                System.arraycopy(interpolator.yDotKLast[k], 0, this.yDotKLast[k], 0, dimension);
            }
            this.v = new double[7][];
            for (k = 0; k < this.v.length; ++k) {
                this.v[k] = new double[dimension];
                System.arraycopy(interpolator.v[k], 0, this.v[k], 0, dimension);
            }
            this.vectorsInitialized = interpolator.vectorsInitialized;
        }
    }

    protected StepInterpolator doCopy() {
        return new DormandPrince853StepInterpolator(this);
    }

    public void reinitialize(FirstOrderDifferentialEquations equations, double[] y, double[][] yDotK, boolean forward) {
        int k;
        super.reinitialize(equations, y, yDotK, forward);
        int dimension = this.currentState.length;
        this.yDotKLast = new double[3][];
        for (k = 0; k < this.yDotKLast.length; ++k) {
            this.yDotKLast[k] = new double[dimension];
        }
        this.v = new double[7][];
        for (k = 0; k < this.v.length; ++k) {
            this.v[k] = new double[dimension];
        }
        this.vectorsInitialized = false;
    }

    public void storeTime(double t2) {
        super.storeTime(t2);
        this.vectorsInitialized = false;
    }

    protected void computeInterpolatedState(double theta, double oneMinusThetaH) throws DerivativeException {
        if (!this.vectorsInitialized) {
            if (this.v == null) {
                this.v = new double[7][];
                for (int k = 0; k < 7; ++k) {
                    this.v[k] = new double[this.interpolatedState.length];
                }
            }
            this.finalizeStep();
            for (int i = 0; i < this.interpolatedState.length; ++i) {
                this.v[0][i] = this.h * (0.054293734116568765 * this.yDotK[0][i] + 4.450312892752409 * this.yDotK[5][i] + 1.8915178993145003 * this.yDotK[6][i] + -5.801203960010585 * this.yDotK[7][i] + 0.3111643669578199 * this.yDotK[8][i] + -0.1521609496625161 * this.yDotK[9][i] + 0.20136540080403034 * this.yDotK[10][i] + 0.04471061572777259 * this.yDotK[11][i]);
                this.v[1][i] = this.h * this.yDotK[0][i] - this.v[0][i];
                this.v[2][i] = this.v[0][i] - this.v[1][i] - this.h * this.yDotK[12][i];
                for (int k = 0; k < d.length; ++k) {
                    this.v[k + 3][i] = this.h * (d[k][0] * this.yDotK[0][i] + d[k][1] * this.yDotK[5][i] + d[k][2] * this.yDotK[6][i] + d[k][3] * this.yDotK[7][i] + d[k][4] * this.yDotK[8][i] + d[k][5] * this.yDotK[9][i] + d[k][6] * this.yDotK[10][i] + d[k][7] * this.yDotK[11][i] + d[k][8] * this.yDotK[12][i] + d[k][9] * this.yDotKLast[0][i] + d[k][10] * this.yDotKLast[1][i] + d[k][11] * this.yDotKLast[2][i]);
                }
            }
            this.vectorsInitialized = true;
        }
        double eta = oneMinusThetaH / this.h;
        for (int i = 0; i < this.interpolatedState.length; ++i) {
            this.interpolatedState[i] = this.currentState[i] - eta * (this.v[0][i] - theta * (this.v[1][i] + theta * (this.v[2][i] + eta * (this.v[3][i] + theta * (this.v[4][i] + eta * (this.v[5][i] + theta * this.v[6][i]))))));
        }
    }

    protected void doFinalize() throws DerivativeException {
        double s2;
        int j;
        if (this.currentState == null) {
            return;
        }
        double[] yTmp = new double[this.currentState.length];
        for (j = 0; j < this.currentState.length; ++j) {
            s2 = 0.0018737681664791894 * this.yDotK[0][j] + -4.450312892752409 * this.yDotK[5][j] + -1.6380176890978755 * this.yDotK[6][j] + 5.554964922539782 * this.yDotK[7][j] + -0.4353557902216363 * this.yDotK[8][j] + 0.30545274794128174 * this.yDotK[9][j] + -0.19316434850839564 * this.yDotK[10][j] + -0.03714271806722689 * this.yDotK[11][j] + -0.008298 * this.yDotK[12][j];
            yTmp[j] = this.currentState[j] + this.h * s2;
        }
        this.equations.computeDerivatives(this.previousTime + 0.1 * this.h, yTmp, this.yDotKLast[0]);
        for (j = 0; j < this.currentState.length; ++j) {
            s2 = -0.022459085953066622 * this.yDotK[0][j] + -4.422011983080043 * this.yDotK[5][j] + -1.8379759110070617 * this.yDotK[6][j] + 5.746280211439194 * this.yDotK[7][j] + -0.3111643669578199 * this.yDotK[8][j] + 0.1521609496625161 * this.yDotK[9][j] + -0.2014737481327276 * this.yDotK[10][j] + -0.04432804463693693 * this.yDotK[11][j] + -3.4046500868740456E-4 * this.yDotK[12][j] + 0.1413124436746325 * this.yDotKLast[0][j];
            yTmp[j] = this.currentState[j] + this.h * s2;
        }
        this.equations.computeDerivatives(this.previousTime + 0.2 * this.h, yTmp, this.yDotKLast[1]);
        for (j = 0; j < this.currentState.length; ++j) {
            s2 = -0.4831900357003607 * this.yDotK[0][j] + -9.147934308113573 * this.yDotK[5][j] + 5.791903296748099 * this.yDotK[6][j] + 9.870193778407696 * this.yDotK[7][j] + 0.04556282049746119 * this.yDotK[8][j] + 0.1521609496625161 * this.yDotK[9][j] + -0.20136540080403034 * this.yDotK[10][j] + -0.04471061572777259 * this.yDotK[11][j] + -0.0013990241651590145 * this.yDotK[12][j] + 2.9475147891527724 * this.yDotKLast[0][j] + -9.15095847217987 * this.yDotKLast[1][j];
            yTmp[j] = this.currentState[j] + this.h * s2;
        }
        this.equations.computeDerivatives(this.previousTime + 0.7777777777777778 * this.h, yTmp, this.yDotKLast[2]);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        try {
            this.finalizeStep();
        }
        catch (DerivativeException e) {
            throw new IOException(e.getMessage());
        }
        out.writeInt(this.currentState.length);
        for (int i = 0; i < this.currentState.length; ++i) {
            out.writeDouble(this.yDotKLast[0][i]);
            out.writeDouble(this.yDotKLast[1][i]);
            out.writeDouble(this.yDotKLast[2][i]);
        }
        super.writeExternal(out);
    }

    public void readExternal(ObjectInput in) throws IOException {
        this.yDotKLast = new double[3][];
        int dimension = in.readInt();
        this.yDotKLast[0] = new double[dimension];
        this.yDotKLast[1] = new double[dimension];
        this.yDotKLast[2] = new double[dimension];
        for (int i = 0; i < dimension; ++i) {
            this.yDotKLast[0][i] = in.readDouble();
            this.yDotKLast[1][i] = in.readDouble();
            this.yDotKLast[2][i] = in.readDouble();
        }
        super.readExternal(in);
    }
}

