/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.ode;

import org.apache.commons.math.ode.AbstractStepInterpolator;
import org.apache.commons.math.ode.AdaptiveStepsizeIntegrator;
import org.apache.commons.math.ode.DerivativeException;
import org.apache.commons.math.ode.DummyStepInterpolator;
import org.apache.commons.math.ode.FirstOrderDifferentialEquations;
import org.apache.commons.math.ode.IntegratorException;
import org.apache.commons.math.ode.RungeKuttaStepInterpolator;

public abstract class EmbeddedRungeKuttaIntegrator
extends AdaptiveStepsizeIntegrator {
    private boolean fsal;
    private double[] c;
    private double[][] a;
    private double[] b;
    private RungeKuttaStepInterpolator prototype;
    private double exp;
    private double safety;
    private double minReduction;
    private double maxGrowth;

    protected EmbeddedRungeKuttaIntegrator(boolean fsal, double[] c, double[][] a, double[] b, RungeKuttaStepInterpolator prototype, double minStep, double maxStep, double scalAbsoluteTolerance, double scalRelativeTolerance) {
        super(minStep, maxStep, scalAbsoluteTolerance, scalRelativeTolerance);
        this.fsal = fsal;
        this.c = c;
        this.a = a;
        this.b = b;
        this.prototype = prototype;
        this.exp = -1.0 / (double)this.getOrder();
        this.setSafety(0.9);
        this.setMinReduction(0.2);
        this.setMaxGrowth(10.0);
    }

    protected EmbeddedRungeKuttaIntegrator(boolean fsal, double[] c, double[][] a, double[] b, RungeKuttaStepInterpolator prototype, double minStep, double maxStep, double[] vecAbsoluteTolerance, double[] vecRelativeTolerance) {
        super(minStep, maxStep, vecAbsoluteTolerance, vecRelativeTolerance);
        this.fsal = fsal;
        this.c = c;
        this.a = a;
        this.b = b;
        this.prototype = prototype;
        this.exp = -1.0 / (double)this.getOrder();
        this.setSafety(0.9);
        this.setMinReduction(0.2);
        this.setMaxGrowth(10.0);
    }

    public abstract String getName();

    public abstract int getOrder();

    public double getSafety() {
        return this.safety;
    }

    public void setSafety(double safety) {
        this.safety = safety;
    }

    public void integrate(FirstOrderDifferentialEquations equations, double t0, double[] y0, double t2, double[] y) throws DerivativeException, IntegratorException {
        boolean lastStep;
        AbstractStepInterpolator interpolator;
        this.sanityChecks(equations, t0, y0, t2, y);
        boolean forward = t2 > t0;
        int stages = this.c.length + 1;
        if (y != y0) {
            System.arraycopy(y0, 0, y, 0, y0.length);
        }
        double[][] yDotK = new double[stages][];
        for (int i = 0; i < stages; ++i) {
            yDotK[i] = new double[y0.length];
        }
        double[] yTmp = new double[y0.length];
        if (this.handler.requiresDenseOutput() || !this.switchesHandler.isEmpty()) {
            RungeKuttaStepInterpolator rki = (RungeKuttaStepInterpolator)this.prototype.copy();
            rki.reinitialize(equations, yTmp, yDotK, forward);
            interpolator = rki;
        } else {
            interpolator = new DummyStepInterpolator(yTmp, forward);
        }
        interpolator.storeTime(t0);
        this.stepStart = t0;
        double hNew = 0.0;
        boolean firstTime = true;
        this.handler.reset();
        do {
            interpolator.shift();
            double error = 0.0;
            boolean loop = true;
            while (loop) {
                if (firstTime || !this.fsal) {
                    equations.computeDerivatives(this.stepStart, y, yDotK[0]);
                }
                if (firstTime) {
                    double[] scale;
                    if (this.vecAbsoluteTolerance != null) {
                        scale = this.vecAbsoluteTolerance;
                    } else {
                        scale = new double[y0.length];
                        for (int i = 0; i < scale.length; ++i) {
                            scale[i] = this.scalAbsoluteTolerance;
                        }
                    }
                    hNew = this.initializeStep(equations, forward, this.getOrder(), scale, this.stepStart, y, yDotK[0], yTmp, yDotK[1]);
                    firstTime = false;
                }
                this.stepSize = hNew;
                if (forward && this.stepStart + this.stepSize > t2 || !forward && this.stepStart + this.stepSize < t2) {
                    this.stepSize = t2 - this.stepStart;
                }
                for (int k = 1; k < stages; ++k) {
                    for (int j = 0; j < y0.length; ++j) {
                        double sum = this.a[k - 1][0] * yDotK[0][j];
                        for (int l = 1; l < k; ++l) {
                            sum += this.a[k - 1][l] * yDotK[l][j];
                        }
                        yTmp[j] = y[j] + this.stepSize * sum;
                    }
                    equations.computeDerivatives(this.stepStart + this.c[k - 1] * this.stepSize, yTmp, yDotK[k]);
                }
                for (int j = 0; j < y0.length; ++j) {
                    double sum = this.b[0] * yDotK[0][j];
                    for (int l = 1; l < stages; ++l) {
                        sum += this.b[l] * yDotK[l][j];
                    }
                    yTmp[j] = y[j] + this.stepSize * sum;
                }
                error = this.estimateError(yDotK, y, yTmp, this.stepSize);
                if (error <= 1.0) {
                    interpolator.storeTime(this.stepStart + this.stepSize);
                    if (this.switchesHandler.evaluateStep(interpolator)) {
                        hNew = this.switchesHandler.getEventTime() - this.stepStart;
                        continue;
                    }
                    loop = false;
                    continue;
                }
                double factor = Math.min(this.maxGrowth, Math.max(this.minReduction, this.safety * Math.pow(error, this.exp)));
                hNew = this.filterStep(this.stepSize * factor, false);
            }
            double nextStep = this.stepStart + this.stepSize;
            System.arraycopy(yTmp, 0, y, 0, y0.length);
            this.switchesHandler.stepAccepted(nextStep, y);
            lastStep = this.switchesHandler.stop() ? true : (forward ? nextStep >= t2 : nextStep <= t2);
            interpolator.storeTime(nextStep);
            this.handler.handleStep(interpolator, lastStep);
            this.stepStart = nextStep;
            if (this.fsal) {
                System.arraycopy(yDotK[stages - 1], 0, yDotK[0], 0, y0.length);
            }
            if (this.switchesHandler.reset(this.stepStart, y) && !lastStep) {
                equations.computeDerivatives(this.stepStart, y, yDotK[0]);
            }
            if (lastStep) continue;
            double factor = Math.min(this.maxGrowth, Math.max(this.minReduction, this.safety * Math.pow(error, this.exp)));
            double scaledH = this.stepSize * factor;
            double nextT = this.stepStart + scaledH;
            boolean nextIsLast = forward ? nextT >= t2 : nextT <= t2;
            hNew = this.filterStep(scaledH, nextIsLast);
        } while (!lastStep);
        this.resetInternalState();
    }

    public double getMinReduction() {
        return this.minReduction;
    }

    public void setMinReduction(double minReduction) {
        this.minReduction = minReduction;
    }

    public double getMaxGrowth() {
        return this.maxGrowth;
    }

    public void setMaxGrowth(double maxGrowth) {
        this.maxGrowth = maxGrowth;
    }

    protected abstract double estimateError(double[][] var1, double[] var2, double[] var3, double var4);
}

