/*
 * Decompiled with CFR 0.152.
 */
package ucar.ma2;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.ForbiddenConversionException;
import ucar.ma2.Index;
import ucar.ma2.Index0D;
import ucar.ma2.Index1D;
import ucar.ma2.Index2D;
import ucar.ma2.Index3D;
import ucar.ma2.Index4D;
import ucar.ma2.Index5D;
import ucar.ma2.Index6D;
import ucar.ma2.Index7D;
import ucar.ma2.IndexIterator;

public class ArrayInt
extends Array {
    protected int[] storage;

    static ArrayInt factory(Index index, boolean isUnsigned) {
        return ArrayInt.factory(index, isUnsigned, null);
    }

    static ArrayInt factory(Index index, boolean isUnsigned, int[] storage) {
        if (index instanceof Index0D) {
            return new D0(index, isUnsigned, storage);
        }
        if (index instanceof Index1D) {
            return new D1(index, isUnsigned, storage);
        }
        if (index instanceof Index2D) {
            return new D2(index, isUnsigned, storage);
        }
        if (index instanceof Index3D) {
            return new D3(index, isUnsigned, storage);
        }
        if (index instanceof Index4D) {
            return new D4(index, isUnsigned, storage);
        }
        if (index instanceof Index5D) {
            return new D5(index, isUnsigned, storage);
        }
        if (index instanceof Index6D) {
            return new D6(index, isUnsigned, storage);
        }
        if (index instanceof Index7D) {
            return new D7(index, isUnsigned, storage);
        }
        return new ArrayInt(index, isUnsigned, storage);
    }

    public ArrayInt(int[] dimensions, boolean isUnsigned) {
        super(isUnsigned ? DataType.UINT : DataType.INT, dimensions);
        this.storage = new int[(int)this.indexCalc.getSize()];
    }

    ArrayInt(Index ima, boolean isUnsigned, int[] data) {
        super(isUnsigned ? DataType.UINT : DataType.INT, ima);
        this.storage = data != null ? data : new int[(int)ima.getSize()];
    }

    @Override
    protected Array createView(Index index) {
        return ArrayInt.factory(index, this.isUnsigned(), this.storage);
    }

    @Override
    public Object getStorage() {
        return this.storage;
    }

    @Override
    protected void copyFrom1DJavaArray(IndexIterator iter, Object javaArray) {
        int[] ja;
        for (int aJa : ja = (int[])javaArray) {
            iter.setIntNext(aJa);
        }
    }

    @Override
    protected void copyTo1DJavaArray(IndexIterator iter, Object javaArray) {
        int[] ja = (int[])javaArray;
        for (int i = 0; i < ja.length; ++i) {
            ja[i] = iter.getIntNext();
        }
    }

    @Override
    public ByteBuffer getDataAsByteBuffer() {
        return this.getDataAsByteBuffer(null);
    }

    @Override
    public ByteBuffer getDataAsByteBuffer(ByteOrder order) {
        ByteBuffer bb = super.getDataAsByteBuffer((int)(4L * this.getSize()), order);
        IntBuffer ib = bb.asIntBuffer();
        ib.put((int[])this.get1DJavaArray(Integer.TYPE));
        return bb;
    }

    @Override
    public Class getElementType() {
        return Integer.TYPE;
    }

    public int get(Index i) {
        return this.storage[i.currentElement()];
    }

    public void set(Index i, int value) {
        this.storage[i.currentElement()] = value;
    }

    @Override
    public double getDouble(Index i) {
        int val = this.storage[i.currentElement()];
        return this.isUnsigned() ? DataType.unsignedIntToLong(val) : (long)val;
    }

    @Override
    public void setDouble(Index i, double value) {
        this.storage[i.currentElement()] = (int)value;
    }

    @Override
    public float getFloat(Index i) {
        int val = this.storage[i.currentElement()];
        return this.isUnsigned() ? DataType.unsignedIntToLong(val) : (long)val;
    }

    @Override
    public void setFloat(Index i, float value) {
        this.storage[i.currentElement()] = (int)value;
    }

    @Override
    public long getLong(Index i) {
        int val = this.storage[i.currentElement()];
        return this.isUnsigned() ? DataType.unsignedIntToLong(val) : (long)val;
    }

    @Override
    public void setLong(Index i, long value) {
        this.storage[i.currentElement()] = (int)value;
    }

    @Override
    public int getInt(Index i) {
        return this.storage[i.currentElement()];
    }

    @Override
    public void setInt(Index i, int value) {
        this.storage[i.currentElement()] = value;
    }

    @Override
    public short getShort(Index i) {
        return (short)this.storage[i.currentElement()];
    }

    @Override
    public void setShort(Index i, short value) {
        this.storage[i.currentElement()] = value;
    }

    @Override
    public byte getByte(Index i) {
        return (byte)this.storage[i.currentElement()];
    }

    @Override
    public void setByte(Index i, byte value) {
        this.storage[i.currentElement()] = value;
    }

    @Override
    public char getChar(Index i) {
        return (char)this.storage[i.currentElement()];
    }

    @Override
    public void setChar(Index i, char value) {
        this.storage[i.currentElement()] = value;
    }

    @Override
    public boolean getBoolean(Index i) {
        throw new ForbiddenConversionException();
    }

    @Override
    public void setBoolean(Index i, boolean value) {
        throw new ForbiddenConversionException();
    }

    @Override
    public Object getObject(Index i) {
        return this.storage[i.currentElement()];
    }

    @Override
    public void setObject(Index i, Object value) {
        this.storage[i.currentElement()] = ((Number)value).intValue();
    }

    @Override
    public double getDouble(int index) {
        int val = this.storage[index];
        return this.isUnsigned() ? DataType.unsignedIntToLong(val) : (long)val;
    }

    @Override
    public void setDouble(int index, double value) {
        this.storage[index] = (int)value;
    }

    @Override
    public float getFloat(int index) {
        int val = this.storage[index];
        return this.isUnsigned() ? DataType.unsignedIntToLong(val) : (long)val;
    }

    @Override
    public void setFloat(int index, float value) {
        this.storage[index] = (int)value;
    }

    @Override
    public long getLong(int index) {
        int val = this.storage[index];
        return this.isUnsigned() ? DataType.unsignedIntToLong(val) : (long)val;
    }

    @Override
    public void setLong(int index, long value) {
        this.storage[index] = (int)value;
    }

    @Override
    public int getInt(int index) {
        return this.storage[index];
    }

    @Override
    public void setInt(int index, int value) {
        this.storage[index] = value;
    }

    @Override
    public short getShort(int index) {
        return (short)this.storage[index];
    }

    @Override
    public void setShort(int index, short value) {
        this.storage[index] = value;
    }

    @Override
    public byte getByte(int index) {
        return (byte)this.storage[index];
    }

    @Override
    public void setByte(int index, byte value) {
        this.storage[index] = value;
    }

    @Override
    public char getChar(int index) {
        return (char)this.storage[index];
    }

    @Override
    public void setChar(int index, char value) {
        this.storage[index] = value;
    }

    @Override
    public boolean getBoolean(int index) {
        throw new ForbiddenConversionException();
    }

    @Override
    public void setBoolean(int index, boolean value) {
        throw new ForbiddenConversionException();
    }

    @Override
    public Object getObject(int index) {
        return this.getInt(index);
    }

    @Override
    public void setObject(int index, Object value) {
        this.storage[index] = ((Number)value).intValue();
    }

    public static class D7
    extends ArrayInt {
        private Index7D ix;

        public D7(int len0, int len1, int len2, int len3, int len4, int len5, int len6, boolean isUnsigned) {
            super(new int[]{len0, len1, len2, len3, len4, len5, len6}, isUnsigned);
            this.ix = (Index7D)this.indexCalc;
        }

        private D7(Index i, boolean isUnsigned, int[] store) {
            super(i, isUnsigned, store);
            this.ix = (Index7D)this.indexCalc;
        }

        public int get(int i, int j, int k, int l, int m4, int n, int o) {
            return this.storage[this.ix.setDirect(i, j, k, l, m4, n, o)];
        }

        public void set(int i, int j, int k, int l, int m4, int n, int o, int value) {
            this.storage[this.ix.setDirect((int)i, (int)j, (int)k, (int)l, (int)m4, (int)n, (int)o)] = value;
        }
    }

    public static class D6
    extends ArrayInt {
        private Index6D ix;

        public D6(int len0, int len1, int len2, int len3, int len4, int len5, boolean isUnsigned) {
            super(new int[]{len0, len1, len2, len3, len4, len5}, isUnsigned);
            this.ix = (Index6D)this.indexCalc;
        }

        private D6(Index i, boolean isUnsigned, int[] store) {
            super(i, isUnsigned, store);
            this.ix = (Index6D)this.indexCalc;
        }

        public int get(int i, int j, int k, int l, int m4, int n) {
            return this.storage[this.ix.setDirect(i, j, k, l, m4, n)];
        }

        public void set(int i, int j, int k, int l, int m4, int n, int value) {
            this.storage[this.ix.setDirect((int)i, (int)j, (int)k, (int)l, (int)m4, (int)n)] = value;
        }
    }

    public static class D5
    extends ArrayInt {
        private Index5D ix;

        public D5(int len0, int len1, int len2, int len3, int len4, boolean isUnsigned) {
            super(new int[]{len0, len1, len2, len3, len4}, isUnsigned);
            this.ix = (Index5D)this.indexCalc;
        }

        private D5(Index i, boolean isUnsigned, int[] store) {
            super(i, isUnsigned, store);
            this.ix = (Index5D)this.indexCalc;
        }

        public int get(int i, int j, int k, int l, int m4) {
            return this.storage[this.ix.setDirect(i, j, k, l, m4)];
        }

        public void set(int i, int j, int k, int l, int m4, int value) {
            this.storage[this.ix.setDirect((int)i, (int)j, (int)k, (int)l, (int)m4)] = value;
        }
    }

    public static class D4
    extends ArrayInt {
        private Index4D ix;

        public D4(int len0, int len1, int len2, int len3, boolean isUnsigned) {
            super(new int[]{len0, len1, len2, len3}, isUnsigned);
            this.ix = (Index4D)this.indexCalc;
        }

        private D4(Index i, boolean isUnsigned, int[] store) {
            super(i, isUnsigned, store);
            this.ix = (Index4D)this.indexCalc;
        }

        public int get(int i, int j, int k, int l) {
            return this.storage[this.ix.setDirect(i, j, k, l)];
        }

        public void set(int i, int j, int k, int l, int value) {
            this.storage[this.ix.setDirect((int)i, (int)j, (int)k, (int)l)] = value;
        }
    }

    public static class D3
    extends ArrayInt {
        private Index3D ix;

        public D3(int len0, int len1, int len2, boolean isUnsigned) {
            super(new int[]{len0, len1, len2}, isUnsigned);
            this.ix = (Index3D)this.indexCalc;
        }

        private D3(Index i, boolean isUnsigned, int[] store) {
            super(i, isUnsigned, store);
            this.ix = (Index3D)this.indexCalc;
        }

        public int get(int i, int j, int k) {
            return this.storage[this.ix.setDirect(i, j, k)];
        }

        public void set(int i, int j, int k, int value) {
            this.storage[this.ix.setDirect((int)i, (int)j, (int)k)] = value;
        }
    }

    public static class D2
    extends ArrayInt {
        private Index2D ix;

        public D2(int len0, int len1, boolean isUnsigned) {
            super(new int[]{len0, len1}, isUnsigned);
            this.ix = (Index2D)this.indexCalc;
        }

        private D2(Index i, boolean isUnsigned, int[] store) {
            super(i, isUnsigned, store);
            this.ix = (Index2D)this.indexCalc;
        }

        public int get(int i, int j) {
            return this.storage[this.ix.setDirect(i, j)];
        }

        public void set(int i, int j, int value) {
            this.storage[this.ix.setDirect((int)i, (int)j)] = value;
        }
    }

    public static class D1
    extends ArrayInt {
        private Index1D ix;

        public D1(int len0, boolean isUnsigned) {
            super(new int[]{len0}, isUnsigned);
            this.ix = (Index1D)this.indexCalc;
        }

        private D1(Index i, boolean isUnsigned, int[] store) {
            super(i, isUnsigned, store);
            this.ix = (Index1D)this.indexCalc;
        }

        public int get(int i) {
            return this.storage[this.ix.setDirect(i)];
        }

        public void set(int i, int value) {
            this.storage[this.ix.setDirect((int)i)] = value;
        }
    }

    public static class D0
    extends ArrayInt {
        private Index0D ix;

        public D0(boolean isUnsigned) {
            super(new int[0], isUnsigned);
            this.ix = (Index0D)this.indexCalc;
        }

        private D0(Index i, boolean isUnsigned, int[] store) {
            super(i, isUnsigned, store);
            this.ix = (Index0D)this.indexCalc;
        }

        public int get() {
            return this.storage[this.ix.currentElement()];
        }

        public void set(int value) {
            this.storage[this.ix.currentElement()] = value;
        }
    }
}

