/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.datagen;

import java.math.BigDecimal;
import java.util.Random;
import org.hibernate.SessionFactory;
import org.hibernate.tool.datagen.ValueGenerator;

public class NumberGenerator
implements ValueGenerator {
    private BigDecimal start = new BigDecimal(Integer.MIN_VALUE);
    private BigDecimal end = new BigDecimal(Integer.MAX_VALUE);
    Random random = new Random();
    Class returnedType = Integer.class;

    public NumberGenerator setReturnedType(Class returnedType) {
        this.returnedType = returnedType;
        return this;
    }

    public Object generate(SessionFactory sf) {
        BigDecimal result = null;
        BigDecimal delta = this.end.subtract(this.start);
        BigDecimal factor = new BigDecimal(this.random.nextDouble());
        result = delta.multiply(factor).add(this.start);
        if (this.returnedType == Integer.class) {
            return new Integer(result.intValue());
        }
        if (this.returnedType == Long.class) {
            return new Long(result.intValue());
        }
        if (this.returnedType == Short.class) {
            return new Short(result.shortValue());
        }
        if (this.returnedType == Float.class) {
            return new Float(result.floatValue());
        }
        if (this.returnedType == Double.class) {
            return new Double(result.doubleValue());
        }
        throw new IllegalStateException(this.returnedType + " not supported by NumberGenerator");
    }

    public NumberGenerator setInterval(int start, int end) {
        this.setInterval(new BigDecimal(start), new BigDecimal(end));
        return this;
    }

    public void setInterval(BigDecimal start, BigDecimal end) {
        this.start = start;
        this.end = end;
    }
}

