/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.swing.gvt;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.image.BufferedImage;
import java.text.CharacterIterator;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JComponent;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.event.AWTEventDispatcher;
import org.apache.batik.gvt.event.EventDispatcher;
import org.apache.batik.gvt.event.SelectionAdapter;
import org.apache.batik.gvt.event.SelectionEvent;
import org.apache.batik.gvt.renderer.ConcreteImageRendererFactory;
import org.apache.batik.gvt.renderer.ImageRenderer;
import org.apache.batik.gvt.renderer.ImageRendererFactory;
import org.apache.batik.gvt.text.Mark;
import org.apache.batik.swing.gvt.AbstractZoomInteractor;
import org.apache.batik.swing.gvt.GVTTreeRenderer;
import org.apache.batik.swing.gvt.GVTTreeRendererEvent;
import org.apache.batik.swing.gvt.GVTTreeRendererListener;
import org.apache.batik.swing.gvt.Interactor;
import org.apache.batik.swing.gvt.JGVTComponentListener;
import org.apache.batik.swing.gvt.Overlay;
import org.apache.batik.swing.gvt.TextSelectionManager;
import org.apache.batik.util.HaltingThread;
import org.apache.batik.util.Platform;

public class JGVTComponent
extends JComponent {
    protected Listener listener;
    protected GVTTreeRenderer gvtTreeRenderer;
    protected GraphicsNode gvtRoot;
    protected ImageRendererFactory rendererFactory = new ConcreteImageRendererFactory();
    protected ImageRenderer renderer;
    protected List gvtTreeRendererListeners = Collections.synchronizedList(new LinkedList());
    protected boolean needRender;
    protected boolean progressivePaint;
    protected HaltingThread progressivePaintThread;
    protected BufferedImage image;
    protected AffineTransform initialTransform = new AffineTransform();
    protected AffineTransform renderingTransform = new AffineTransform();
    protected AffineTransform paintingTransform;
    protected List interactors = new LinkedList();
    protected Interactor interactor;
    protected List overlays = new LinkedList();
    protected List jgvtListeners = null;
    protected AWTEventDispatcher eventDispatcher;
    protected TextSelectionManager textSelectionManager;
    protected boolean doubleBufferedRendering;
    protected boolean eventsEnabled;
    protected boolean selectableText;
    protected boolean useUnixTextSelection = true;
    protected boolean suspendInteractions;
    protected boolean disableInteractions;

    public JGVTComponent() {
        this(false, false);
    }

    public JGVTComponent(boolean bl, boolean bl2) {
        this.setBackground(Color.white);
        this.eventsEnabled = bl;
        this.selectableText = bl2;
        this.listener = this.createListener();
        this.addAWTListeners();
        this.addGVTTreeRendererListener(this.listener);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                if (JGVTComponent.this.updateRenderingTransform()) {
                    JGVTComponent.this.scheduleGVTRendering();
                }
            }
        });
    }

    protected Listener createListener() {
        return new Listener();
    }

    protected void addAWTListeners() {
        this.addKeyListener(this.listener);
        this.addMouseListener(this.listener);
        this.addMouseMotionListener(this.listener);
        this.addMouseWheelListener(this.listener);
    }

    public void setDisableInteractions(boolean bl) {
        this.disableInteractions = bl;
    }

    public boolean getDisableInteractions() {
        return this.disableInteractions;
    }

    public void setUseUnixTextSelection(boolean bl) {
        this.useUnixTextSelection = bl;
    }

    public void getUseUnixTextSelection(boolean bl) {
        this.useUnixTextSelection = bl;
    }

    public List getInteractors() {
        return this.interactors;
    }

    public List getOverlays() {
        return this.overlays;
    }

    public BufferedImage getOffScreen() {
        return this.image;
    }

    public void addJGVTComponentListener(JGVTComponentListener jGVTComponentListener) {
        if (this.jgvtListeners == null) {
            this.jgvtListeners = new LinkedList();
        }
        this.jgvtListeners.add(jGVTComponentListener);
    }

    public void removeJGVTComponentListener(JGVTComponentListener jGVTComponentListener) {
        if (this.jgvtListeners == null) {
            return;
        }
        this.jgvtListeners.remove(jGVTComponentListener);
    }

    public void resetRenderingTransform() {
        this.setRenderingTransform(this.initialTransform);
    }

    public void stopProcessing() {
        if (this.gvtTreeRenderer != null) {
            this.needRender = false;
            this.gvtTreeRenderer.halt();
            this.haltProgressivePaintThread();
        }
    }

    public GraphicsNode getGraphicsNode() {
        return this.gvtRoot;
    }

    public void setGraphicsNode(GraphicsNode graphicsNode) {
        this.setGraphicsNode(graphicsNode, true);
        this.initialTransform = new AffineTransform();
        this.updateRenderingTransform();
        this.setRenderingTransform(this.initialTransform, true);
    }

    protected void setGraphicsNode(GraphicsNode graphicsNode, boolean bl) {
        this.gvtRoot = graphicsNode;
        if (graphicsNode != null && bl) {
            this.initializeEventHandling();
        }
        if (this.eventDispatcher != null) {
            this.eventDispatcher.setRootNode(graphicsNode);
        }
    }

    protected void initializeEventHandling() {
        if (this.eventsEnabled) {
            this.eventDispatcher = this.createEventDispatcher();
            if (this.selectableText) {
                this.textSelectionManager = this.createTextSelectionManager(this.eventDispatcher);
                this.textSelectionManager.addSelectionListener(new UnixTextSelectionListener());
            }
        }
    }

    protected AWTEventDispatcher createEventDispatcher() {
        return new AWTEventDispatcher();
    }

    protected TextSelectionManager createTextSelectionManager(EventDispatcher eventDispatcher) {
        return new TextSelectionManager(this, eventDispatcher);
    }

    public TextSelectionManager getTextSelectionManager() {
        return this.textSelectionManager;
    }

    public void setSelectionOverlayColor(Color color) {
        if (this.textSelectionManager != null) {
            this.textSelectionManager.setSelectionOverlayColor(color);
        }
    }

    public Color getSelectionOverlayColor() {
        if (this.textSelectionManager != null) {
            return this.textSelectionManager.getSelectionOverlayColor();
        }
        return null;
    }

    public void setSelectionOverlayStrokeColor(Color color) {
        if (this.textSelectionManager != null) {
            this.textSelectionManager.setSelectionOverlayStrokeColor(color);
        }
    }

    public Color getSelectionOverlayStrokeColor() {
        if (this.textSelectionManager != null) {
            return this.textSelectionManager.getSelectionOverlayStrokeColor();
        }
        return null;
    }

    public void setSelectionOverlayXORMode(boolean bl) {
        if (this.textSelectionManager != null) {
            this.textSelectionManager.setSelectionOverlayXORMode(bl);
        }
    }

    public boolean isSelectionOverlayXORMode() {
        if (this.textSelectionManager != null) {
            return this.textSelectionManager.isSelectionOverlayXORMode();
        }
        return false;
    }

    public void select(Mark mark, Mark mark2) {
        if (this.textSelectionManager != null) {
            this.textSelectionManager.setSelection(mark, mark2);
        }
    }

    public void deselectAll() {
        if (this.textSelectionManager != null) {
            this.textSelectionManager.clearSelection();
        }
    }

    public void setProgressivePaint(boolean bl) {
        if (this.progressivePaint != bl) {
            this.progressivePaint = bl;
            this.haltProgressivePaintThread();
        }
    }

    public boolean getProgressivePaint() {
        return this.progressivePaint;
    }

    public Rectangle getRenderRect() {
        Dimension dimension = this.getSize();
        return new Rectangle(0, 0, dimension.width, dimension.height);
    }

    public void immediateRepaint() {
        if (EventQueue.isDispatchThread()) {
            Rectangle rectangle = this.getRenderRect();
            if (this.doubleBufferedRendering) {
                this.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            } else {
                this.paintImmediately(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
        } else {
            try {
                EventQueue.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        Rectangle rectangle = JGVTComponent.this.getRenderRect();
                        if (JGVTComponent.this.doubleBufferedRendering) {
                            JGVTComponent.this.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                        } else {
                            JGVTComponent.this.paintImmediately(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                        }
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        Rectangle rectangle = this.getRenderRect();
        graphics2D.setComposite(AlphaComposite.SrcOver);
        graphics2D.setPaint(this.getBackground());
        graphics2D.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        if (this.image != null) {
            if (this.paintingTransform != null) {
                graphics2D.transform(this.paintingTransform);
            }
            graphics2D.drawRenderedImage(this.image, null);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            Iterator iterator = this.overlays.iterator();
            while (iterator.hasNext()) {
                ((Overlay)iterator.next()).paint(graphics);
            }
        }
    }

    public void setPaintingTransform(AffineTransform affineTransform) {
        this.paintingTransform = affineTransform;
        this.immediateRepaint();
    }

    public AffineTransform getPaintingTransform() {
        return this.paintingTransform;
    }

    public void setRenderingTransform(AffineTransform affineTransform) {
        this.setRenderingTransform(affineTransform, true);
    }

    public void setRenderingTransform(AffineTransform affineTransform, boolean bl) {
        this.renderingTransform = new AffineTransform(affineTransform);
        this.suspendInteractions = true;
        if (this.eventDispatcher != null) {
            try {
                this.eventDispatcher.setBaseTransform(this.renderingTransform.createInverse());
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                this.handleException(noninvertibleTransformException);
            }
        }
        if (this.jgvtListeners != null) {
            Iterator iterator = this.jgvtListeners.iterator();
            ComponentEvent componentEvent = new ComponentEvent(this, 1337);
            while (iterator.hasNext()) {
                JGVTComponentListener jGVTComponentListener = (JGVTComponentListener)iterator.next();
                jGVTComponentListener.componentTransformChanged(componentEvent);
            }
        }
        if (bl) {
            this.scheduleGVTRendering();
        }
    }

    public AffineTransform getInitialTransform() {
        return new AffineTransform(this.initialTransform);
    }

    public AffineTransform getRenderingTransform() {
        return new AffineTransform(this.renderingTransform);
    }

    public void setDoubleBufferedRendering(boolean bl) {
        this.doubleBufferedRendering = bl;
    }

    public boolean getDoubleBufferedRendering() {
        return this.doubleBufferedRendering;
    }

    public void addGVTTreeRendererListener(GVTTreeRendererListener gVTTreeRendererListener) {
        this.gvtTreeRendererListeners.add(gVTTreeRendererListener);
    }

    public void removeGVTTreeRendererListener(GVTTreeRendererListener gVTTreeRendererListener) {
        this.gvtTreeRendererListeners.remove(gVTTreeRendererListener);
    }

    public void flush() {
        this.renderer.flush();
    }

    public void flush(Rectangle rectangle) {
        this.renderer.flush(rectangle);
    }

    protected ImageRenderer createImageRenderer() {
        return this.rendererFactory.createStaticImageRenderer();
    }

    protected void renderGVTTree() {
        AffineTransform affineTransform;
        Rectangle rectangle = this.getRenderRect();
        if (this.gvtRoot == null || rectangle.width <= 0 || rectangle.height <= 0) {
            return;
        }
        if (this.renderer == null || this.renderer.getTree() != this.gvtRoot) {
            this.renderer = this.createImageRenderer();
            this.renderer.setTree(this.gvtRoot);
        }
        try {
            affineTransform = this.renderingTransform.createInverse();
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            throw new IllegalStateException("NoninvertibleTransformEx:" + noninvertibleTransformException.getMessage());
        }
        Shape shape = affineTransform.createTransformedShape(rectangle);
        this.gvtTreeRenderer = new GVTTreeRenderer(this.renderer, this.renderingTransform, this.doubleBufferedRendering, shape, rectangle.width, rectangle.height);
        this.gvtTreeRenderer.setPriority(1);
        Iterator iterator = this.gvtTreeRendererListeners.iterator();
        while (iterator.hasNext()) {
            this.gvtTreeRenderer.addGVTTreeRendererListener((GVTTreeRendererListener)iterator.next());
        }
        if (this.eventDispatcher != null) {
            this.eventDispatcher.setEventDispatchEnabled(false);
        }
        this.gvtTreeRenderer.start();
    }

    protected boolean computeRenderingTransform() {
        this.initialTransform = new AffineTransform();
        if (!this.initialTransform.equals(this.renderingTransform)) {
            this.setRenderingTransform(this.initialTransform, false);
            return true;
        }
        return false;
    }

    protected boolean updateRenderingTransform() {
        return false;
    }

    protected void handleException(Exception exception) {
    }

    protected void releaseRenderingReferences() {
        this.eventDispatcher = null;
        if (this.textSelectionManager != null) {
            this.overlays.remove(this.textSelectionManager.getSelectionOverlay());
            this.textSelectionManager = null;
        }
        this.renderer = null;
        this.image = null;
        this.gvtRoot = null;
    }

    protected void scheduleGVTRendering() {
        if (this.gvtTreeRenderer != null) {
            this.needRender = true;
            this.gvtTreeRenderer.halt();
        } else {
            this.renderGVTTree();
        }
    }

    private void haltProgressivePaintThread() {
        if (this.progressivePaintThread != null) {
            this.progressivePaintThread.halt();
            this.progressivePaintThread = null;
        }
    }

    protected class UnixTextSelectionListener
    extends SelectionAdapter {
        protected UnixTextSelectionListener() {
        }

        @Override
        public void selectionDone(SelectionEvent selectionEvent) {
            int n;
            if (!JGVTComponent.this.useUnixTextSelection) {
                return;
            }
            Object object = selectionEvent.getSelection();
            if (!(object instanceof CharacterIterator)) {
                return;
            }
            CharacterIterator characterIterator = (CharacterIterator)object;
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                try {
                    securityManager.checkSystemClipboardAccess();
                }
                catch (SecurityException securityException) {
                    return;
                }
            }
            if ((n = characterIterator.getEndIndex() - characterIterator.getBeginIndex()) == 0) {
                return;
            }
            char[] cArray = new char[n];
            cArray[0] = characterIterator.first();
            for (int i = 1; i < cArray.length; ++i) {
                cArray[i] = characterIterator.next();
            }
            final String string = new String(cArray);
            new Thread(){

                @Override
                public void run() {
                    Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                    StringSelection stringSelection = new StringSelection(string);
                    clipboard.setContents(stringSelection, stringSelection);
                }
            }.start();
        }
    }

    protected class Listener
    implements GVTTreeRendererListener,
    KeyListener,
    MouseListener,
    MouseMotionListener,
    MouseWheelListener {
        boolean checkClick = false;
        boolean hadDrag = false;
        int startX;
        int startY;
        long startTime;
        long fakeClickTime;
        int MAX_DISP = 16;
        long CLICK_TIME = 200L;

        protected Listener() {
        }

        @Override
        public void gvtRenderingPrepare(GVTTreeRendererEvent gVTTreeRendererEvent) {
            JGVTComponent.this.suspendInteractions = true;
            if (!JGVTComponent.this.progressivePaint && !JGVTComponent.this.doubleBufferedRendering) {
                JGVTComponent.this.image = null;
            }
        }

        @Override
        public void gvtRenderingStarted(GVTTreeRendererEvent gVTTreeRendererEvent) {
            if (JGVTComponent.this.progressivePaint && !JGVTComponent.this.doubleBufferedRendering) {
                JGVTComponent.this.image = gVTTreeRendererEvent.getImage();
                JGVTComponent.this.progressivePaintThread = new HaltingThread(){

                    @Override
                    public void run() {
                        final 1 var1_1 = this;
                        try {
                            while (!1.hasBeenHalted()) {
                                EventQueue.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        if (JGVTComponent.this.progressivePaintThread == var1_1) {
                                            Rectangle rectangle = JGVTComponent.this.getRenderRect();
                                            JGVTComponent.this.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                                        }
                                    }
                                });
                                1.sleep(200L);
                            }
                        }
                        catch (InterruptedException interruptedException) {
                        }
                        catch (ThreadDeath threadDeath) {
                            throw threadDeath;
                        }
                        catch (Throwable throwable) {
                            throwable.printStackTrace();
                        }
                    }
                };
                JGVTComponent.this.progressivePaintThread.setPriority(2);
                JGVTComponent.this.progressivePaintThread.start();
            }
            if (!JGVTComponent.this.doubleBufferedRendering) {
                JGVTComponent.this.paintingTransform = null;
                JGVTComponent.this.suspendInteractions = false;
            }
        }

        @Override
        public void gvtRenderingCompleted(GVTTreeRendererEvent gVTTreeRendererEvent) {
            JGVTComponent.this.haltProgressivePaintThread();
            if (JGVTComponent.this.doubleBufferedRendering) {
                JGVTComponent.this.paintingTransform = null;
                JGVTComponent.this.suspendInteractions = false;
            }
            JGVTComponent.this.gvtTreeRenderer = null;
            if (JGVTComponent.this.needRender) {
                JGVTComponent.this.renderGVTTree();
                JGVTComponent.this.needRender = false;
            } else {
                JGVTComponent.this.image = gVTTreeRendererEvent.getImage();
                JGVTComponent.this.immediateRepaint();
            }
            if (JGVTComponent.this.eventDispatcher != null) {
                JGVTComponent.this.eventDispatcher.setEventDispatchEnabled(true);
            }
        }

        @Override
        public void gvtRenderingCancelled(GVTTreeRendererEvent gVTTreeRendererEvent) {
            this.renderingStopped();
        }

        @Override
        public void gvtRenderingFailed(GVTTreeRendererEvent gVTTreeRendererEvent) {
            this.renderingStopped();
        }

        private void renderingStopped() {
            JGVTComponent.this.haltProgressivePaintThread();
            if (JGVTComponent.this.doubleBufferedRendering) {
                JGVTComponent.this.suspendInteractions = false;
            }
            JGVTComponent.this.gvtTreeRenderer = null;
            if (JGVTComponent.this.needRender) {
                JGVTComponent.this.renderGVTTree();
                JGVTComponent.this.needRender = false;
            } else {
                JGVTComponent.this.immediateRepaint();
            }
            if (JGVTComponent.this.eventDispatcher != null) {
                JGVTComponent.this.eventDispatcher.setEventDispatchEnabled(true);
            }
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
            this.selectInteractor(keyEvent);
            if (JGVTComponent.this.interactor != null) {
                JGVTComponent.this.interactor.keyTyped(keyEvent);
                this.deselectInteractor();
            } else if (JGVTComponent.this.eventDispatcher != null) {
                this.dispatchKeyTyped(keyEvent);
            }
        }

        protected void dispatchKeyTyped(KeyEvent keyEvent) {
            JGVTComponent.this.eventDispatcher.keyTyped(keyEvent);
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            this.selectInteractor(keyEvent);
            if (JGVTComponent.this.interactor != null) {
                JGVTComponent.this.interactor.keyPressed(keyEvent);
                this.deselectInteractor();
            } else if (JGVTComponent.this.eventDispatcher != null) {
                this.dispatchKeyPressed(keyEvent);
            }
        }

        protected void dispatchKeyPressed(KeyEvent keyEvent) {
            JGVTComponent.this.eventDispatcher.keyPressed(keyEvent);
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
            this.selectInteractor(keyEvent);
            if (JGVTComponent.this.interactor != null) {
                JGVTComponent.this.interactor.keyReleased(keyEvent);
                this.deselectInteractor();
            } else if (JGVTComponent.this.eventDispatcher != null) {
                this.dispatchKeyReleased(keyEvent);
            }
        }

        protected void dispatchKeyReleased(KeyEvent keyEvent) {
            JGVTComponent.this.eventDispatcher.keyReleased(keyEvent);
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (this.fakeClickTime != mouseEvent.getWhen()) {
                this.handleMouseClicked(mouseEvent);
            }
        }

        public void handleMouseClicked(MouseEvent mouseEvent) {
            this.selectInteractor(mouseEvent);
            if (JGVTComponent.this.interactor != null) {
                JGVTComponent.this.interactor.mouseClicked(mouseEvent);
                this.deselectInteractor();
            } else if (JGVTComponent.this.eventDispatcher != null) {
                this.dispatchMouseClicked(mouseEvent);
            }
        }

        protected void dispatchMouseClicked(MouseEvent mouseEvent) {
            JGVTComponent.this.eventDispatcher.mouseClicked(mouseEvent);
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            this.startX = mouseEvent.getX();
            this.startY = mouseEvent.getY();
            this.startTime = mouseEvent.getWhen();
            this.checkClick = true;
            this.selectInteractor(mouseEvent);
            if (JGVTComponent.this.interactor != null) {
                JGVTComponent.this.interactor.mousePressed(mouseEvent);
                this.deselectInteractor();
            } else if (JGVTComponent.this.eventDispatcher != null) {
                this.dispatchMousePressed(mouseEvent);
            }
        }

        protected void dispatchMousePressed(MouseEvent mouseEvent) {
            JGVTComponent.this.eventDispatcher.mousePressed(mouseEvent);
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (this.checkClick && this.hadDrag) {
                int n = this.startX - mouseEvent.getX();
                int n2 = this.startY - mouseEvent.getY();
                long l = mouseEvent.getWhen();
                if (n * n + n2 * n2 < this.MAX_DISP && l - this.startTime < this.CLICK_TIME) {
                    MouseEvent mouseEvent2 = new MouseEvent(mouseEvent.getComponent(), 500, mouseEvent.getWhen(), mouseEvent.getModifiers(), mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
                    this.fakeClickTime = mouseEvent2.getWhen();
                    this.handleMouseClicked(mouseEvent2);
                }
            }
            this.checkClick = false;
            this.hadDrag = false;
            this.selectInteractor(mouseEvent);
            if (JGVTComponent.this.interactor != null) {
                JGVTComponent.this.interactor.mouseReleased(mouseEvent);
                this.deselectInteractor();
            } else if (JGVTComponent.this.eventDispatcher != null) {
                this.dispatchMouseReleased(mouseEvent);
            }
        }

        protected void dispatchMouseReleased(MouseEvent mouseEvent) {
            JGVTComponent.this.eventDispatcher.mouseReleased(mouseEvent);
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            this.selectInteractor(mouseEvent);
            if (JGVTComponent.this.interactor != null) {
                JGVTComponent.this.interactor.mouseEntered(mouseEvent);
                this.deselectInteractor();
            } else if (JGVTComponent.this.eventDispatcher != null) {
                this.dispatchMouseEntered(mouseEvent);
            }
        }

        protected void dispatchMouseEntered(MouseEvent mouseEvent) {
            JGVTComponent.this.eventDispatcher.mouseEntered(mouseEvent);
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            this.selectInteractor(mouseEvent);
            if (JGVTComponent.this.interactor != null) {
                JGVTComponent.this.interactor.mouseExited(mouseEvent);
                this.deselectInteractor();
            } else if (JGVTComponent.this.eventDispatcher != null) {
                this.dispatchMouseExited(mouseEvent);
            }
        }

        protected void dispatchMouseExited(MouseEvent mouseEvent) {
            JGVTComponent.this.eventDispatcher.mouseExited(mouseEvent);
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            int n;
            this.hadDrag = true;
            int n2 = this.startX - mouseEvent.getX();
            if (n2 * n2 + (n = this.startY - mouseEvent.getY()) * n > this.MAX_DISP) {
                this.checkClick = false;
            }
            this.selectInteractor(mouseEvent);
            if (JGVTComponent.this.interactor != null) {
                JGVTComponent.this.interactor.mouseDragged(mouseEvent);
                this.deselectInteractor();
            } else if (JGVTComponent.this.eventDispatcher != null) {
                this.dispatchMouseDragged(mouseEvent);
            }
        }

        protected void dispatchMouseDragged(MouseEvent mouseEvent) {
            JGVTComponent.this.eventDispatcher.mouseDragged(mouseEvent);
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            this.selectInteractor(mouseEvent);
            if (JGVTComponent.this.interactor != null) {
                if (Platform.isOSX && JGVTComponent.this.interactor instanceof AbstractZoomInteractor) {
                    this.mouseDragged(mouseEvent);
                } else {
                    JGVTComponent.this.interactor.mouseMoved(mouseEvent);
                }
                this.deselectInteractor();
            } else if (JGVTComponent.this.eventDispatcher != null) {
                this.dispatchMouseMoved(mouseEvent);
            }
        }

        protected void dispatchMouseMoved(MouseEvent mouseEvent) {
            JGVTComponent.this.eventDispatcher.mouseMoved(mouseEvent);
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
            if (JGVTComponent.this.eventDispatcher != null) {
                this.dispatchMouseWheelMoved(mouseWheelEvent);
            }
        }

        protected void dispatchMouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
            JGVTComponent.this.eventDispatcher.mouseWheelMoved(mouseWheelEvent);
        }

        protected void selectInteractor(InputEvent inputEvent) {
            if (!JGVTComponent.this.disableInteractions && !JGVTComponent.this.suspendInteractions && JGVTComponent.this.interactor == null && JGVTComponent.this.gvtRoot != null) {
                for (Interactor interactor : JGVTComponent.this.interactors) {
                    if (!interactor.startInteraction(inputEvent)) continue;
                    JGVTComponent.this.interactor = interactor;
                    break;
                }
            }
        }

        protected void deselectInteractor() {
            if (JGVTComponent.this.interactor.endInteraction()) {
                JGVTComponent.this.interactor = null;
            }
        }
    }
}

