/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.Method;

public class FinalizerNullsFields
extends BytecodeScanningDetector {
    BugReporter bugReporter;
    int state = 0;
    boolean sawAnythingElse;
    boolean inFinalize;
    boolean sawFieldNulling;

    public FinalizerNullsFields(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visit(Method obj) {
        this.inFinalize = obj.getName().equals("finalize");
    }

    public void visit(Field obj) {
    }

    public void visit(Code obj) {
        this.state = 0;
        this.sawAnythingElse = false;
        this.sawFieldNulling = false;
        if (this.inFinalize) {
            super.visit(obj);
            if (!this.sawAnythingElse && this.sawFieldNulling) {
                BugInstance bug = new BugInstance((Detector)this, "FI_FINALIZER_ONLY_NULLS_FIELDS", 1).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this);
                this.bugReporter.reportBug(bug);
            }
        }
    }

    public void sawOpcode(int seen) {
        if (this.state == 0 && seen == 42) {
            ++this.state;
        } else if (this.state == 1 && seen == 1) {
            ++this.state;
        } else if (this.state == 2 && seen == 181) {
            BugInstance bug = new BugInstance((Detector)this, "FI_FINALIZER_NULLS_FIELDS", 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this).addReferencedField((DismantleBytecode)this);
            this.bugReporter.reportBug(bug);
            this.sawFieldNulling = true;
            this.state = 0;
        } else if (seen == 177) {
            this.state = 0;
        } else {
            this.state = 0;
            this.sawAnythingElse = true;
        }
    }
}

