/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugAccumulator;
import edu.umd.cs.findbugs.BugAnnotation;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.FindBugsAnalysisFeatures;
import edu.umd.cs.findbugs.LocalVariableAnnotation;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.CFGBuilderException;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.LiveLocalStoreAnalysis;
import edu.umd.cs.findbugs.ba.LiveLocalStoreDataflow;
import edu.umd.cs.findbugs.ba.Location;
import edu.umd.cs.findbugs.ba.type.TypeAnalysis;
import edu.umd.cs.findbugs.ba.type.TypeDataflow;
import edu.umd.cs.findbugs.ba.type.TypeFrame;
import edu.umd.cs.findbugs.detect.DeadLocalStoreProperty;
import edu.umd.cs.findbugs.props.WarningProperty;
import edu.umd.cs.findbugs.props.WarningPropertySet;
import edu.umd.cs.findbugs.props.WarningPropertyUtil;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.LocalVariable;
import org.apache.bcel.classfile.LocalVariableTable;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ACONST_NULL;
import org.apache.bcel.generic.ALOAD;
import org.apache.bcel.generic.ANEWARRAY;
import org.apache.bcel.generic.ASTORE;
import org.apache.bcel.generic.BasicType;
import org.apache.bcel.generic.ConstantPushInstruction;
import org.apache.bcel.generic.GETFIELD;
import org.apache.bcel.generic.IINC;
import org.apache.bcel.generic.INVOKESPECIAL;
import org.apache.bcel.generic.IndexedInstruction;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InvokeInstruction;
import org.apache.bcel.generic.LDC;
import org.apache.bcel.generic.LoadInstruction;
import org.apache.bcel.generic.MULTIANEWARRAY;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.NEWARRAY;
import org.apache.bcel.generic.StoreInstruction;
import org.apache.bcel.generic.Type;

public class FindDeadLocalStores
implements Detector {
    private static final boolean DEBUG = SystemProperties.getBoolean((String)"fdls.debug");
    private static final String FINDBUGS_EXCLUDED_LOCALS_PROP_NAME = "findbugs.dls.exclusions";
    private static final Set<String> EXCLUDED_LOCALS = new HashSet<String>();
    private static final boolean DO_EXCLUDE_LOCALS = SystemProperties.getProperty((String)"findbugs.dls.exclusions") != null;
    private static final boolean SUPPRESS_IF_AT_LEAST_ONE_LIVE_STORE_ON_LINE;
    private static final BitSet defensiveConstantValueOpcodes;
    private BugReporter bugReporter;

    public FindDeadLocalStores(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
        if (DEBUG) {
            System.out.println("Debugging FindDeadLocalStores detector");
        }
    }

    private boolean prescreen(ClassContext classContext, Method method) {
        return true;
    }

    public void visitClassContext(ClassContext classContext) {
        Method[] methodList;
        JavaClass javaClass = classContext.getJavaClass();
        Method[] arr$ = methodList = javaClass.getMethods();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Method method = arr$[i$];
            MethodGen methodGen = classContext.getMethodGen(method);
            if (methodGen == null || !this.prescreen(classContext, method)) continue;
            try {
                this.analyzeMethod(classContext, method);
                continue;
            }
            catch (DataflowAnalysisException e) {
                this.bugReporter.logError("Error analyzing " + method.toString(), (Throwable)e);
                continue;
            }
            catch (CFGBuilderException e) {
                this.bugReporter.logError("Error analyzing " + method.toString(), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void analyzeMethod(ClassContext classContext, Method method) throws DataflowAnalysisException, CFGBuilderException {
        if (DEBUG) {
            System.out.println("    Analyzing method " + classContext.getJavaClass().getClassName() + "." + method.getName());
        }
        JavaClass javaClass = classContext.getJavaClass();
        BugAccumulator accumulator = new BugAccumulator(this.bugReporter);
        LiveLocalStoreDataflow llsaDataflow = classContext.getLiveLocalStoreDataflow(method);
        int numLocals = method.getCode().getMaxLocals();
        int[] localStoreCount = new int[numLocals];
        int[] localLoadCount = new int[numLocals];
        int[] localIncrementCount = new int[numLocals];
        MethodGen methodGen = classContext.getMethodGen(method);
        CFG cfg = classContext.getCFG(method);
        BitSet liveStoreSetAtEntry = (BitSet)((LiveLocalStoreAnalysis)llsaDataflow.getAnalysis()).getResultFact(cfg.getEntry());
        BitSet complainedAbout = new BitSet();
        TypeDataflow typeDataflow = classContext.getTypeDataflow(method);
        int localsThatAreParameters = PreorderVisitor.getNumberArguments((String)method.getSignature());
        if (!method.isStatic()) {
            ++localsThatAreParameters;
        }
        this.countLocalStoresLoadsAndIncrements(localStoreCount, localLoadCount, localIncrementCount, cfg);
        int i = 0;
        while (i < localsThatAreParameters) {
            int n = i++;
            localStoreCount[n] = localStoreCount[n] + 1;
        }
        BitSet liveStoreSourceLineSet = new BitSet();
        Iterator i2 = cfg.locationIterator();
        while (i2.hasNext()) {
            boolean parameterThatIsDeadAtEntry;
            String name;
            SourceLineAnnotation sourceLineAnnotation;
            LocalVariableAnnotation lvAnnotation;
            BitSet liveStoreSet;
            int local;
            IndexedInstruction ins;
            WarningPropertySet propertySet;
            BugInstance pendingBugReportAboutOverwrittenParameter;
            Location location;
            block49: {
                boolean isParameter;
                boolean storeLive;
                block48: {
                    block47: {
                        location = (Location)i2.next();
                        pendingBugReportAboutOverwrittenParameter = null;
                        propertySet = new WarningPropertySet();
                        if (this.isStore(location)) break block47;
                        if (pendingBugReportAboutOverwrittenParameter == null) continue;
                        this.bugReporter.reportBug(pendingBugReportAboutOverwrittenParameter);
                        continue;
                    }
                    if (location.getBasicBlock().isExceptionHandler()) {
                        propertySet.addProperty((WarningProperty)DeadLocalStoreProperty.EXCEPTION_HANDLER);
                    }
                    ins = (IndexedInstruction)location.getHandle().getInstruction();
                    local = ins.getIndex();
                    liveStoreSet = (BitSet)((LiveLocalStoreAnalysis)llsaDataflow.getAnalysis()).getFactAtLocation(location);
                    storeLive = ((LiveLocalStoreAnalysis)llsaDataflow.getAnalysis()).isStoreAlive(liveStoreSet, local);
                    lvAnnotation = LocalVariableAnnotation.getLocalVariableAnnotation((Method)method, (Location)location, (IndexedInstruction)ins);
                    sourceLineAnnotation = SourceLineAnnotation.fromVisitedInstruction((ClassContext)classContext, (MethodGen)methodGen, (String)javaClass.getSourceFileName(), (InstructionHandle)location.getHandle());
                    if (DEBUG) {
                        System.out.println("    Store at " + sourceLineAnnotation.getStartLine() + "@" + location.getHandle().getPosition() + " is " + (storeLive ? "live" : "dead"));
                    }
                    if (storeLive && sourceLineAnnotation.getStartLine() > 0) {
                        liveStoreSourceLineSet.set(sourceLineAnnotation.getStartLine());
                    }
                    if ((name = lvAnnotation.getName()).charAt(0) == '$' || name.charAt(0) == '_') {
                        propertySet.addProperty((WarningProperty)DeadLocalStoreProperty.SYNTHETIC_NAME);
                    }
                    if (!EXCLUDED_LOCALS.contains(name)) break block48;
                    if (pendingBugReportAboutOverwrittenParameter == null) continue;
                    this.bugReporter.reportBug(pendingBugReportAboutOverwrittenParameter);
                    continue;
                }
                propertySet.setProperty((WarningProperty)DeadLocalStoreProperty.LOCAL_NAME, name);
                boolean bl = isParameter = local < localsThatAreParameters;
                if (isParameter) {
                    propertySet.addProperty((WarningProperty)DeadLocalStoreProperty.IS_PARAMETER);
                }
                boolean bl2 = parameterThatIsDeadAtEntry = isParameter && !((LiveLocalStoreAnalysis)llsaDataflow.getAnalysis()).isStoreAlive(liveStoreSetAtEntry, local);
                if (parameterThatIsDeadAtEntry && !complainedAbout.get(local)) {
                    pendingBugReportAboutOverwrittenParameter = new BugInstance((Detector)this, "IP_PARAMETER_IS_DEAD_BUT_OVERWRITTEN", storeLive ? 2 : 1).addClassAndMethod(methodGen, javaClass.getSourceFileName()).add((BugAnnotation)lvAnnotation).addSourceLine(classContext, methodGen, javaClass.getSourceFileName(), location.getHandle());
                    complainedAbout.set(local);
                }
                if (!storeLive) break block49;
                if (pendingBugReportAboutOverwrittenParameter == null) continue;
                this.bugReporter.reportBug(pendingBugReportAboutOverwrittenParameter);
                continue;
            }
            try {
                int priority;
                Instruction prevIns;
                boolean killedBySubsequentStore;
                TypeFrame typeFrame = (TypeFrame)((TypeAnalysis)typeDataflow.getAnalysis()).getFactAtLocation(location);
                Type typeOfValue = null;
                if (typeFrame.isValid() && typeFrame.getStackDepth() > 0) {
                    typeOfValue = TypeFrame.getTopType();
                }
                boolean storeOfNull = false;
                InstructionHandle prevInsHandle = location.getHandle().getPrev();
                if (prevInsHandle != null) {
                    Instruction prevIns2 = prevInsHandle.getInstruction();
                    if (prevIns2 instanceof LDC || prevIns2 instanceof ConstantPushInstruction) {
                        propertySet.addProperty((WarningProperty)DeadLocalStoreProperty.STORE_OF_CONSTANT);
                    } else if (prevIns2 instanceof ACONST_NULL) {
                        storeOfNull = true;
                        propertySet.addProperty((WarningProperty)DeadLocalStoreProperty.STORE_OF_NULL);
                    }
                }
                Field[] arr$ = javaClass.getFields();
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    Field f = arr$[i$];
                    if (!f.getName().equals(name)) continue;
                    propertySet.addProperty((WarningProperty)DeadLocalStoreProperty.SHADOWS_FIELD);
                    break;
                }
                if (typeOfValue instanceof BasicType || Type.STRING.equals((Object)typeOfValue)) {
                    propertySet.addProperty((WarningProperty)DeadLocalStoreProperty.BASE_VALUE);
                }
                if (killedBySubsequentStore = ((LiveLocalStoreAnalysis)llsaDataflow.getAnalysis()).killedByStore(liveStoreSet, local)) {
                    propertySet.addProperty((WarningProperty)DeadLocalStoreProperty.KILLED_BY_SUBSEQUENT_STORE);
                }
                InstructionHandle prev = location.getBasicBlock().getPredecessorOf(location.getHandle());
                int prevOpCode = -1;
                if (prev != null) {
                    InstructionHandle prev2;
                    if (defensiveConstantValueOpcodes.get(prev.getInstruction().getOpcode())) {
                        propertySet.addProperty((WarningProperty)DeadLocalStoreProperty.DEFENSIVE_CONSTANT_OPCODE);
                        prevOpCode = prev.getInstruction().getOpcode();
                    }
                    if (prev.getInstruction() instanceof GETFIELD && (prev2 = prev.getPrev()) != null && prev2.getInstruction() instanceof ALOAD) {
                        propertySet.addProperty((WarningProperty)DeadLocalStoreProperty.CACHING_VALUE);
                    }
                    if (prev.getInstruction() instanceof LoadInstruction) {
                        propertySet.addProperty((WarningProperty)DeadLocalStoreProperty.COPY_VALUE);
                    }
                    if (prev.getInstruction() instanceof InvokeInstruction) {
                        propertySet.addProperty((WarningProperty)DeadLocalStoreProperty.METHOD_RESULT);
                    }
                }
                boolean deadObjectStore = false;
                if (ins instanceof IINC) {
                    propertySet.addProperty((WarningProperty)DeadLocalStoreProperty.DEAD_INCREMENT);
                    if (localIncrementCount[local] == 1) {
                        propertySet.addProperty((WarningProperty)DeadLocalStoreProperty.SINGLE_DEAD_INCREMENT);
                    } else {
                        propertySet.removeProperty((WarningProperty)DeadLocalStoreProperty.IS_PARAMETER);
                    }
                } else if (ins instanceof ASTORE && prev != null && ((prevIns = prev.getInstruction()) instanceof INVOKESPECIAL && ((INVOKESPECIAL)prevIns).getMethodName(methodGen.getConstantPool()).equals("<init>") || prevIns instanceof ANEWARRAY || prevIns instanceof NEWARRAY || prevIns instanceof MULTIANEWARRAY)) {
                    deadObjectStore = true;
                }
                if (deadObjectStore) {
                    propertySet.addProperty((WarningProperty)DeadLocalStoreProperty.DEAD_OBJECT_STORE);
                } else if (!killedBySubsequentStore && localStoreCount[local] == 2 && localLoadCount[local] > 0) {
                    propertySet.addProperty((WarningProperty)DeadLocalStoreProperty.TWO_STORES_MULTIPLE_LOADS);
                } else if (!parameterThatIsDeadAtEntry && localStoreCount[local] == 1 && localLoadCount[local] == 0 && propertySet.containsProperty((WarningProperty)DeadLocalStoreProperty.DEFENSIVE_CONSTANT_OPCODE)) {
                    propertySet.addProperty((WarningProperty)DeadLocalStoreProperty.SINGLE_STORE);
                } else if (!parameterThatIsDeadAtEntry && !propertySet.containsProperty((WarningProperty)DeadLocalStoreProperty.SHADOWS_FIELD) && localLoadCount[local] == 0) {
                    propertySet.addProperty((WarningProperty)DeadLocalStoreProperty.NO_LOADS);
                }
                if (parameterThatIsDeadAtEntry) {
                    propertySet.addProperty((WarningProperty)DeadLocalStoreProperty.PARAM_DEAD_ON_ENTRY);
                    if (pendingBugReportAboutOverwrittenParameter != null) {
                        pendingBugReportAboutOverwrittenParameter.setPriority(1);
                    }
                }
                if (localStoreCount[local] > 3) {
                    propertySet.addProperty((WarningProperty)DeadLocalStoreProperty.MANY_STORES);
                }
                if ((priority = propertySet.computePriority(2)) <= 4) {
                    BugInstance bugInstance = new BugInstance((Detector)this, storeOfNull ? "DLS_DEAD_LOCAL_STORE_OF_NULL" : "DLS_DEAD_LOCAL_STORE", priority).addClassAndMethod(methodGen, javaClass.getSourceFileName()).add((BugAnnotation)lvAnnotation);
                    if (FindBugsAnalysisFeatures.isRelaxedMode()) {
                        WarningPropertyUtil.addPropertiesForLocation((WarningPropertySet)propertySet, (ClassContext)classContext, (Method)method, (Location)location);
                        propertySet.decorateBugInstance(bugInstance);
                    }
                    if (DEBUG) {
                        System.out.println(javaClass.getSourceFileName() + " : " + methodGen.getName());
                        System.out.println("priority: " + priority);
                        System.out.println("Reporting " + bugInstance);
                        System.out.println(propertySet);
                    }
                    accumulator.accumulateBug(bugInstance, sourceLineAnnotation);
                }
                if (pendingBugReportAboutOverwrittenParameter == null) continue;
            }
            catch (Throwable throwable) {
                if (pendingBugReportAboutOverwrittenParameter != null) {
                    this.bugReporter.reportBug(pendingBugReportAboutOverwrittenParameter);
                }
                throw throwable;
            }
            this.bugReporter.reportBug(pendingBugReportAboutOverwrittenParameter);
        }
        this.suppressWarningsIfOneLiveStoreOnLine(accumulator, liveStoreSourceLineSet);
        accumulator.reportAccumulatedBugs();
    }

    private void suppressWarningsIfOneLiveStoreOnLine(BugAccumulator accumulator, BitSet liveStoreSourceLineSet) {
        if (!SUPPRESS_IF_AT_LEAST_ONE_LIVE_STORE_ON_LINE) {
            return;
        }
        Iterator i = accumulator.entrySetIterator();
        block0: while (i.hasNext()) {
            Map.Entry entry = (Map.Entry)i.next();
            Iterator i$ = ((List)entry.getValue()).iterator();
            while (i$.hasNext()) {
                SourceLineAnnotation annotation = (SourceLineAnnotation)i$.next();
                if (!liveStoreSourceLineSet.get(annotation.getStartLine())) continue;
                i.remove();
                continue block0;
            }
        }
    }

    private void countLocalStoresLoadsAndIncrements(int[] localStoreCount, int[] localLoadCount, int[] localIncrementCount, CFG cfg) {
        Iterator i = cfg.locationIterator();
        while (i.hasNext()) {
            Location location = (Location)i.next();
            if (location.getBasicBlock().isExceptionHandler()) continue;
            boolean isStore = this.isStore(location);
            boolean isLoad = this.isLoad(location);
            if (!isStore && !isLoad) continue;
            IndexedInstruction ins = (IndexedInstruction)location.getHandle().getInstruction();
            int local = ins.getIndex();
            if (ins instanceof IINC) {
                int n = local;
                localStoreCount[n] = localStoreCount[n] + 1;
                int n2 = local;
                localLoadCount[n2] = localLoadCount[n2] + 1;
                int n3 = local;
                localIncrementCount[n3] = localIncrementCount[n3] + 1;
                continue;
            }
            if (isStore) {
                int n = local;
                localStoreCount[n] = localStoreCount[n] + 1;
                continue;
            }
            int n = local;
            localLoadCount[n] = localLoadCount[n] + 1;
        }
    }

    private void checkLocalVariableName(LocalVariableTable lvt, int local, int pc, WarningPropertySet propertySet) {
        LocalVariable lv;
        if (lvt != null && (lv = lvt.getLocalVariable(local, pc)) != null) {
            String localName = lv.getName();
            propertySet.setProperty((WarningProperty)DeadLocalStoreProperty.LOCAL_NAME, localName);
        }
    }

    private boolean isStore(Location location) {
        Instruction ins = location.getHandle().getInstruction();
        return ins instanceof StoreInstruction || ins instanceof IINC;
    }

    private boolean isLoad(Location location) {
        Instruction ins = location.getHandle().getInstruction();
        return ins instanceof LoadInstruction || ins instanceof IINC;
    }

    public void report() {
    }

    static {
        String exclLocalsProperty = SystemProperties.getProperty((String)FINDBUGS_EXCLUDED_LOCALS_PROP_NAME);
        if (exclLocalsProperty != null) {
            EXCLUDED_LOCALS.addAll(Arrays.asList(exclLocalsProperty.split(",")));
            EXCLUDED_LOCALS.remove("");
        }
        SUPPRESS_IF_AT_LEAST_ONE_LIVE_STORE_ON_LINE = SystemProperties.getBoolean((String)"findbugs.dls.suppressIfOneLiveStore");
        defensiveConstantValueOpcodes = new BitSet();
        defensiveConstantValueOpcodes.set(14);
        defensiveConstantValueOpcodes.set(15);
        defensiveConstantValueOpcodes.set(11);
        defensiveConstantValueOpcodes.set(12);
        defensiveConstantValueOpcodes.set(1);
        defensiveConstantValueOpcodes.set(3);
        defensiveConstantValueOpcodes.set(4);
        defensiveConstantValueOpcodes.set(18);
    }
}

