/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.StatelessDetector;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.generic.Type;

public class InefficientMemberAccess
extends BytecodeScanningDetector
implements StatelessDetector {
    public static final String ACCESS_PREFIX = "access$";
    private BugReporter bugReporter;
    private String clsName;

    public InefficientMemberAccess(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitClassContext(ClassContext classContext) {
        JavaClass cls = classContext.getJavaClass();
        this.clsName = cls.getClassName();
        if (this.clsName.indexOf("$") >= 0) {
            super.visitClassContext(classContext);
        }
    }

    public void sawOpcode(int seen) {
        if (seen == 184) {
            String methodName = this.getNameConstantOperand();
            if (!methodName.startsWith(ACCESS_PREFIX)) {
                return;
            }
            String methodSig = this.getSigConstantOperand();
            Type[] argTypes = Type.getArgumentTypes((String)methodSig);
            if (argTypes.length < 1 || argTypes.length > 2) {
                return;
            }
            String parCls = argTypes[0].getSignature();
            if (parCls.length() < 3) {
                return;
            }
            if (!(parCls = parCls.substring(1, parCls.length() - 1)).equals(this.getClassConstantOperand())) {
                return;
            }
            if (argTypes.length == 2 && !argTypes[1].getSignature().equals(Type.getReturnType((String)methodSig).getSignature())) {
                return;
            }
            this.bugReporter.reportBug(new BugInstance((Detector)this, "IMA_INEFFICIENT_MEMBER_ACCESS", 3).addClassAndMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
        }
    }
}

