/*
 * Decompiled with CFR 0.152.
 */
package ucar.bufr;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import ucar.bufr.BufrDataDescriptionSection;
import ucar.bufr.BufrDataSection;
import ucar.bufr.TimeObservation;
import ucar.unidata.io.RandomAccessFile;

public final class BufrDataExtractor {
    private final RandomAccessFile raf;
    private final String MasterTableFilename;
    private HashMap bufrdatas = null;
    private ArrayList dorder = null;

    public BufrDataExtractor(RandomAccessFile raf, String MasterTableFilename) {
        this.raf = raf;
        this.MasterTableFilename = MasterTableFilename;
    }

    public final boolean getData(long DDSOffset, long ObsOffset, int bitPos, int bitBuf) throws IOException {
        this.raf.seek(DDSOffset);
        BufrDataDescriptionSection dds = new BufrDataDescriptionSection(this.raf);
        this.raf.seek(ObsOffset);
        BufrDataSection ds = new BufrDataSection(this.raf, this.MasterTableFilename);
        if (ds.readOneObs(dds, bitPos, bitBuf)) {
            TimeObservation to = new TimeObservation(dds, ds);
            this.dorder = ds.getDorder();
            this.bufrdatas = ds.getBufrDatas();
            return true;
        }
        return false;
    }

    public final HashMap getBufrDatas() {
        return this.bufrdatas;
    }

    public final ArrayList getDorder() {
        return this.dorder;
    }
}

