/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.application.action;

import application.ResourceMap;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.File;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.SwingUtilities;
import org.jhotdraw.application.DocumentView;
import org.jhotdraw.application.action.AbstractApplicationAction;

public class FocusAction
extends AbstractApplicationAction {
    public static final String ID = "View.focus";
    private DocumentView documentView;

    public FocusAction(DocumentView documentView) {
        this.documentView = documentView;
        this.initActionProperties(ID);
        this.setEnabled(documentView != null);
        documentView.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                ResourceMap labels = FocusAction.this.getResourceMap();
                String name = evt.getPropertyName();
                if (name.equals("file")) {
                    FocusAction.this.putValue("Name", evt.getNewValue() == null ? labels.getString("File.unnamedFile", new Object[0]) : ((File)evt.getNewValue()).getName());
                }
            }
        });
    }

    public Object getValue(String key) {
        if (key == "Name" && this.documentView != null) {
            return this.getTitle();
        }
        return super.getValue(key);
    }

    private String getTitle() {
        String title = this.documentView.getName();
        if (this.documentView.isModified()) {
            title = title + " *";
        }
        return title;
    }

    private JFrame getFrame() {
        return (JFrame)SwingUtilities.getWindowAncestor(this.documentView.getComponent());
    }

    private Component getRootPaneContainer() {
        return SwingUtilities.getRootPane(this.documentView.getComponent()).getParent();
    }

    public void actionPerformed(ActionEvent evt) {
        Component rpContainer = this.getRootPaneContainer();
        if (rpContainer instanceof Frame) {
            Frame frame = (Frame)rpContainer;
            frame.setExtendedState(frame.getExtendedState() & 0xFFFFFFFE);
            frame.toFront();
        } else if (rpContainer instanceof JInternalFrame) {
            JInternalFrame frame = (JInternalFrame)rpContainer;
            frame.toFront();
            try {
                frame.setSelected(true);
            }
            catch (PropertyVetoException e) {
                // empty catch block
            }
        }
        this.documentView.getComponent().requestFocusInWindow();
    }
}

