/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.application.action;

import java.awt.Frame;
import java.io.File;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.jhotdraw.application.DocumentOrientedApplication;
import org.jhotdraw.application.DocumentView;
import org.jhotdraw.application.action.AbstractSaveBeforeAction;
import org.jhotdraw.gui.JSheet;
import org.jhotdraw.gui.Worker;
import org.jhotdraw.gui.event.SheetEvent;
import org.jhotdraw.gui.event.SheetListener;

public class LoadRecentAction
extends AbstractSaveBeforeAction {
    public static final String ID = "File.loadRecent";
    private File file;

    public LoadRecentAction(File file) {
        this.file = file;
        this.putValue("Name", file.getName());
    }

    public void doIt(final DocumentView documentView) {
        DocumentOrientedApplication application = this.getApplication();
        application.setEnabled(true);
        documentView.execute(new Worker(){

            public Object construct() {
                try {
                    documentView.read(LoadRecentAction.this.file);
                    return null;
                }
                catch (Throwable e) {
                    return e;
                }
            }

            public void finished(Object value) {
                LoadRecentAction.this.fileOpened(documentView, LoadRecentAction.this.file, value);
            }
        });
    }

    protected void fileOpened(DocumentView documentView, File file, Object value) {
        DocumentOrientedApplication application = this.getApplication();
        if (value == null) {
            documentView.setFile(file);
            documentView.setEnabled(true);
            Frame w = (Frame)SwingUtilities.getWindowAncestor(documentView.getComponent());
            if (w != null) {
                w.setExtendedState(w.getExtendedState() & 0xFFFFFFFE);
                w.toFront();
            }
            documentView.getComponent().requestFocus();
            if (application != null) {
                application.setEnabled(true);
            }
        } else {
            if (value instanceof Throwable) {
                ((Throwable)value).printStackTrace();
            }
            JSheet.showMessageSheet(documentView.getComponent(), "<html>" + UIManager.getString("OptionPane.css") + "<b>Couldn't open the file \"" + file + "\".</b><br>" + value, 0, new SheetListener(){

                public void optionSelected(SheetEvent evt) {
                }
            });
        }
    }
}

