/*
 * Decompiled with CFR 0.152.
 */
package ucar.grib.grib1;

import java.io.IOException;
import ucar.grib.GribNumbers;
import ucar.grib.NoValidGribException;
import ucar.grib.NotSupportedException;
import ucar.grib.QuasiRegular;
import ucar.grib.grib1.Grib1BinaryDataSection;
import ucar.grib.grib1.Grib1BitMapSection;
import ucar.grib.grib1.Grib1GridDefinitionSection;
import ucar.unidata.io.RandomAccessFile;

public final class Grib1Data {
    private RandomAccessFile raf = null;
    private boolean isThin = false;

    public Grib1Data(RandomAccessFile raf) {
        this.raf = raf;
    }

    public final float[] getData(long offset, int decimalScale, boolean bmsExists) throws NotSupportedException, IOException {
        Grib1GridDefinitionSection gds = null;
        try {
            this.raf.seek(offset);
            int length = GribNumbers.uint3(this.raf);
            int NV = this.raf.read();
            int P_VorL = this.raf.read();
            if (length < 50) {
                this.raf.skipBytes(length - 5);
            } else if (length < 1000 && !bmsExists) {
                if (P_VorL != 255) {
                    this.raf.skipBytes(-5);
                    gds = new Grib1GridDefinitionSection(this.raf);
                    this.isThin = gds.getIsThin();
                } else {
                    this.raf.skipBytes(length - 5);
                }
            } else if (length == NV * 4 + 32) {
                this.raf.skipBytes(length - 5);
            } else if (length < 600) {
                if (P_VorL != 255) {
                    this.raf.skipBytes(-5);
                    gds = new Grib1GridDefinitionSection(this.raf);
                    this.isThin = gds.getIsThin();
                } else {
                    this.raf.skipBytes(length - 5);
                }
            } else {
                this.raf.seek(offset);
            }
        }
        catch (NoValidGribException nvge) {
            System.out.println("gds exception was caught");
            this.raf.seek(offset);
        }
        Grib1BitMapSection bms = null;
        if (bmsExists) {
            bms = new Grib1BitMapSection(this.raf);
        }
        Grib1BinaryDataSection bds = new Grib1BinaryDataSection(this.raf, decimalScale, bms);
        if (this.isThin) {
            QuasiRegular qr = new QuasiRegular(bds.getValues(), gds);
            return qr.getData();
        }
        return bds.getValues();
    }
}

