/*
 * Decompiled with CFR 0.152.
 */
package ucar.grib.grib2;

import java.util.Date;
import ucar.grib.Index;
import ucar.grib.Parameter;
import ucar.grib.TableLookup;
import ucar.grib.grib2.Grib2DataRepresentationSection;
import ucar.grib.grib2.Grib2GridDefinitionSection;
import ucar.grib.grib2.Grib2IdentificationSection;
import ucar.grib.grib2.Grib2ProductDefinitionSection;
import ucar.grib.grib2.Grib2Record;
import ucar.grib.grib2.ParameterTable;

public final class Grib2Lookup
implements TableLookup {
    private final Grib2ProductDefinitionSection firstPDS;
    private final Grib2IdentificationSection firstID;
    private final Grib2DataRepresentationSection firstDRS;

    public Grib2Lookup(Grib2Record firstRecord) {
        this.firstPDS = firstRecord.getPDS();
        this.firstID = firstRecord.getId();
        this.firstDRS = firstRecord.getDRS();
    }

    public final String getGridName(Index.GdsRecord gds) {
        return Grib2GridDefinitionSection.getGridName(gds.grid_type);
    }

    public final String getShapeName(Index.GdsRecord gds) {
        return Grib2GridDefinitionSection.getShapeName(gds.grid_shape_code);
    }

    public final Parameter getParameter(Index.GribRecord gr) {
        return ParameterTable.getParameter(gr.discipline, gr.category, gr.paramNumber);
    }

    public int[] getParameterId(Index.GribRecord gr) {
        int[] result = new int[]{2, gr.discipline, gr.category, gr.paramNumber};
        return result;
    }

    public final String getDisciplineName(Index.GribRecord gr) {
        return ParameterTable.getDisciplineName(gr.discipline);
    }

    public final String getCategoryName(Index.GribRecord gr) {
        return ParameterTable.getCategoryName(gr.discipline, gr.category);
    }

    public final String getProductDefinitionName(Index.GribRecord gr) {
        return Grib2ProductDefinitionSection.getProductDefinitionName(gr.productType);
    }

    public final String getTypeGenProcessName(Index.GribRecord gr) {
        return Grib2ProductDefinitionSection.getTypeGenProcessName(gr.typeGenProcess);
    }

    public final String getLevelName(Index.GribRecord gr) {
        return Grib2ProductDefinitionSection.getTypeSurfaceNameShort(gr.levelType1);
    }

    public final String getLevelDescription(Index.GribRecord gr) {
        return Grib2ProductDefinitionSection.getTypeSurfaceName(gr.levelType1);
    }

    public final String getLevelUnit(Index.GribRecord gr) {
        return Grib2ProductDefinitionSection.getTypeSurfaceUnit(gr.levelType1);
    }

    public final String getFirstTimeRangeUnitName() {
        return Grib2ProductDefinitionSection.getTimeRangeUnitName(this.firstPDS.timeRangeUnit);
    }

    public final String getFirstCenterName() {
        return this.firstID.getCenter_idName();
    }

    public final int getFirstSubcenterId() {
        return this.firstID.getSubcenter_id();
    }

    public final String getFirstProductStatusName() {
        return this.firstID.getProductStatusName();
    }

    public final String getFirstProductTypeName() {
        return this.firstID.getProductTypeName();
    }

    public final String getFirstSignificanceOfRTName() {
        return this.firstID.getSignificanceOfRTName();
    }

    public final Date getFirstBaseTime() {
        return this.firstID.getBaseTime().getTime();
    }

    public final boolean isLatLon(Index.GdsRecord gds) {
        return gds.grid_type < 4 || gds.grid_type == 40;
    }

    public final int getProjectionType(Index.GdsRecord gds) {
        switch (gds.grid_type) {
            case 10: {
                return 3;
            }
            case 20: {
                return 1;
            }
            case 30: {
                return 2;
            }
            case 31: {
                return 5;
            }
            case 40: {
                return 8;
            }
            case 90: {
                return 7;
            }
        }
        return -1;
    }

    public final boolean isVerticalCoordinate(Index.GribRecord gr) {
        String units = this.getLevelUnit(gr);
        if (units == null || units.length() == 0) {
            return false;
        }
        if (gr.levelType1 == 0) {
            return false;
        }
        if (gr.levelType1 == 104) {
            return false;
        }
        return gr.levelType1 != 105;
    }

    public final boolean isPositiveUp(Index.GribRecord gr) {
        return gr.levelType1 != 20 && gr.levelType1 != 100 && gr.levelType1 != 106 && gr.levelType1 != 160;
    }

    public final float getFirstMissingValue() {
        return this.firstDRS.getPrimaryMissingValue();
    }
}

