/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.TextBlock;
import com.puppycrawl.tools.checkstyle.api.Utils;
import com.puppycrawl.tools.checkstyle.checks.AbstractFormatCheck;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.beanutils.ConversionException;

public class TrailingCommentCheck
extends AbstractFormatCheck {
    private static final String DEFAULT_FORMAT = "^[\\s\\}\\);]*$";
    private Pattern mLegalComment;

    public void setLegalComment(String aFormat) throws ConversionException {
        try {
            this.mLegalComment = Utils.getPattern(aFormat);
        }
        catch (PatternSyntaxException e) {
            throw new ConversionException("unable to parse " + aFormat, (Throwable)e);
        }
    }

    public TrailingCommentCheck() throws ConversionException {
        super(DEFAULT_FORMAT);
    }

    public int[] getDefaultTokens() {
        return new int[0];
    }

    public void visitToken(DetailAST aAST) {
        throw new IllegalStateException("visitToken() shouldn't be called.");
    }

    public void beginTree(DetailAST aRootAST) {
        Pattern blankLinePattern = this.getRegexp();
        Map cppComments = this.getFileContents().getCppComments();
        Map cComments = this.getFileContents().getCComments();
        HashSet lines = new HashSet();
        lines.addAll(cppComments.keySet());
        lines.addAll(cComments.keySet());
        Iterator linesIter = lines.iterator();
        while (linesIter.hasNext()) {
            Integer lineNo = (Integer)linesIter.next();
            String line = this.getLines()[lineNo - 1];
            String lineBefore = "";
            TextBlock comment = null;
            if (cppComments.containsKey(lineNo)) {
                comment = (TextBlock)cppComments.get(lineNo);
                lineBefore = line.substring(0, comment.getStartColNo());
            } else if (cComments.containsKey(lineNo)) {
                String lineAfter;
                List commentList = (List)cComments.get(lineNo);
                comment = (TextBlock)commentList.get(commentList.size() - 1);
                lineBefore = line.substring(0, comment.getStartColNo());
                if (comment.getText().length == 1 && !"".equals(lineAfter = line.substring(comment.getEndColNo() + 1).trim())) continue;
            }
            if (comment == null || blankLinePattern.matcher(lineBefore).find() || this.isLegalComment(comment)) continue;
            this.log(lineNo, "trailing.comments");
        }
    }

    private boolean isLegalComment(TextBlock aComment) {
        if (this.mLegalComment == null) {
            return false;
        }
        if (aComment.getStartLineNo() != aComment.getEndLineNo()) {
            return false;
        }
        String commentText = aComment.getText()[0];
        if ((commentText = commentText.substring(2)).endsWith("*/")) {
            commentText = commentText.substring(0, commentText.length() - 2);
        }
        commentText = commentText.trim();
        return this.mLegalComment.matcher(commentText).find();
    }
}

