/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector2;
import edu.umd.cs.findbugs.DetectorFactory;
import edu.umd.cs.findbugs.DetectorFactoryChooser;
import edu.umd.cs.findbugs.DetectorFactoryCollection;
import edu.umd.cs.findbugs.ErrorCountingBugReporter;
import edu.umd.cs.findbugs.FindBugs;
import edu.umd.cs.findbugs.FindBugsAnalysisFeatures;
import edu.umd.cs.findbugs.FindBugsDisplayFeatures;
import edu.umd.cs.findbugs.FindBugsProgress;
import edu.umd.cs.findbugs.IClassScreener;
import edu.umd.cs.findbugs.IFindBugsEngine;
import edu.umd.cs.findbugs.NoOpFindBugsProgress;
import edu.umd.cs.findbugs.Plugin;
import edu.umd.cs.findbugs.Project;
import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.TextUICommandLine;
import edu.umd.cs.findbugs.TigerSubstitutes;
import edu.umd.cs.findbugs.ba.AnalysisCacheToAnalysisContextAdapter;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.AnalysisException;
import edu.umd.cs.findbugs.ba.SourceInfoMap;
import edu.umd.cs.findbugs.classfile.CheckedAnalysisException;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.classfile.Global;
import edu.umd.cs.findbugs.classfile.IAnalysisCache;
import edu.umd.cs.findbugs.classfile.IClassFactory;
import edu.umd.cs.findbugs.classfile.IClassObserver;
import edu.umd.cs.findbugs.classfile.IClassPath;
import edu.umd.cs.findbugs.classfile.IClassPathBuilder;
import edu.umd.cs.findbugs.classfile.ICodeBase;
import edu.umd.cs.findbugs.classfile.MissingClassException;
import edu.umd.cs.findbugs.classfile.analysis.ClassInfo;
import edu.umd.cs.findbugs.classfile.engine.asm.EngineRegistrar;
import edu.umd.cs.findbugs.classfile.impl.ClassFactory;
import edu.umd.cs.findbugs.config.AnalysisFeatureSetting;
import edu.umd.cs.findbugs.config.UserPreferences;
import edu.umd.cs.findbugs.filter.FilterException;
import edu.umd.cs.findbugs.plan.AnalysisPass;
import edu.umd.cs.findbugs.plan.ExecutionPlan;
import edu.umd.cs.findbugs.plan.OrderingConstraintException;
import edu.umd.cs.findbugs.util.ClassName;
import edu.umd.cs.findbugs.util.TopologicalSort;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.bcel.classfile.ClassFormatException;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FindBugs2
implements IFindBugsEngine {
    private static final boolean VERBOSE = SystemProperties.getBoolean("findbugs.verbose");
    public static final boolean DEBUG = VERBOSE || SystemProperties.getBoolean("findbugs.debug");
    private List<IClassObserver> classObserverList = new LinkedList<IClassObserver>();
    private ErrorCountingBugReporter bugReporter;
    private Project project;
    private IClassFactory classFactory;
    private IClassPath classPath;
    private IAnalysisCache analysisCache;
    private List<ClassDescriptor> appClassList;
    private Set<ClassDescriptor> referencedClassSet;
    private DetectorFactoryCollection detectorFactoryCollection;
    private ExecutionPlan executionPlan;
    private UserPreferences userPreferences;
    private String currentClassName;
    private String releaseName;
    private String projectName;
    private String sourceInfoFileName;
    private AnalysisFeatureSetting[] analysisFeatureSettingList = FindBugs.DEFAULT_EFFORT;
    private boolean relaxedReportingMode;
    private boolean abridgedMessages;
    private String trainingInputDir;
    private String trainingOutputDir;
    private FindBugsProgress progress = new NoOpFindBugsProgress();
    private IClassScreener classScreener = new IClassScreener(){

        public boolean matches(String fileName) {
            return true;
        }
    };
    private boolean scanNestedArchives = false;
    static /* synthetic */ Class class$edu$umd$cs$findbugs$classfile$analysis$ClassInfo;

    @Override
    public void setDetectorFactoryCollection(DetectorFactoryCollection detectorFactoryCollection) {
        this.detectorFactoryCollection = detectorFactoryCollection;
    }

    @Override
    public void execute() throws IOException, InterruptedException {
        this.classFactory = ClassFactory.instance();
        this.createClassPath();
        this.createAnalysisCache();
        this.progress.reportNumberOfArchives(this.project.getFileCount());
        try {
            this.buildClassPath();
            this.buildReferencedClassSet();
            this.createAnalysisContext();
            FindBugs.configureBugCollection(this);
            FindBugsAnalysisFeatures.setRelaxedMode(this.relaxedReportingMode);
            FindBugsDisplayFeatures.setAbridgedMessages(this.abridgedMessages);
            FindBugs.configureTrainingDatabases(this);
            this.configureAnalysisFeatures();
            this.createExecutionPlan();
            this.analyzeApplication();
        }
        catch (CheckedAnalysisException e) {
            IOException ioe = new IOException("IOException while scanning codebases");
            ioe.initCause(e);
            throw ioe;
        }
        finally {
            this.classPath.close();
        }
    }

    @Override
    public BugReporter getBugReporter() {
        return this.bugReporter;
    }

    @Override
    public Project getProject() {
        return this.project;
    }

    @Override
    public void addClassObserver(IClassObserver classObserver) {
        this.classObserverList.add(classObserver);
    }

    @Override
    public void addFilter(String filterFileName, boolean include) throws IOException, FilterException {
        FindBugs.configureFilter(this.bugReporter, filterFileName, include);
    }

    @Override
    public void enableTrainingInput(String trainingInputDir) {
        this.trainingInputDir = trainingInputDir;
    }

    @Override
    public void enableTrainingOutput(String trainingOutputDir) {
        this.trainingOutputDir = trainingOutputDir;
    }

    @Override
    public int getBugCount() {
        return this.bugReporter.getBugCount();
    }

    @Override
    public String getCurrentClass() {
        return this.currentClassName;
    }

    @Override
    public int getErrorCount() {
        return this.bugReporter.getErrorCount();
    }

    @Override
    public int getMissingClassCount() {
        return this.bugReporter.getMissingClassCount();
    }

    @Override
    public String getReleaseName() {
        return this.releaseName;
    }

    @Override
    public String getProjectName() {
        return this.projectName;
    }

    @Override
    public void setProjectName(String name) {
        this.projectName = name;
    }

    @Override
    public void setAnalysisFeatureSettings(AnalysisFeatureSetting[] settingList) {
        this.analysisFeatureSettingList = settingList;
    }

    @Override
    public void setBugReporter(BugReporter bugReporter) {
        this.bugReporter = new ErrorCountingBugReporter(bugReporter);
        this.addClassObserver(bugReporter);
    }

    @Override
    public void setClassScreener(IClassScreener classScreener) {
        this.classScreener = classScreener;
    }

    @Override
    public void setProgressCallback(FindBugsProgress progressCallback) {
        this.progress = progressCallback;
    }

    @Override
    public void setProject(Project project) {
        this.project = project;
    }

    @Override
    public void setRelaxedReportingMode(boolean relaxedReportingMode) {
        this.relaxedReportingMode = relaxedReportingMode;
    }

    @Override
    public void setReleaseName(String releaseName) {
        this.releaseName = releaseName;
    }

    @Override
    public void setSourceInfoFile(String sourceInfoFile) {
        this.sourceInfoFileName = sourceInfoFile;
    }

    @Override
    public void setUserPreferences(UserPreferences userPreferences) {
        this.userPreferences = userPreferences;
    }

    @Override
    public boolean emitTrainingOutput() {
        return this.trainingOutputDir != null;
    }

    @Override
    public UserPreferences getUserPreferences() {
        return this.userPreferences;
    }

    private void createClassPath() {
        this.classPath = this.classFactory.createClassPath();
    }

    @Override
    public String getTrainingInputDir() {
        return this.trainingInputDir;
    }

    @Override
    public String getTrainingOutputDir() {
        return this.trainingOutputDir;
    }

    @Override
    public boolean useTrainingInput() {
        return this.trainingInputDir != null;
    }

    @Override
    public void setScanNestedArchives(boolean scanNestedArchives) {
        this.scanNestedArchives = scanNestedArchives;
    }

    private void createAnalysisCache() {
        this.analysisCache = ClassFactory.instance().createAnalysisCache(this.classPath, this.bugReporter);
        new edu.umd.cs.findbugs.classfile.engine.EngineRegistrar().registerAnalysisEngines(this.analysisCache);
        new EngineRegistrar().registerAnalysisEngines(this.analysisCache);
        new edu.umd.cs.findbugs.classfile.engine.bcel.EngineRegistrar().registerAnalysisEngines(this.analysisCache);
        Global.setAnalysisCacheForCurrentThread(this.analysisCache);
    }

    private void buildClassPath() throws InterruptedException, IOException, CheckedAnalysisException {
        IClassPathBuilder builder = this.classFactory.createClassPathBuilder(this.bugReporter);
        for (String path : this.project.getFileArray()) {
            builder.addCodeBase(this.classFactory.createFilesystemCodeBaseLocator(path), true);
        }
        for (String path : this.project.getAuxClasspathEntryList()) {
            builder.addCodeBase(this.classFactory.createFilesystemCodeBaseLocator(path), false);
        }
        builder.scanNestedArchives(this.scanNestedArchives);
        builder.build(this.classPath, this.progress);
        this.appClassList = builder.getAppClassList();
        Iterator<? extends ICodeBase> i = this.classPath.appCodeBaseIterator();
        while (i.hasNext()) {
            String pathName;
            ICodeBase appCodeBase = i.next();
            if (appCodeBase.containsSourceFiles() && (pathName = appCodeBase.getPathName()) != null) {
                this.project.addSourceDir(pathName);
            }
            this.project.addTimestamp(appCodeBase.getLastModifiedTime());
        }
    }

    private void buildReferencedClassSet() throws CheckedAnalysisException, InterruptedException {
        this.referencedClassSet = new TreeSet<ClassDescriptor>();
        LinkedList<ClassDescriptor> workList = new LinkedList<ClassDescriptor>();
        workList.addAll(this.appClassList);
        HashSet<ClassDescriptor> seen = new HashSet<ClassDescriptor>();
        HashSet<ClassDescriptor> appClassSet = new HashSet<ClassDescriptor>(this.appClassList);
        HashSet<ClassDescriptor> badAppClassSet = new HashSet<ClassDescriptor>();
        while (!workList.isEmpty()) {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            ClassDescriptor classDesc = (ClassDescriptor)workList.removeFirst();
            if (seen.contains(classDesc)) continue;
            seen.add(classDesc);
            this.referencedClassSet.add(classDesc);
            try {
                ClassInfo classInfo = (ClassInfo)Global.getAnalysisCache().getClassAnalysis(class$edu$umd$cs$findbugs$classfile$analysis$ClassInfo == null ? FindBugs2.class$("edu.umd.cs.findbugs.classfile.analysis.ClassInfo") : class$edu$umd$cs$findbugs$classfile$analysis$ClassInfo, classDesc);
                this.referencedClassSet.addAll(Arrays.asList(classInfo.getReferencedClassDescriptorList()));
                if (classInfo.getSuperclassDescriptor() != null) {
                    workList.addLast(classInfo.getSuperclassDescriptor());
                }
                for (ClassDescriptor ifaceDesc : classInfo.getInterfaceDescriptorList()) {
                    workList.addLast(ifaceDesc);
                }
            }
            catch (MissingClassException e) {
                this.bugReporter.reportMissingClass(e.getClassDescriptor());
                if (!appClassSet.contains(classDesc)) continue;
                badAppClassSet.add(classDesc);
            }
            catch (CheckedAnalysisException e) {
                this.bugReporter.logError(new StringBuffer().append("Error scanning ").append(classDesc).append(" for referenced classes").toString(), e);
                if (!appClassSet.contains(classDesc)) continue;
                badAppClassSet.add(classDesc);
            }
        }
        this.appClassList.removeAll(badAppClassSet);
    }

    public List<ClassDescriptor> sortByCallGraph(Collection<ClassDescriptor> classList) {
        return TopologicalSort.sortByCallGraph(classList, new TopologicalSort.OutEdges<ClassDescriptor>(){

            @Override
            public Collection<ClassDescriptor> getOutEdges(ClassDescriptor e) {
                try {
                    ClassInfo classInfo = (ClassInfo)Global.getAnalysisCache().getClassAnalysis(class$edu$umd$cs$findbugs$classfile$analysis$ClassInfo == null ? (class$edu$umd$cs$findbugs$classfile$analysis$ClassInfo = FindBugs2.class$("edu.umd.cs.findbugs.classfile.analysis.ClassInfo")) : class$edu$umd$cs$findbugs$classfile$analysis$ClassInfo, e);
                    return Arrays.asList(classInfo.getReferencedClassDescriptorList());
                }
                catch (CheckedAnalysisException e2) {
                    AnalysisContext.logError(new StringBuffer().append("error while analyzing ").append(e.getClassName()).toString(), e2);
                    return TigerSubstitutes.emptyList();
                }
            }

            @Override
            public /* synthetic */ Collection getOutEdges(Object x0) {
                return this.getOutEdges((ClassDescriptor)x0);
            }
        });
    }

    private void createAnalysisContext() throws CheckedAnalysisException, IOException {
        AnalysisCacheToAnalysisContextAdapter analysisContext = new AnalysisCacheToAnalysisContextAdapter();
        analysisContext.clearRepository();
        analysisContext.setAppClassList(this.appClassList);
        if (this.sourceInfoFileName != null) {
            SourceInfoMap sourceInfoMap = analysisContext.getSourceInfoMap();
            sourceInfoMap.read(new FileInputStream(this.sourceInfoFileName));
        }
        AnalysisContext.setCurrentAnalysisContext(analysisContext);
    }

    private void configureAnalysisFeatures() {
        for (AnalysisFeatureSetting setting : this.analysisFeatureSettingList) {
            setting.configure(AnalysisContext.currentAnalysisContext());
        }
    }

    private void createExecutionPlan() throws OrderingConstraintException {
        this.executionPlan = new ExecutionPlan();
        DetectorFactoryChooser detectorFactoryChooser = new DetectorFactoryChooser(){
            HashSet<DetectorFactory> forcedEnabled = new HashSet();

            public boolean choose(DetectorFactory factory) {
                return FindBugs.isDetectorEnabled(FindBugs2.this, factory) || this.forcedEnabled.contains(factory);
            }

            public void enable(DetectorFactory factory) {
                this.forcedEnabled.add(factory);
                factory.setEnabledButNonReporting(true);
            }
        };
        this.executionPlan.setDetectorFactoryChooser(detectorFactoryChooser);
        Iterator<Plugin> i = this.detectorFactoryCollection.pluginIterator();
        while (i.hasNext()) {
            Plugin plugin = i.next();
            if (DEBUG) {
                System.out.println(new StringBuffer().append("Adding plugin ").append(plugin.getPluginId()).append(" to execution plan").toString());
            }
            this.executionPlan.addPlugin(plugin);
        }
        this.executionPlan.build();
        if (DEBUG) {
            System.out.println(new StringBuffer().append(this.executionPlan.getNumPasses()).append(" passes in execution plan").toString());
        }
    }

    private void analyzeApplication() throws InterruptedException {
        int passCount = 0;
        boolean multiplePasses = this.executionPlan.getNumPasses() > 1;
        int[] classesPerPass = new int[this.executionPlan.getNumPasses()];
        classesPerPass[0] = this.referencedClassSet.size();
        for (int i = 0; i < classesPerPass.length; ++i) {
            classesPerPass[i] = i == 0 ? this.referencedClassSet.size() : this.appClassList.size();
        }
        this.progress.predictPassCount(classesPerPass);
        Iterator<AnalysisPass> i = this.executionPlan.passIterator();
        while (i.hasNext()) {
            List<ClassDescriptor> classCollection;
            AnalysisPass pass = i.next();
            Detector2[] detectorList = pass.instantiateDetector2sInPass(this.bugReporter);
            Collection<ClassDescriptor> collection = classCollection = multiplePasses && passCount == 0 ? this.referencedClassSet : this.appClassList;
            if (DEBUG) {
                System.out.println(new StringBuffer().append("Pass ").append(passCount).append(": ").append(classCollection.size()).append(" classes").toString());
            }
            if (passCount > 0) {
                List<ClassDescriptor> result = this.sortByCallGraph(classCollection);
                classCollection = result;
            }
            this.progress.startAnalysis(classCollection.size());
            for (ClassDescriptor classDescriptor : classCollection) {
                if (DEBUG) {
                    System.out.println(new StringBuffer().append("Class ").append(classDescriptor).toString());
                }
                if (!this.classScreener.matches(classDescriptor.toResourceName())) {
                    if (!DEBUG) continue;
                    System.out.println("*** Excluded by class screener");
                    continue;
                }
                this.currentClassName = ClassName.toDottedClassName(classDescriptor.getClassName());
                this.notifyClassObservers(classDescriptor);
                for (Detector2 detector : detectorList) {
                    if (Thread.interrupted()) {
                        throw new InterruptedException();
                    }
                    if (DEBUG) {
                        System.out.println(new StringBuffer().append("Applying ").append(detector.getDetectorClassName()).append(" to ").append(classDescriptor).toString());
                    }
                    try {
                        detector.visitClass(classDescriptor);
                    }
                    catch (ClassFormatException e) {
                        this.logRecoverableException(classDescriptor, detector, e);
                    }
                    catch (MissingClassException e) {
                        Global.getAnalysisCache().getErrorLogger().reportMissingClass(e.getClassDescriptor());
                    }
                    catch (CheckedAnalysisException e) {
                        this.logRecoverableException(classDescriptor, detector, e);
                    }
                    catch (AnalysisException e) {
                        this.logRecoverableException(classDescriptor, detector, e);
                    }
                    catch (ArrayIndexOutOfBoundsException e) {
                        this.logRecoverableException(classDescriptor, detector, e);
                    }
                    catch (ClassCastException e) {
                        this.logRecoverableException(classDescriptor, detector, e);
                    }
                    catch (RuntimeException e) {
                        this.logRecoverableException(classDescriptor, detector, e);
                    }
                }
                this.progress.finishClass();
            }
            for (Detector2 detector : detectorList) {
                detector.finishPass();
            }
            AnalysisContext.currentAnalysisContext().updateDatabases(passCount);
            this.progress.finishPerClassAnalysis();
            ++passCount;
        }
        this.bugReporter.finish();
        this.bugReporter.reportQueuedErrors();
    }

    private void notifyClassObservers(ClassDescriptor classDescriptor) {
        for (IClassObserver observer : this.classObserverList) {
            observer.observeClass(classDescriptor);
        }
    }

    private void logRecoverableException(ClassDescriptor classDescriptor, Detector2 detector, Throwable e) {
        this.bugReporter.logError(new StringBuffer().append("Exception analyzing ").append(classDescriptor.toDottedClassName()).append(" using detector ").append(detector.getDetectorClassName()).toString(), e);
    }

    public static void main(String[] args) throws Exception {
        FindBugs2 findBugs = new FindBugs2();
        TextUICommandLine commandLine = new TextUICommandLine();
        FindBugs.processCommandLine(commandLine, args, findBugs);
        FindBugs.runMain(findBugs, commandLine);
    }

    @Override
    public void setAbridgedMessages(boolean xmlWithAbridgedMessages) {
        this.abridgedMessages = xmlWithAbridgedMessages;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError().initCause(x1);
        }
    }
}

