/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import edu.umd.cs.findbugs.FieldAnnotation;
import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.ClassMember;
import edu.umd.cs.findbugs.ba.XFactory;
import edu.umd.cs.findbugs.ba.XField;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.visitclass.Constants2;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.LVTHelper;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.CodeException;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantClass;
import org.apache.bcel.classfile.ConstantDouble;
import org.apache.bcel.classfile.ConstantFloat;
import org.apache.bcel.classfile.ConstantInteger;
import org.apache.bcel.classfile.ConstantLong;
import org.apache.bcel.classfile.ConstantString;
import org.apache.bcel.classfile.ConstantUtf8;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.LocalVariable;
import org.apache.bcel.classfile.LocalVariableTable;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.BasicType;
import org.apache.bcel.generic.Type;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpcodeStack
implements Constants2 {
    private static final boolean DEBUG = SystemProperties.getBoolean("ocstack.debug");
    private List<Item> stack;
    private List<Item> lvValues;
    private List<Integer> lastUpdate;
    private boolean seenTransferOfControl = false;
    private boolean useIterativeAnalysis = AnalysisContext.currentAnalysisContext().getBoolProperty(4);
    boolean needToMerge = true;
    boolean reachOnlyByBranch = false;
    int convertJumpToOneZeroState = 0;
    int convertJumpToZeroOneState = 0;
    BitSet exceptionHandlers = new BitSet();
    private Map<Integer, List<Item>> jumpEntries = new HashMap<Integer, List<Item>>();
    private Map<Integer, List<Item>> jumpStackEntries = new HashMap<Integer, List<Item>>();
    private BitSet jumpEntryLocations = new BitSet();
    private String methodName;

    public String toString() {
        return new StringBuffer().append(this.stack.toString()).append("::").append(this.lvValues.toString()).toString();
    }

    public OpcodeStack() {
        this.stack = new ArrayList<Item>();
        this.lvValues = new ArrayList<Item>();
        this.lastUpdate = new ArrayList<Integer>();
    }

    public static String getExceptionSig(DismantleBytecode dbc, CodeException e) {
        if (e.getCatchType() == 0) {
            return "Ljava/lang/Throwable;";
        }
        Constant c = dbc.getConstantPool().getConstant(e.getCatchType());
        if (c instanceof ConstantClass) {
            return new StringBuffer().append("L").append(((ConstantClass)c).getBytes(dbc.getConstantPool())).append(";").toString();
        }
        return "Ljava/lang/Throwable;";
    }

    public void mergeJumps(DismantleBytecode dbc) {
        if (!this.needToMerge) {
            return;
        }
        this.needToMerge = false;
        boolean stackUpdated = false;
        if (this.convertJumpToOneZeroState == 3 || this.convertJumpToZeroOneState == 3) {
            this.pop();
            Item top = new Item("I");
            top.setCouldBeZero(true);
            this.push(top);
            this.convertJumpToZeroOneState = 0;
            this.convertJumpToOneZeroState = 0;
            stackUpdated = true;
        }
        List<Item> jumpEntry = null;
        if (this.jumpEntryLocations.get(dbc.getPC())) {
            jumpEntry = this.jumpEntries.get(new Integer(dbc.getPC()));
        }
        if (jumpEntry != null) {
            if (DEBUG) {
                System.out.println(new StringBuffer().append("XXXXXXX ").append(this.reachOnlyByBranch).toString());
                System.out.println(new StringBuffer().append("merging lvValues at jump target ").append(dbc.getPC()).append(" -> ").append(Integer.toString(System.identityHashCode(jumpEntry), 16)).append(" ").append(jumpEntry).toString());
                System.out.println(new StringBuffer().append(" current lvValues ").append(this.lvValues).toString());
            }
            List<Item> jumpStackEntry = this.jumpStackEntries.get(new Integer(dbc.getPC()));
            if (this.reachOnlyByBranch) {
                this.lvValues = new ArrayList<Item>(jumpEntry);
                if (!stackUpdated) {
                    if (jumpStackEntry != null) {
                        this.stack = new ArrayList<Item>(jumpStackEntry);
                    } else {
                        this.stack.clear();
                    }
                }
            } else {
                this.mergeLists(this.lvValues, jumpEntry, false);
                if (!stackUpdated && jumpStackEntry != null) {
                    this.mergeLists(this.stack, jumpStackEntry, false);
                }
            }
            if (DEBUG) {
                System.out.println(new StringBuffer().append(" merged lvValues ").append(this.lvValues).toString());
            }
        } else if (this.reachOnlyByBranch && !stackUpdated) {
            this.stack.clear();
            boolean foundException = false;
            for (CodeException e : dbc.getCode().getExceptionTable()) {
                if (e.getHandlerPC() != dbc.getPC()) continue;
                this.push(new Item(OpcodeStack.getExceptionSig(dbc, e)));
                foundException = true;
            }
            if (!foundException) {
                this.push(new Item("Ljava/lang/Throwable;"));
            }
        }
        this.reachOnlyByBranch = false;
    }

    private void setLastUpdate(int reg, int pc) {
        while (this.lastUpdate.size() <= reg) {
            this.lastUpdate.add(new Integer(0));
        }
        this.lastUpdate.set(reg, new Integer(pc));
    }

    public int getLastUpdate(int reg) {
        if (this.lastUpdate.size() <= reg) {
            return 0;
        }
        return this.lastUpdate.get(reg);
    }

    public int getNumLastUpdates() {
        return this.lastUpdate.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void sawOpcode(DismantleBytecode dbc, int seen) {
        if (dbc.isRegisterStore()) {
            this.setLastUpdate(dbc.getRegisterOperand(), dbc.getPC());
        }
        this.mergeJumps(dbc);
        this.needToMerge = true;
        switch (seen) {
            case 4: {
                this.convertJumpToOneZeroState = 1;
                break;
            }
            case 167: {
                if (this.convertJumpToOneZeroState == 1 && dbc.getBranchOffset() == 4) {
                    this.convertJumpToOneZeroState = 2;
                    break;
                }
                this.convertJumpToOneZeroState = 0;
                break;
            }
            case 3: {
                if (this.convertJumpToOneZeroState == 2) {
                    this.convertJumpToOneZeroState = 3;
                    break;
                }
                this.convertJumpToOneZeroState = 0;
                break;
            }
            default: {
                this.convertJumpToOneZeroState = 0;
            }
        }
        switch (seen) {
            case 3: {
                this.convertJumpToZeroOneState = 1;
                break;
            }
            case 167: {
                if (this.convertJumpToZeroOneState == 1 && dbc.getBranchOffset() == 4) {
                    this.convertJumpToZeroOneState = 2;
                    break;
                }
                this.convertJumpToZeroOneState = 0;
                break;
            }
            case 4: {
                if (this.convertJumpToZeroOneState == 2) {
                    this.convertJumpToZeroOneState = 3;
                    break;
                }
                this.convertJumpToZeroOneState = 0;
                break;
            }
            default: {
                this.convertJumpToZeroOneState = 0;
            }
        }
        try {
            switch (seen) {
                case 25: {
                    this.pushByLocalObjectLoad(dbc, dbc.getRegisterOperand());
                    return;
                }
                case 42: 
                case 43: 
                case 44: 
                case 45: {
                    this.pushByLocalObjectLoad(dbc, seen - 42);
                    return;
                }
                case 24: {
                    this.pushByLocalLoad("D", dbc.getRegisterOperand());
                    return;
                }
                case 38: 
                case 39: 
                case 40: 
                case 41: {
                    this.pushByLocalLoad("D", seen - 38);
                    return;
                }
                case 23: {
                    this.pushByLocalLoad("F", dbc.getRegisterOperand());
                    return;
                }
                case 34: 
                case 35: 
                case 36: 
                case 37: {
                    this.pushByLocalLoad("F", seen - 34);
                    return;
                }
                case 21: {
                    this.pushByLocalLoad("I", dbc.getRegisterOperand());
                    return;
                }
                case 26: 
                case 27: 
                case 28: 
                case 29: {
                    this.pushByLocalLoad("I", seen - 26);
                    return;
                }
                case 22: {
                    this.pushByLocalLoad("J", dbc.getRegisterOperand());
                    return;
                }
                case 30: 
                case 31: 
                case 32: 
                case 33: {
                    this.pushByLocalLoad("J", seen - 30);
                    return;
                }
                case 178: {
                    FieldAnnotation field = FieldAnnotation.fromReferencedField(dbc);
                    Item i = new Item(dbc.getSigConstantOperand(), field, Integer.MAX_VALUE);
                    if (field.getFieldName().equals("separator") && field.getClassName().equals("java.io.File")) {
                        i.setSpecialKind(10);
                    }
                    this.push(i);
                    return;
                }
                case 18: 
                case 19: 
                case 20: {
                    Constant cons = dbc.getConstantRefOperand();
                    this.pushByConstant(dbc, cons);
                    return;
                }
                case 193: {
                    this.pop();
                    this.push(new Item("I"));
                    return;
                }
                case 153: 
                case 154: 
                case 155: 
                case 156: 
                case 157: 
                case 158: 
                case 198: 
                case 199: {
                    this.seenTransferOfControl = true;
                    Item top = this.pop();
                    if (top.valueCouldBeNegative() && (seen == 155 || seen == 158 || seen == 157 || seen == 156)) {
                        int specialKind = top.getSpecialKind();
                        for (Item item : this.stack) {
                            if (item == null || item.getSpecialKind() != specialKind) continue;
                            item.setSpecialKind(0);
                        }
                        for (Item item : this.lvValues) {
                            if (item == null || item.getSpecialKind() != specialKind) continue;
                            item.setSpecialKind(0);
                        }
                    }
                    this.addJumpValue(dbc.getBranchTarget());
                    return;
                }
                case 170: 
                case 171: {
                    this.seenTransferOfControl = true;
                    this.pop();
                    this.addJumpValue(dbc.getBranchTarget());
                    int pc = dbc.getBranchTarget() - dbc.getBranchOffset();
                    for (int offset : dbc.getSwitchOffsets()) {
                        this.addJumpValue(offset + pc);
                    }
                    return;
                }
                case 172: 
                case 173: 
                case 174: 
                case 175: 
                case 176: {
                    this.seenTransferOfControl = true;
                    this.reachOnlyByBranch = true;
                    this.pop();
                    return;
                }
                case 87: 
                case 179: 
                case 194: 
                case 195: {
                    this.pop();
                    return;
                }
                case 159: 
                case 160: 
                case 161: 
                case 162: 
                case 163: 
                case 164: 
                case 165: 
                case 166: {
                    this.seenTransferOfControl = true;
                    this.pop(2);
                    this.addJumpValue(dbc.getBranchTarget());
                    return;
                }
                case 88: {
                    Item it = this.pop();
                    if (it.getSize() != 1) return;
                    this.pop();
                    return;
                }
                case 181: {
                    this.pop(2);
                    return;
                }
                case 46: 
                case 53: {
                    this.pop(2);
                    this.push(new Item("I"));
                    return;
                }
                case 89: {
                    this.handleDup();
                    return;
                }
                case 92: {
                    this.handleDup2();
                    return;
                }
                case 90: {
                    this.handleDupX1();
                    return;
                }
                case 91: {
                    this.handleDupX2();
                    return;
                }
                case 93: {
                    this.handleDup2X1();
                    return;
                }
                case 132: {
                    int register = dbc.getRegisterOperand();
                    Item it = this.getLVValue(register);
                    Item it2 = new Item("I", dbc.getIntConstant());
                    this.pushByIntMath(96, it2, it);
                    this.pushByLocalStore(register);
                    return;
                }
                case 191: {
                    this.pop();
                    this.seenTransferOfControl = true;
                    this.reachOnlyByBranch = true;
                    return;
                }
                case 192: {
                    String castTo = dbc.getClassConstantOperand();
                    if (castTo.charAt(0) != '[') {
                        castTo = new StringBuffer().append("L").append(castTo).append(";").toString();
                    }
                    Item it = new Item(this.pop());
                    it.signature = castTo;
                    this.push(it);
                    return;
                }
                case 0: {
                    return;
                }
                case 169: 
                case 177: {
                    this.seenTransferOfControl = true;
                    this.reachOnlyByBranch = true;
                    return;
                }
                case 167: 
                case 200: {
                    this.seenTransferOfControl = true;
                    this.reachOnlyByBranch = true;
                    this.addJumpValue(dbc.getBranchTarget());
                    this.stack.clear();
                    return;
                }
                case 95: {
                    this.handleSwap();
                    return;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    this.push(new Item("I", seen - 3));
                    return;
                }
                case 9: 
                case 10: {
                    this.push(new Item("J", new Long(seen - 9)));
                    return;
                }
                case 14: 
                case 15: {
                    this.push(new Item("D", new Double(seen - 14)));
                    return;
                }
                case 11: 
                case 12: 
                case 13: {
                    this.push(new Item("F", new Float(seen - 11)));
                    return;
                }
                case 1: {
                    this.push(new Item());
                    return;
                }
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 58: {
                    this.pushByLocalStore(dbc.getRegisterOperand());
                    return;
                }
                case 75: 
                case 76: 
                case 77: 
                case 78: {
                    this.pushByLocalStore(seen - 75);
                    return;
                }
                case 71: 
                case 72: 
                case 73: 
                case 74: {
                    this.pushByLocalStore(seen - 71);
                    return;
                }
                case 67: 
                case 68: 
                case 69: 
                case 70: {
                    this.pushByLocalStore(seen - 67);
                    return;
                }
                case 59: 
                case 60: 
                case 61: 
                case 62: {
                    this.pushByLocalStore(seen - 59);
                    return;
                }
                case 63: 
                case 64: 
                case 65: 
                case 66: {
                    this.pushByLocalStore(seen - 63);
                    return;
                }
                case 180: {
                    Item item = this.pop();
                    int reg = item.getRegisterNumber();
                    this.push(new Item(dbc.getSigConstantOperand(), FieldAnnotation.fromReferencedField(dbc), reg));
                    return;
                }
                case 190: {
                    this.pop();
                    this.push(new Item("I"));
                    return;
                }
                case 51: {
                    this.pop(2);
                    Item v = new Item("I");
                    v.setSpecialKind(1);
                    this.push(v);
                    return;
                }
                case 52: {
                    this.pop(2);
                    this.push(new Item("I"));
                    return;
                }
                case 49: {
                    this.pop(2);
                    this.push(new Item("D"));
                    return;
                }
                case 48: {
                    this.pop(2);
                    this.push(new Item("F"));
                    return;
                }
                case 47: {
                    this.pop(2);
                    this.push(new Item("J"));
                    return;
                }
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: {
                    this.pop(3);
                    return;
                }
                case 16: 
                case 17: {
                    this.push(new Item("I", new Integer(dbc.getIntConstant())));
                    return;
                }
                case 96: 
                case 100: 
                case 104: 
                case 108: 
                case 112: 
                case 120: 
                case 122: 
                case 124: 
                case 126: 
                case 128: 
                case 130: {
                    Item it = this.pop();
                    Item it2 = this.pop();
                    this.pushByIntMath(seen, it2, it);
                    return;
                }
                case 116: {
                    Item it = this.pop();
                    if (it.getConstant() != null) {
                        this.push(new Item("I", new Integer(-((Integer)it.getConstant()).intValue())));
                        return;
                    } else {
                        this.push(new Item("I"));
                        return;
                    }
                }
                case 117: {
                    Item it = this.pop();
                    if (it.getConstant() != null) {
                        this.push(new Item("J", new Long(-((Long)it.getConstant()).longValue())));
                        return;
                    } else {
                        this.push(new Item("J"));
                        return;
                    }
                }
                case 119: {
                    Item it = this.pop();
                    if (it.getConstant() != null) {
                        this.push(new Item("D", new Double(-((Double)it.getConstant()).doubleValue())));
                        return;
                    } else {
                        this.push(new Item("D"));
                        return;
                    }
                }
                case 97: 
                case 101: 
                case 105: 
                case 109: 
                case 113: 
                case 121: 
                case 123: 
                case 125: 
                case 127: 
                case 129: 
                case 131: {
                    Item it = this.pop();
                    Item it2 = this.pop();
                    this.pushByLongMath(seen, it2, it);
                    return;
                }
                case 148: {
                    this.handleLcmp();
                    return;
                }
                case 149: 
                case 150: {
                    this.handleFcmp(seen);
                    return;
                }
                case 151: 
                case 152: {
                    this.handleDcmp(seen);
                    return;
                }
                case 98: 
                case 102: 
                case 106: 
                case 110: {
                    Item it = this.pop();
                    Item it2 = this.pop();
                    this.pushByFloatMath(seen, it, it2);
                    return;
                }
                case 99: 
                case 103: 
                case 107: 
                case 111: 
                case 115: {
                    Item it = this.pop();
                    Item it2 = this.pop();
                    this.pushByDoubleMath(seen, it, it2);
                    return;
                }
                case 145: {
                    Item it = this.pop();
                    it = it.getConstant() != null ? new Item("I", (int)((byte)this.constantToInt(it))) : new Item("I");
                    it.setSpecialKind(1);
                    this.push(it);
                    return;
                }
                case 146: {
                    Item it = this.pop();
                    it = it.getConstant() != null ? new Item("I", (int)((char)this.constantToInt(it))) : new Item("I");
                    it.setSpecialKind(12);
                    this.push(it);
                    return;
                }
                case 133: 
                case 143: {
                    Item it = this.pop();
                    Item newValue = it.getConstant() != null ? new Item("J", new Long(this.constantToLong(it))) : new Item("J");
                    newValue.setSpecialKind(it.getSpecialKind());
                    this.push(newValue);
                    return;
                }
                case 147: {
                    Item it = this.pop();
                    if (it.getConstant() != null) {
                        this.push(new Item("I", (int)((short)this.constantToInt(it))));
                        return;
                    } else {
                        this.push(new Item("I"));
                        return;
                    }
                }
                case 136: 
                case 139: 
                case 142: {
                    Item it = this.pop();
                    if (it.getConstant() != null) {
                        this.push(new Item("I", this.constantToInt(it)));
                        return;
                    } else {
                        this.push(new Item("I"));
                        return;
                    }
                }
                case 134: 
                case 137: 
                case 144: {
                    Item it = this.pop();
                    if (it.getConstant() != null) {
                        this.push(new Item("F", new Float(this.constantToFloat(it))));
                        return;
                    } else {
                        this.push(new Item("F"));
                        return;
                    }
                }
                case 135: 
                case 138: 
                case 141: {
                    Item it = this.pop();
                    if (it.getConstant() != null) {
                        this.push(new Item("D", new Double(this.constantToDouble(it))));
                        return;
                    } else {
                        this.push(new Item("D"));
                        return;
                    }
                }
                case 187: {
                    this.pushBySignature(new StringBuffer().append("L").append(dbc.getClassConstantOperand()).append(";").toString());
                    return;
                }
                case 188: {
                    this.pop();
                    String signature = new StringBuffer().append("[").append(BasicType.getType((byte)dbc.getIntConstant()).getSignature()).toString();
                    this.pushBySignature(signature);
                    return;
                }
                case 189: {
                    this.pop();
                    String signature = dbc.getClassConstantOperand();
                    if (!signature.startsWith("[")) {
                        signature = new StringBuffer().append("[L").append(signature).append(";").toString();
                    }
                    this.pushBySignature(signature);
                    return;
                }
                case 197: {
                    int dims = dbc.getIntConstant();
                    while (dims-- > 0) {
                        this.pop();
                    }
                    String signature = dbc.getClassConstantOperand();
                    if (!signature.startsWith("[")) {
                        dims = dbc.getIntConstant();
                        signature = "";
                        while (dims-- > 0) {
                            signature = new StringBuffer().append(signature).append("[").toString();
                        }
                        signature = new StringBuffer().append(signature).append("L").append(signature).append(";").toString();
                    }
                    this.pushBySignature(signature);
                    return;
                }
                case 50: {
                    this.pop();
                    Item it = this.pop();
                    this.pushBySignature(it.getElementSignature());
                    return;
                }
                case 168: {
                    this.push(new Item(""));
                    return;
                }
                case 182: 
                case 183: 
                case 184: 
                case 185: {
                    this.processMethodCall(dbc, seen);
                    return;
                }
                default: {
                    throw new UnsupportedOperationException(new StringBuffer().append("OpCode ").append(OPCODE_NAMES[seen]).append(" not supported ").toString());
                }
            }
        }
        catch (RuntimeException e) {
            if (DEBUG) {
                e.printStackTrace();
            }
            this.clear();
            return;
        }
        finally {
            if (this.exceptionHandlers.get(dbc.getNextPC())) {
                this.push(new Item());
            }
            if (DEBUG) {
                System.out.println(new StringBuffer().append(dbc.getNextPC()).append("pc : ").append(OPCODE_NAMES[seen]).append("  stack depth: ").append(this.getStackDepth()).toString());
                System.out.println(this);
            }
        }
    }

    private int constantToInt(Item it) {
        return ((Number)it.getConstant()).intValue();
    }

    private float constantToFloat(Item it) {
        return ((Number)it.getConstant()).floatValue();
    }

    private double constantToDouble(Item it) {
        return ((Number)it.getConstant()).doubleValue();
    }

    private long constantToLong(Item it) {
        return ((Number)it.getConstant()).longValue();
    }

    private void handleDcmp(int opcode) {
        Item it = this.pop();
        Item it2 = this.pop();
        if (it.getConstant() != null && it2.getConstant() != null) {
            double d = (Double)it.getConstant();
            double d2 = (Double)it.getConstant();
            if (Double.isNaN(d) || Double.isNaN(d2)) {
                if (opcode == 152) {
                    this.push(new Item("I", new Integer(1)));
                } else {
                    this.push(new Item("I", new Integer(-1)));
                }
            }
            if (d2 < d) {
                this.push(new Item("I", new Integer(-1)));
            } else if (d2 > d) {
                this.push(new Item("I", new Integer(1)));
            } else {
                this.push(new Item("I", new Integer(0)));
            }
        } else {
            this.push(new Item("I"));
        }
    }

    private void handleFcmp(int opcode) {
        Item it = this.pop();
        Item it2 = this.pop();
        if (it.getConstant() != null && it2.getConstant() != null) {
            float f = ((Float)it.getConstant()).floatValue();
            float f2 = ((Float)it.getConstant()).floatValue();
            if (Float.isNaN(f) || Float.isNaN(f2)) {
                if (opcode == 150) {
                    this.push(new Item("I", new Integer(1)));
                } else {
                    this.push(new Item("I", new Integer(-1)));
                }
            }
            if (f2 < f) {
                this.push(new Item("I", new Integer(-1)));
            } else if (f2 > f) {
                this.push(new Item("I", new Integer(1)));
            } else {
                this.push(new Item("I", new Integer(0)));
            }
        } else {
            this.push(new Item("I"));
        }
    }

    private void handleLcmp() {
        Item it = this.pop();
        Item it2 = this.pop();
        if (it.getConstant() != null && it2.getConstant() != null) {
            long l = (Long)it.getConstant();
            long l2 = (Long)it.getConstant();
            if (l2 < l) {
                this.push(new Item("I", new Integer(-1)));
            } else if (l2 > l) {
                this.push(new Item("I", new Integer(1)));
            } else {
                this.push(new Item("I", new Integer(0)));
            }
        } else {
            this.push(new Item("I"));
        }
    }

    private void handleSwap() {
        Item i1 = this.pop();
        Item i2 = this.pop();
        this.push(i1);
        this.push(i2);
    }

    private void handleDup() {
        Item it = this.pop();
        this.push(it);
        this.push(it);
    }

    private void handleDupX1() {
        Item it = this.pop();
        Item it2 = this.pop();
        this.push(it);
        this.push(it2);
        this.push(it);
    }

    private void handleDup2() {
        Item it = this.pop();
        if (it.getSize() == 2) {
            this.push(it);
            this.push(it);
        } else {
            Item it2 = this.pop();
            this.push(it2);
            this.push(it);
            this.push(it2);
            this.push(it);
        }
    }

    private void handleDup2X1() {
        Item it = this.pop();
        Item it2 = this.pop();
        String signature = it.getSignature();
        if (signature.equals("J") || signature.equals("D")) {
            this.push(it);
            this.push(it2);
            this.push(it);
        } else {
            Item it3 = this.pop();
            this.push(it2);
            this.push(it);
            this.push(it3);
            this.push(it2);
            this.push(it);
        }
    }

    private void handleDupX2() {
        Item it = this.pop();
        Item it2 = this.pop();
        String signature = it2.getSignature();
        if (signature.equals("J") || signature.equals("D")) {
            this.push(it);
            this.push(it2);
            this.push(it);
        } else {
            Item it3 = this.pop();
            this.push(it);
            this.push(it3);
            this.push(it2);
            this.push(it);
        }
    }

    private void processMethodCall(DismantleBytecode dbc, int seen) {
        Item i;
        String clsName = dbc.getClassConstantOperand();
        String methodName = dbc.getNameConstantOperand();
        String signature = dbc.getSigConstantOperand();
        String appenderValue = null;
        Item sbItem = null;
        if ("java/lang/StringBuffer".equals(clsName) || "java/lang/StringBuilder".equals(clsName)) {
            if ("<init>".equals(methodName)) {
                if ("(Ljava/lang/String;)V".equals(signature)) {
                    i = this.getStackItem(0);
                    appenderValue = (String)i.getConstant();
                } else if ("()V".equals(signature)) {
                    appenderValue = "";
                }
            } else if ("toString".equals(methodName)) {
                i = this.getStackItem(0);
                appenderValue = (String)i.getConstant();
            } else if ("append".equals(methodName) && signature.indexOf("II)") == -1) {
                Item item;
                sbItem = this.getStackItem(1);
                i = this.getStackItem(0);
                Object sbVal = sbItem.getConstant();
                Object sVal = i.getConstant();
                if (sbVal != null && sVal != null) {
                    appenderValue = new StringBuffer().append(sbVal).append(sVal.toString()).toString();
                } else if (sbItem.registerNumber >= 0 && (item = this.getLVValue(sbItem.registerNumber)) != null) {
                    item.constValue = null;
                }
            }
        }
        this.pushByInvoke(dbc, seen != 184);
        if (appenderValue != null) {
            i = this.getStackItem(0);
            i.constValue = appenderValue;
            if (sbItem != null) {
                i.registerNumber = sbItem.registerNumber;
                i.source = sbItem.source;
                i.userValue = sbItem.userValue;
                if (sbItem.registerNumber >= 0) {
                    this.setLVValue(sbItem.registerNumber, i);
                }
            }
            return;
        }
        if ((clsName.equals("java/util/Random") || clsName.equals("java/security/SecureRandom")) && methodName.equals("nextInt") && signature.equals("()I")) {
            i = this.pop();
            i.setSpecialKind(2);
            i.source = XFactory.createReferencedXMethod(dbc);
            this.push(i);
        }
        if (clsName.equals("java/lang/Math") && methodName.equals("abs")) {
            i = this.pop();
            i.setSpecialKind(11);
            i.source = XFactory.createReferencedXMethod(dbc);
            this.push(i);
        } else if (seen == 182 && methodName.equals("hashCode") && signature.equals("()I") || seen == 184 && clsName.equals("java/lang/System") && methodName.equals("identityHashCode") && signature.equals("(Ljava/lang/Object;)I")) {
            i = this.pop();
            i.setSpecialKind(4);
            i.source = XFactory.createReferencedXMethod(dbc);
            this.push(i);
        } else if (!signature.endsWith(")V")) {
            i = this.pop();
            i.source = XFactory.createReferencedXMethod(dbc);
            this.push(i);
        }
    }

    private void mergeLists(List<Item> mergeInto, List<Item> mergeFrom, boolean errorIfSizesDoNotMatch) {
        int intoSize = mergeInto.size();
        int fromSize = mergeFrom.size();
        if (errorIfSizesDoNotMatch && intoSize != fromSize) {
            if (DEBUG) {
                System.out.println("Bad merging items");
                System.out.println(new StringBuffer().append("current items: ").append(mergeInto).toString());
                System.out.println(new StringBuffer().append("jump items: ").append(mergeFrom).toString());
            }
        } else {
            if (DEBUG) {
                System.out.println("Merging items");
                System.out.println(new StringBuffer().append("current items: ").append(mergeInto).toString());
                System.out.println(new StringBuffer().append("jump items: ").append(mergeFrom).toString());
            }
            for (int i = 0; i < Math.min(intoSize, fromSize); ++i) {
                mergeInto.set(i, Item.merge(mergeInto.get(i), mergeFrom.get(i)));
            }
            if (DEBUG) {
                System.out.println(new StringBuffer().append("merged items: ").append(mergeInto).toString());
            }
        }
    }

    public void clear() {
        this.stack.clear();
        this.lvValues.clear();
    }

    private void addJumpValue(int target) {
        List<Item> atTarget;
        if (DEBUG) {
            System.out.println(new StringBuffer().append("Set jump entry at ").append(this.methodName).append(":").append(target).append("pc to ").append(this.stack).append(" : ").append(this.lvValues).toString());
        }
        if ((atTarget = this.jumpEntries.get(new Integer(target))) == null) {
            if (DEBUG) {
                System.out.println("Was null");
            }
            this.jumpEntries.put(new Integer(target), new ArrayList<Item>(this.lvValues));
            this.jumpEntryLocations.set(target);
            if (this.stack.size() > 0) {
                this.jumpStackEntries.put(new Integer(target), new ArrayList<Item>(this.stack));
            }
            return;
        }
        this.mergeLists(atTarget, this.lvValues, false);
        List<Item> stackAtTarget = this.jumpStackEntries.get(new Integer(target));
        if (this.stack.size() > 0 && stackAtTarget != null) {
            this.mergeLists(stackAtTarget, this.stack, false);
        }
        if (DEBUG) {
            System.out.println(new StringBuffer().append("merge target for ").append(this.methodName).append(":").append(target).append("pc is ").append(atTarget).toString());
        }
    }

    public int resetForMethodEntry(DismantleBytecode v) {
        this.methodName = v.getMethodName();
        this.jumpEntries.clear();
        this.jumpStackEntries.clear();
        this.jumpEntryLocations.clear();
        this.lastUpdate.clear();
        this.convertJumpToZeroOneState = 0;
        this.convertJumpToOneZeroState = 0;
        this.reachOnlyByBranch = false;
        int result = this.resetForMethodEntry0(v);
        Code code = v.getMethod().getCode();
        if (code == null) {
            return result;
        }
        if (this.useIterativeAnalysis) {
            if (DEBUG) {
                System.out.println(" --- Iterative analysis");
            }
            DismantleBytecode branchAnalysis = new DismantleBytecode(){

                public void sawOpcode(int seen) {
                    OpcodeStack.this.sawOpcode(this, seen);
                }
            };
            branchAnalysis.setupVisitorForClass(v.getThisClass());
            branchAnalysis.doVisitMethod(v.getMethod());
            if (!this.jumpEntries.isEmpty()) {
                branchAnalysis.doVisitMethod(v.getMethod());
            }
            if (DEBUG && !this.jumpEntries.isEmpty()) {
                System.out.println(new StringBuffer().append("Found dataflow for jumps in ").append(v.getMethodName()).toString());
                for (Integer pc : this.jumpEntries.keySet()) {
                    List<Item> list = this.jumpEntries.get(pc);
                    System.out.println(new StringBuffer().append(pc).append(" -> ").append(Integer.toString(System.identityHashCode(list), 16)).append(" ").append(list).toString());
                }
            }
            this.resetForMethodEntry0(v);
            if (DEBUG) {
                System.out.println(" --- End of Iterative analysis");
            }
        }
        return result;
    }

    private int resetForMethodEntry0(PreorderVisitor v) {
        CodeException[] exceptionTable;
        if (DEBUG) {
            System.out.println(" --- ");
        }
        this.stack.clear();
        this.lvValues.clear();
        this.reachOnlyByBranch = false;
        this.seenTransferOfControl = false;
        String className = v.getClassName();
        String signature = v.getMethodSig();
        this.exceptionHandlers.clear();
        Method m = v.getMethod();
        Code code = m.getCode();
        if (code != null && (exceptionTable = code.getExceptionTable()) != null) {
            for (CodeException ex : exceptionTable) {
                this.exceptionHandlers.set(ex.getHandlerPC());
            }
        }
        if (DEBUG) {
            System.out.println(new StringBuffer().append(" --- ").append(className).append(" ").append(m.getName()).append(" ").append(signature).toString());
        }
        Type[] argTypes = Type.getArgumentTypes(signature);
        int reg = 0;
        if (!m.isStatic()) {
            Item it = new Item(new StringBuffer().append("L").append(className).append(";").toString());
            it.setInitialParameter(true);
            it.registerNumber = reg;
            this.setLVValue(reg, it);
            reg += it.getSize();
        }
        for (Type argType : argTypes) {
            Item it = new Item(argType.getSignature());
            it.registerNumber = reg;
            it.setInitialParameter(true);
            this.setLVValue(reg, it);
            reg += it.getSize();
        }
        return reg;
    }

    public int getStackDepth() {
        return this.stack.size();
    }

    public Item getStackItem(int stackOffset) {
        if (stackOffset < 0 || stackOffset >= this.stack.size()) {
            return new Item("Lfindbugs/OpcodeStackError;");
        }
        int tos = this.stack.size() - 1;
        int pos = tos - stackOffset;
        try {
            return this.stack.get(pos);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ArrayIndexOutOfBoundsException(new StringBuffer().append("Requested item at offset ").append(stackOffset).append(" in a stack of size ").append(this.stack.size()).append(", made request for position ").append(pos).toString());
        }
    }

    private Item pop() {
        return this.stack.remove(this.stack.size() - 1);
    }

    private void pop(int count) {
        while (count-- > 0) {
            this.pop();
        }
    }

    private void push(Item i) {
        this.stack.add(i);
    }

    private void pushByConstant(DismantleBytecode dbc, Constant c) {
        if (c instanceof ConstantClass) {
            this.push(new Item("Ljava/lang/Class;", ((ConstantClass)c).getConstantValue(dbc.getConstantPool())));
        } else if (c instanceof ConstantInteger) {
            this.push(new Item("I", new Integer(((ConstantInteger)c).getBytes())));
        } else if (c instanceof ConstantString) {
            int s = ((ConstantString)c).getStringIndex();
            this.push(new Item("Ljava/lang/String;", this.getStringFromIndex(dbc, s)));
        } else if (c instanceof ConstantFloat) {
            this.push(new Item("F", new Float(((ConstantFloat)c).getBytes())));
        } else if (c instanceof ConstantDouble) {
            this.push(new Item("D", new Double(((ConstantDouble)c).getBytes())));
        } else if (c instanceof ConstantLong) {
            this.push(new Item("J", new Long(((ConstantLong)c).getBytes())));
        } else {
            throw new UnsupportedOperationException("Constant type not expected");
        }
    }

    private void pushByLocalObjectLoad(DismantleBytecode dbc, int register) {
        LocalVariable lv;
        Method m = dbc.getMethod();
        LocalVariableTable lvt = m.getLocalVariableTable();
        if (lvt != null && (lv = LVTHelper.getLocalVariableAtPC(lvt, register, dbc.getPC())) != null) {
            String signature = lv.getSignature();
            this.pushByLocalLoad(signature, register);
            return;
        }
        this.pushByLocalLoad("", register);
    }

    private void pushByIntMath(int seen, Item lhs, Item rhs) {
        if (DEBUG) {
            System.out.println(new StringBuffer().append("pushByIntMath: ").append(rhs.getConstant()).append(" ").append(lhs.getConstant()).toString());
        }
        Item newValue = new Item("I");
        try {
            if (rhs.getConstant() != null && lhs.getConstant() != null) {
                Integer lhsValue = (Integer)lhs.getConstant();
                Integer rhsValue = (Integer)rhs.getConstant();
                if (seen == 96) {
                    newValue = new Item("I", lhsValue + rhsValue);
                } else if (seen == 100) {
                    newValue = new Item("I", lhsValue - rhsValue);
                } else if (seen == 104) {
                    newValue = new Item("I", lhsValue * rhsValue);
                } else if (seen == 108) {
                    newValue = new Item("I", lhsValue / rhsValue);
                } else if (seen == 126) {
                    newValue = new Item("I", lhsValue & rhsValue);
                    if ((rhsValue & 0xFF) == 0 && rhsValue != 0 || (lhsValue & 0xFF) == 0 && lhsValue != 0) {
                        newValue.specialKind = 3;
                    }
                } else if (seen == 128) {
                    newValue = new Item("I", lhsValue | rhsValue);
                } else if (seen == 130) {
                    newValue = new Item("I", lhsValue ^ rhsValue);
                } else if (seen == 120) {
                    newValue = new Item("I", lhsValue << rhsValue);
                    if (rhsValue >= 8) {
                        newValue.specialKind = 3;
                    }
                } else if (seen == 122) {
                    newValue = new Item("I", lhsValue >> rhsValue);
                } else if (seen == 112) {
                    newValue = new Item("I", lhsValue % rhsValue);
                } else if (seen == 124) {
                    newValue = new Item("I", lhsValue >>> rhsValue);
                }
            } else if (rhs.getConstant() != null && seen == 120 && (Integer)rhs.getConstant() >= 8) {
                newValue.specialKind = 3;
            } else if (lhs.getConstant() != null && seen == 126) {
                int value = (Integer)lhs.getConstant();
                if (value == 0) {
                    newValue = new Item("I", 0);
                } else if ((value & 0xFF) == 0) {
                    newValue.specialKind = 3;
                } else if (value >= 0) {
                    newValue.specialKind = 12;
                }
            } else if (rhs.getConstant() != null && seen == 126) {
                int value = (Integer)rhs.getConstant();
                if (value == 0) {
                    newValue = new Item("I", 0);
                } else if ((value & 0xFF) == 0) {
                    newValue.specialKind = 3;
                } else if (value >= 0) {
                    newValue.specialKind = 12;
                }
            }
        }
        catch (RuntimeException e) {
            // empty catch block
        }
        if (lhs.specialKind == 5 && rhs.getConstant() != null) {
            int rhsValue = (Integer)rhs.getConstant();
            if (seen == 108 && rhsValue == 2 || seen == 122 && rhsValue == 1) {
                newValue.specialKind = 6;
            }
        }
        if (seen == 96 && newValue.specialKind == 0 && lhs.getConstant() == null && rhs.getConstant() == null) {
            newValue.specialKind = 5;
        }
        if (seen == 112 && lhs.specialKind == 4) {
            newValue.specialKind = 9;
        }
        if (seen == 112 && lhs.specialKind == 2) {
            newValue.specialKind = 8;
        }
        if (DEBUG) {
            System.out.println(new StringBuffer().append("push: ").append(newValue).toString());
        }
        this.push(newValue);
    }

    private void pushByLongMath(int seen, Item lhs, Item rhs) {
        Item newValue = new Item("J");
        try {
            if (rhs.getConstant() != null && lhs.getConstant() != null) {
                Long lhsValue = (Long)lhs.getConstant();
                if (seen == 121) {
                    newValue = new Item("J", new Long(lhsValue << ((Number)rhs.getConstant()).intValue()));
                    if (((Number)rhs.getConstant()).intValue() >= 8) {
                        newValue.specialKind = 3;
                    }
                } else if (seen == 123) {
                    newValue = new Item("J", new Long(lhsValue >> ((Number)rhs.getConstant()).intValue()));
                } else if (seen == 125) {
                    newValue = new Item("J", new Long(lhsValue >>> ((Number)rhs.getConstant()).intValue()));
                } else {
                    Long rhsValue = (Long)rhs.getConstant();
                    if (seen == 97) {
                        newValue = new Item("J", new Long(lhsValue + rhsValue));
                    } else if (seen == 101) {
                        newValue = new Item("J", new Long(lhsValue - rhsValue));
                    } else if (seen == 105) {
                        newValue = new Item("J", new Long(lhsValue * rhsValue));
                    } else if (seen == 109) {
                        newValue = new Item("J", new Long(lhsValue / rhsValue));
                    } else if (seen == 127) {
                        newValue = new Item("J", new Long(lhsValue & rhsValue));
                        if ((rhsValue & 0xFFL) == 0L && rhsValue != 0L || (lhsValue & 0xFFL) == 0L && lhsValue != 0L) {
                            newValue.specialKind = 3;
                        }
                    } else if (seen == 129) {
                        newValue = new Item("J", new Long(lhsValue | rhsValue));
                    } else if (seen == 131) {
                        newValue = new Item("J", new Long(lhsValue ^ rhsValue));
                    } else if (seen == 113) {
                        newValue = new Item("J", new Long(lhsValue % rhsValue));
                    }
                }
            } else if (rhs.getConstant() != null && seen == 121 && (Integer)rhs.getConstant() >= 8) {
                newValue.specialKind = 3;
            } else if (lhs.getConstant() != null && seen == 127 && ((Long)lhs.getConstant() & 0xFFL) == 0L) {
                newValue.specialKind = 3;
            } else if (rhs.getConstant() != null && seen == 127 && ((Long)rhs.getConstant() & 0xFFL) == 0L) {
                newValue.specialKind = 3;
            }
        }
        catch (RuntimeException e) {
            // empty catch block
        }
        this.push(newValue);
    }

    private void pushByFloatMath(int seen, Item it, Item it2) {
        Item result;
        int specialKind = 7;
        if (it.getConstant() != null && it2.getConstant() != null) {
            result = seen == 98 ? new Item("F", new Float(((Float)it2.getConstant()).floatValue() + ((Float)it.getConstant()).floatValue())) : (seen == 102 ? new Item("F", new Float(((Float)it2.getConstant()).floatValue() - ((Float)it.getConstant()).floatValue())) : (seen == 106 ? new Item("F", new Float(((Float)it2.getConstant()).floatValue() * ((Float)it.getConstant()).floatValue())) : (seen == 110 ? new Item("F", new Float(((Float)it2.getConstant()).floatValue() / ((Float)it.getConstant()).floatValue())) : new Item("F"))));
        } else {
            result = new Item("F");
            if (seen == 111) {
                specialKind = 13;
            }
        }
        result.setSpecialKind(specialKind);
        this.push(result);
    }

    private void pushByDoubleMath(int seen, Item it, Item it2) {
        Item result;
        int specialKind = 7;
        if (it.getConstant() != null && it2.getConstant() != null) {
            result = seen == 99 ? new Item("D", new Double((Double)it2.getConstant() + (Double)it.getConstant())) : (seen == 103 ? new Item("D", new Double((Double)it2.getConstant() - (Double)it.getConstant())) : (seen == 107 ? new Item("D", new Double((Double)it2.getConstant() * (Double)it.getConstant())) : (seen == 111 ? new Item("D", new Double((Double)it2.getConstant() / (Double)it.getConstant())) : new Item("D"))));
        } else {
            result = new Item("D");
            if (seen == 111) {
                specialKind = 13;
            }
        }
        result.setSpecialKind(specialKind);
        this.push(result);
    }

    private void pushByInvoke(DismantleBytecode dbc, boolean popThis) {
        String signature = dbc.getSigConstantOperand();
        this.pop(PreorderVisitor.getNumberArguments(signature) + (popThis ? 1 : 0));
        this.pushBySignature(Type.getReturnType(signature).getSignature());
    }

    private String getStringFromIndex(DismantleBytecode dbc, int i) {
        ConstantUtf8 name = (ConstantUtf8)dbc.getConstantPool().getConstant(i);
        return name.getBytes();
    }

    private void pushBySignature(String s) {
        if ("V".equals(s)) {
            return;
        }
        this.push(new Item(s, (Object)null));
    }

    private void pushByLocalStore(int register) {
        Item it = this.pop();
        if (it.getRegisterNumber() != register) {
            for (Item i : this.lvValues) {
                if (i == null) continue;
                if (i.registerNumber == register) {
                    i.registerNumber = -1;
                }
                if (i.fieldLoadedFromRegister != register) continue;
                i.fieldLoadedFromRegister = -1;
            }
            for (Item i : this.stack) {
                if (i == null) continue;
                if (i.registerNumber == register) {
                    i.registerNumber = -1;
                }
                if (i.fieldLoadedFromRegister != register) continue;
                i.fieldLoadedFromRegister = -1;
            }
        }
        this.setLVValue(register, it);
    }

    private void pushByLocalLoad(String signature, int register) {
        Item it = this.getLVValue(register);
        if (it == null) {
            Item item = new Item(signature);
            item.registerNumber = register;
            this.push(item);
        } else if (it.getRegisterNumber() >= 0) {
            this.push(it);
        } else {
            this.push(new Item(it, register));
        }
    }

    private void setLVValue(int index, Item value) {
        int addCount = index - this.lvValues.size() + 1;
        while (addCount-- > 0) {
            this.lvValues.add(null);
        }
        if (!this.useIterativeAnalysis && this.seenTransferOfControl) {
            value = Item.merge(value, this.lvValues.get(index));
        }
        this.lvValues.set(index, value);
    }

    private Item getLVValue(int index) {
        if (index >= this.lvValues.size()) {
            return null;
        }
        return this.lvValues.get(index);
    }

    public static class Item {
        public static final int SIGNED_BYTE = 1;
        public static final int RANDOM_INT = 2;
        public static final int LOW_8_BITS_CLEAR = 3;
        public static final int HASHCODE_INT = 4;
        public static final int INTEGER_SUM = 5;
        public static final int AVERAGE_COMPUTED_USING_DIVISION = 6;
        public static final int FLOAT_MATH = 7;
        public static final int RANDOM_INT_REMAINDER = 8;
        public static final int HASHCODE_INT_REMAINDER = 9;
        public static final int FILE_SEPARATOR_STRING = 10;
        public static final int MATH_ABS = 11;
        public static final int MASKED_NON_NEGATIVE = 12;
        public static final int NASTY_FLOAT_MATH = 13;
        private static final int IS_INITIAL_PARAMETER_FLAG = 1;
        private static final int COULD_BE_ZERO_FLAG = 2;
        private static final int IS_NULL_FLAG = 4;
        public static final Object UNKNOWN = null;
        private int specialKind;
        private String signature;
        private Object constValue = UNKNOWN;
        @CheckForNull
        private ClassMember source;
        private int flags;
        private int registerNumber = -1;
        private Object userValue = null;
        private int fieldLoadedFromRegister = -1;

        public int getSize() {
            if (this.signature.equals("J") || this.signature.equals("D")) {
                return 2;
            }
            return 1;
        }

        private static boolean equals(Object o1, Object o2) {
            if (o1 == o2) {
                return true;
            }
            if (o1 == null || o2 == null) {
                return false;
            }
            return o1.equals(o2);
        }

        public int hashCode() {
            int r = 42 + this.specialKind;
            if (this.signature != null) {
                r += this.signature.hashCode();
            }
            r *= 31;
            if (this.constValue != null) {
                r += this.constValue.hashCode();
            }
            r *= 31;
            if (this.source != null) {
                r += this.source.hashCode();
            }
            r *= 31;
            r += this.flags;
            r *= 31;
            return r += this.registerNumber;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Item)) {
                return false;
            }
            Item that = (Item)o;
            return Item.equals(this.signature, that.signature) && Item.equals(this.constValue, that.constValue) && Item.equals(this.source, that.source) && this.specialKind == that.specialKind && this.registerNumber == that.registerNumber && this.flags == that.flags && this.userValue == that.userValue && this.fieldLoadedFromRegister == that.fieldLoadedFromRegister;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer("< ");
            buf.append(this.signature);
            switch (this.specialKind) {
                case 1: {
                    buf.append(", byte_array_load");
                    break;
                }
                case 2: {
                    buf.append(", random_int");
                    break;
                }
                case 3: {
                    buf.append(", low8clear");
                    break;
                }
                case 4: {
                    buf.append(", hashcode_int");
                    break;
                }
                case 5: {
                    buf.append(", int_sum");
                    break;
                }
                case 6: {
                    buf.append(", averageComputingUsingDivision");
                    break;
                }
                case 7: {
                    buf.append(", floatMath");
                    break;
                }
                case 13: {
                    buf.append(", nastyFloatMath");
                    break;
                }
                case 9: {
                    buf.append(", hashcode_int_rem");
                    break;
                }
                case 8: {
                    buf.append(", random_int_rem");
                    break;
                }
                case 10: {
                    buf.append(", file_separator_string");
                    break;
                }
                case 11: {
                    buf.append(", Math.abs");
                    break;
                }
                case 12: {
                    buf.append(", masked_non_negative");
                    break;
                }
                case 0: {
                    break;
                }
                default: {
                    buf.append(", #" + this.specialKind);
                }
            }
            if (this.constValue != UNKNOWN) {
                buf.append(", ");
                buf.append(this.constValue);
            }
            if (this.source instanceof XField) {
                buf.append(", ");
                if (this.fieldLoadedFromRegister != -1) {
                    buf.append(this.fieldLoadedFromRegister).append(':');
                }
                buf.append(this.source);
            }
            if (this.source instanceof XMethod) {
                buf.append(", return value from ");
                buf.append(this.source);
            }
            if (this.isInitialParameter()) {
                buf.append(", IP");
            }
            if (this.isNull()) {
                buf.append(", isNull");
            }
            if (this.registerNumber != -1) {
                buf.append(", r");
                buf.append(this.registerNumber);
            }
            if (this.isCouldBeZero()) {
                buf.append(", cbz");
            }
            buf.append(" >");
            return buf.toString();
        }

        public static Item merge(Item i1, Item i2) {
            if (i1 == null) {
                return i2;
            }
            if (i2 == null) {
                return i1;
            }
            if (i1.equals(i2)) {
                return i1;
            }
            Item m = new Item();
            m.flags = i1.flags & i2.flags;
            m.setCouldBeZero(i1.isCouldBeZero() || i2.isCouldBeZero());
            if (Item.equals(i1.signature, i2.signature)) {
                m.signature = i1.signature;
            }
            if (Item.equals(i1.constValue, i2.constValue)) {
                m.constValue = i1.constValue;
            }
            if (Item.equals(i1.source, i2.source)) {
                m.source = i1.source;
            }
            if (i1.registerNumber == i2.registerNumber) {
                m.registerNumber = i1.registerNumber;
            }
            if (i1.fieldLoadedFromRegister == i2.fieldLoadedFromRegister) {
                m.fieldLoadedFromRegister = i1.fieldLoadedFromRegister;
            }
            if (i1.specialKind == i2.specialKind) {
                m.specialKind = i1.specialKind;
            } else if (i1.specialKind == 13 || i2.specialKind == 13) {
                m.specialKind = 13;
            } else if (i1.specialKind == 7 || i2.specialKind == 7) {
                m.specialKind = 7;
            }
            if (DEBUG) {
                System.out.println("Merge " + i1 + " and " + i2 + " gives " + m);
            }
            return m;
        }

        public Item(String signature, int constValue) {
            this(signature, new Integer(constValue));
        }

        public Item(String signature) {
            this(signature, UNKNOWN);
        }

        public Item(Item it) {
            this.signature = it.signature;
            this.constValue = it.constValue;
            this.source = it.source;
            this.registerNumber = it.registerNumber;
            this.userValue = it.userValue;
            this.flags = it.flags;
            this.specialKind = it.specialKind;
        }

        public Item(Item it, int reg) {
            this(it);
            this.registerNumber = reg;
        }

        public Item(String signature, FieldAnnotation f) {
            this.signature = signature;
            if (f != null) {
                this.source = XFactory.createXField(f);
            }
            this.fieldLoadedFromRegister = -1;
        }

        public Item(String signature, FieldAnnotation f, int fieldLoadedFromRegister) {
            this.signature = signature;
            if (f != null) {
                this.source = XFactory.createXField(f);
            }
            this.fieldLoadedFromRegister = fieldLoadedFromRegister;
        }

        public int getFieldLoadedFromRegister() {
            return this.fieldLoadedFromRegister;
        }

        public Item(String signature, Object constantValue) {
            this.signature = signature;
            this.constValue = constantValue;
            if (constantValue instanceof Integer) {
                int value = (Integer)constantValue;
                if (value != 0 && (value & 0xFF) == 0) {
                    this.specialKind = 3;
                }
                if (value == 0) {
                    this.setCouldBeZero(true);
                }
            } else if (constantValue instanceof Long) {
                long value = (Long)constantValue;
                if (value != 0L && (value & 0xFFL) == 0L) {
                    this.specialKind = 3;
                }
                if (value == 0L) {
                    this.setCouldBeZero(true);
                }
            }
        }

        public Item() {
            this.signature = "Ljava/lang/Object;";
            this.constValue = null;
            this.setNull(true);
        }

        public JavaClass getJavaClass() throws ClassNotFoundException {
            if (this.isPrimitive()) {
                return null;
            }
            String baseSig = this.isArray() ? this.getElementSignature() : this.signature;
            if (baseSig.length() == 0) {
                return null;
            }
            baseSig = baseSig.substring(1, baseSig.length() - 1);
            baseSig = baseSig.replace('/', '.');
            return Repository.lookupClass(baseSig);
        }

        public boolean isArray() {
            return this.signature.startsWith("[");
        }

        public String getElementSignature() {
            int pos;
            if (!this.isArray()) {
                return this.signature;
            }
            int len = this.signature.length();
            for (pos = 0; pos < len && this.signature.charAt(pos) == '['; ++pos) {
            }
            return this.signature.substring(pos);
        }

        public boolean isNonNegative() {
            if (this.specialKind == 12) {
                return true;
            }
            if (this.constValue instanceof Number) {
                double value = ((Number)this.constValue).doubleValue();
                return value >= 0.0;
            }
            return false;
        }

        public boolean isPrimitive() {
            return !this.signature.startsWith("L");
        }

        public int getRegisterNumber() {
            return this.registerNumber;
        }

        public String getSignature() {
            return this.signature;
        }

        public Object getConstant() {
            return this.constValue;
        }

        @Deprecated
        public FieldAnnotation getFieldAnnotation() {
            return FieldAnnotation.fromXField(this.getXField());
        }

        public XField getXField() {
            if (this.source instanceof XField) {
                return (XField)this.source;
            }
            return null;
        }

        public void setSpecialKind(int specialKind) {
            this.specialKind = specialKind;
        }

        public int getSpecialKind() {
            return this.specialKind;
        }

        public void setUserValue(Object value) {
            this.userValue = value;
        }

        @CheckForNull
        public XMethod getReturnValueOf() {
            if (this.source instanceof XMethod) {
                return (XMethod)this.source;
            }
            return null;
        }

        public boolean couldBeZero() {
            return this.isCouldBeZero();
        }

        public boolean mustBeZero() {
            Object value = this.getConstant();
            return value instanceof Number && ((Number)value).intValue() == 0;
        }

        public Object getUserValue() {
            return this.userValue;
        }

        public boolean valueCouldBeNegative() {
            return this.getSpecialKind() == 2 || this.getSpecialKind() == 1 || this.getSpecialKind() == 4 || this.getSpecialKind() == 8 || this.getSpecialKind() == 9;
        }

        private void setInitialParameter(boolean isInitialParameter) {
            this.setFlag(isInitialParameter, 1);
        }

        public boolean isInitialParameter() {
            return (this.flags & 1) != 0;
        }

        private void setCouldBeZero(boolean couldBeZero) {
            this.setFlag(couldBeZero, 2);
        }

        private boolean isCouldBeZero() {
            return (this.flags & 2) != 0;
        }

        private void setNull(boolean isNull) {
            this.setFlag(isNull, 4);
        }

        private void setFlag(boolean value, int flagBit) {
            this.flags = value ? (this.flags |= flagBit) : (this.flags &= ~flagBit);
        }

        public boolean isNull() {
            return (this.flags & 4) != 0;
        }
    }
}

