/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import edu.umd.cs.findbugs.AbstractBugReporter;
import edu.umd.cs.findbugs.AnalysisError;
import edu.umd.cs.findbugs.BugAnnotation;
import edu.umd.cs.findbugs.BugCategory;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugPattern;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.I18N;
import edu.umd.cs.findbugs.PackageMemberAnnotation;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import java.io.PrintStream;
import java.util.Iterator;

public abstract class TextUIBugReporter
extends AbstractBugReporter {
    private boolean reportStackTrace = true;
    private boolean useLongBugCodes = false;
    private boolean reportHistory = false;
    private boolean reportUserDesignations = false;
    static final String OTHER_CATEGORY_ABBREV = "X";
    protected PrintStream outputStream = System.out;
    private boolean analysisErrors;
    private boolean missingClasses;

    public void setOutputStream(PrintStream outputStream) {
        this.outputStream = outputStream;
    }

    public void setReportStackTrace(boolean reportStackTrace) {
        this.reportStackTrace = reportStackTrace;
    }

    protected void printBug(BugInstance bugInstance) {
        SourceLineAnnotation line;
        switch (bugInstance.getPriority()) {
            case 4: {
                this.outputStream.print("E ");
                break;
            }
            case 3: {
                this.outputStream.print("L ");
                break;
            }
            case 2: {
                this.outputStream.print("M ");
                break;
            }
            case 1: {
                this.outputStream.print("H ");
            }
        }
        BugPattern pattern = bugInstance.getBugPattern();
        if (pattern != null) {
            String categoryAbbrev = null;
            BugCategory bcat = I18N.instance().getBugCategory(pattern.getCategory());
            if (bcat != null) {
                categoryAbbrev = bcat.getAbbrev();
            }
            if (categoryAbbrev == null) {
                categoryAbbrev = OTHER_CATEGORY_ABBREV;
            }
            this.outputStream.print(categoryAbbrev);
            this.outputStream.print(" ");
        }
        if (this.useLongBugCodes) {
            this.outputStream.print(bugInstance.getType());
            this.outputStream.print(" ");
        }
        if (this.reportUserDesignations) {
            this.outputStream.print(bugInstance.getUserDesignationKey());
            this.outputStream.print(" ");
        }
        if (this.reportHistory) {
            long first = bugInstance.getFirstVersion();
            long last = bugInstance.getLastVersion();
            this.outputStream.print(first);
            this.outputStream.print(" ");
            this.outputStream.print(last);
            this.outputStream.print(" ");
        }
        if ((line = bugInstance.getPrimarySourceLineAnnotation()) == null) {
            this.outputStream.println(bugInstance.getMessage());
        } else {
            this.outputStream.println(bugInstance.getMessage() + "  " + line.toString());
        }
    }

    public void reportQueuedErrors() {
        this.missingClasses = false;
        this.analysisErrors = false;
        super.reportQueuedErrors();
    }

    public void reportAnalysisError(AnalysisError error) {
        if (!this.analysisErrors) {
            this.emitLine("The following errors occurred during analysis:");
            this.analysisErrors = true;
        }
        this.emitLine("\t" + error.getMessage());
        if (error.getExceptionMessage() != null) {
            String[] stackTrace;
            this.emitLine("\t\t" + error.getExceptionMessage());
            if (this.reportStackTrace && (stackTrace = error.getStackTrace()) != null) {
                String[] arr$ = stackTrace;
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    String aStackTrace = arr$[i$];
                    this.emitLine("\t\t\tAt " + aStackTrace);
                }
            }
        }
    }

    public void reportMissingClass(String message) {
        if (!this.missingClasses) {
            this.emitLine("The following classes needed for analysis were missing:");
            this.missingClasses = true;
        }
        this.emitLine("\t" + message);
    }

    protected void emitLine(String line) {
        line = line.replaceAll("\t", "  ");
        System.err.println(line);
    }

    public boolean getUseLongBugCodes() {
        return this.useLongBugCodes;
    }

    public void setReportHistory(boolean reportHistory) {
        this.reportHistory = reportHistory;
    }

    public void setUseLongBugCodes(boolean useLongBugCodes) {
        this.useLongBugCodes = useLongBugCodes;
    }

    public void setReportUserDesignations(boolean reportUserDesignations) {
        this.reportUserDesignations = reportUserDesignations;
    }

    public BugReporter getRealBugReporter() {
        return this;
    }

    protected void checkBugInstance(BugInstance bugInstance) {
        Iterator<BugAnnotation> i = bugInstance.annotationIterator();
        while (i.hasNext()) {
            PackageMemberAnnotation pkgMember;
            BugAnnotation bugAnnotation = i.next();
            if (!(bugAnnotation instanceof PackageMemberAnnotation) || (pkgMember = (PackageMemberAnnotation)bugAnnotation).getSourceLines() != null) continue;
            throw new IllegalStateException("Package member " + pkgMember + " reported without source lines!");
        }
    }
}

