/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba;

import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.BasicAbstractDataflowAnalysis;
import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.CFGBuilderException;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.Dataflow;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.DataflowCFGPrinter;
import edu.umd.cs.findbugs.ba.DebugRepositoryLookupFailureCallback;
import edu.umd.cs.findbugs.ba.RepositoryClassParser;
import edu.umd.cs.findbugs.ba.SignatureConverter;
import java.io.IOException;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.MethodGen;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DataflowTestDriver<Fact, AnalysisType extends BasicAbstractDataflowAnalysis<Fact>> {
    private boolean overrideIsForwards;
    private static final Knob[] KNOB_LIST = new Knob[]{new Knob("ta.instanceof", 2), new Knob("inva.trackvalues", 6), new Knob("fnd.derefs", 5)};

    public void overrideIsForwards() {
        this.overrideIsForwards = true;
    }

    public void execute(String filename) throws DataflowAnalysisException, CFGBuilderException, IOException {
        Method[] methods;
        JavaClass jclass = new RepositoryClassParser(filename).parse();
        DebugRepositoryLookupFailureCallback lookupFailureCallback = new DebugRepositoryLookupFailureCallback();
        AnalysisContext analysisContext = AnalysisContext.create(lookupFailureCallback);
        analysisContext.setBoolProperty(0, true);
        this.configureAnalysisContext(analysisContext);
        ClassContext classContext = analysisContext.getClassContext(jclass);
        String methodName = SystemProperties.getProperty("dataflow.method");
        for (Method method : methods = jclass.getMethods()) {
            MethodGen methodGen;
            if (methodName != null && !method.getName().equals(methodName) || (methodGen = classContext.getMethodGen(method)) == null) continue;
            System.out.println("-----------------------------------------------------------------");
            System.out.println(new StringBuffer().append("Method: ").append(SignatureConverter.convertMethodSignature(methodGen)).toString());
            System.out.println("-----------------------------------------------------------------");
            this.execute(classContext, method);
        }
    }

    private void configureAnalysisContext(AnalysisContext analysisContext) {
        boolean max = SystemProperties.getBoolean("dataflow.max");
        for (Knob knob : KNOB_LIST) {
            boolean enable = max || SystemProperties.getBoolean(knob.systemPropertyName);
            System.out.println(new StringBuffer().append("Setting ").append(knob.systemPropertyName).append("=").append(enable).toString());
            analysisContext.setBoolProperty(knob.analysisProperty, enable);
        }
    }

    public void execute(ClassContext classContext, Method method) throws DataflowAnalysisException, CFGBuilderException {
        Dataflow<Fact, AnalysisType> dataflow = this.createDataflow(classContext, method);
        System.out.println(new StringBuffer().append("Finished in ").append(dataflow.getNumIterations()).append(" iterations").toString());
        CFG cfg = classContext.getCFG(method);
        this.examineResults(cfg, dataflow);
        if (SystemProperties.getBoolean("dataflow.printcfg")) {
            DataflowCFGPrinter<Fact, AnalysisType> p = new DataflowCFGPrinter<Fact, AnalysisType>(dataflow);
            if (this.overrideIsForwards) {
                p.setIsForwards(!p.isForwards());
            }
            p.print(System.out);
        }
    }

    public abstract Dataflow<Fact, AnalysisType> createDataflow(ClassContext var1, Method var2) throws CFGBuilderException, DataflowAnalysisException;

    public void examineResults(CFG cfg, Dataflow<Fact, AnalysisType> dataflow) {
    }

    static class Knob {
        String systemPropertyName;
        int analysisProperty;

        Knob(String systemPropertyName, int analysisProperty) {
            this.systemPropertyName = systemPropertyName;
            this.analysisProperty = analysisProperty;
        }
    }
}

