/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba.type;

import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.Dataflow;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.Edge;
import edu.umd.cs.findbugs.ba.Location;
import edu.umd.cs.findbugs.ba.type.ExceptionSet;
import edu.umd.cs.findbugs.ba.type.TypeAnalysis;
import edu.umd.cs.findbugs.ba.type.TypeFrame;
import java.util.Collection;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeDataflow
extends Dataflow<TypeFrame, TypeAnalysis> {
    public TypeDataflow(CFG cfg, TypeAnalysis analysis) {
        super(cfg, analysis);
    }

    public TypeFrame getFactAtLocation(Location loc) throws DataflowAnalysisException {
        return (TypeFrame)((TypeAnalysis)this.getAnalysis()).getFactAtLocation(loc);
    }

    public TypeFrame getFactAfterLocation(Location loc) throws DataflowAnalysisException {
        return (TypeFrame)((TypeAnalysis)this.getAnalysis()).getFactAfterLocation(loc);
    }

    public ExceptionSet getEdgeExceptionSet(Edge edge) {
        return ((TypeAnalysis)this.getAnalysis()).getEdgeExceptionSet(edge);
    }

    public LocationAndFactPair getLocationAndFactForInstruction(int pc) {
        Collection<Location> locations = this.getCFG().getLocationsContainingInstructionWithOffset(pc);
        LocationAndFactPair result = null;
        for (Location location : locations) {
            try {
                TypeFrame frame = this.getFactAtLocation(location);
                if (!frame.isValid()) continue;
                result = new LocationAndFactPair(location, frame);
                break;
            }
            catch (DataflowAnalysisException e) {
            }
        }
        return result;
    }

    public static class LocationAndFactPair {
        public final Location location;
        public final TypeFrame frame;

        LocationAndFactPair(Location location, TypeFrame frame) {
            this.location = location;
            this.frame = frame;
        }
    }
}

