/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba.vna;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.ba.Frame;
import edu.umd.cs.findbugs.ba.XField;
import edu.umd.cs.findbugs.ba.vna.AvailableLoad;
import edu.umd.cs.findbugs.ba.vna.MergeTree;
import edu.umd.cs.findbugs.ba.vna.ValueNumber;
import edu.umd.cs.findbugs.ba.vna.ValueNumberAnalysisFeatures;
import edu.umd.cs.findbugs.ba.vna.ValueNumberFactory;
import edu.umd.cs.findbugs.util.Strings;
import edu.umd.cs.findbugs.util.Util;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValueNumberFrame
extends Frame<ValueNumber>
implements ValueNumberAnalysisFeatures {
    private ArrayList<ValueNumber> mergedValueList;
    private Map<AvailableLoad, ValueNumber[]> availableLoadMap;
    private Map<AvailableLoad, ValueNumber> mergedLoads;
    private Map<ValueNumber, AvailableLoad> previouslyKnownAs;
    public boolean phiNodeForLoads;
    static int constructedUnmodifiableMap;
    static int reusedMap;
    static int createdEmptyMap;
    static int madeImmutableMutable;
    static int reusedMutableMap;

    public ValueNumberFrame(int numLocals) {
        super(numLocals);
        if (REDUNDANT_LOAD_ELIMINATION) {
            this.setAvailableLoadMap(Collections.EMPTY_MAP);
            this.setMergedLoads(Collections.EMPTY_MAP);
            this.setPreviouslyKnownAs(Collections.EMPTY_MAP);
        }
    }

    public String availableLoadMapAsString() {
        StringBuffer buf = new StringBuffer("{ ");
        for (Map.Entry<AvailableLoad, ValueNumber[]> e : this.getAvailableLoadMap().entrySet()) {
            buf.append(e.getKey());
            buf.append("=");
            for (ValueNumber v : e.getValue()) {
                buf.append(v).append(",");
            }
            buf.append(";  ");
        }
        buf.append(" }");
        return buf.toString();
    }

    @CheckForNull
    public AvailableLoad getLoad(ValueNumber v) {
        if (!REDUNDANT_LOAD_ELIMINATION) {
            return null;
        }
        for (Map.Entry<AvailableLoad, ValueNumber[]> e : this.getAvailableLoadMap().entrySet()) {
            if (e.getValue() == null) continue;
            for (ValueNumber v2 : e.getValue()) {
                if (!v.equals(v2)) continue;
                return e.getKey();
            }
        }
        return null;
    }

    public ValueNumber[] getAvailableLoad(AvailableLoad availableLoad) {
        return this.getAvailableLoadMap().get(availableLoad);
    }

    public void addAvailableLoad(AvailableLoad availableLoad, @NonNull ValueNumber[] value) {
        if (value == null) {
            throw new IllegalStateException();
        }
        this.getUpdateableAvailableLoadMap().put(availableLoad, value);
        for (ValueNumber v : value) {
            this.getUpdateablePreviouslyKnownAs().put(v, availableLoad);
            if (!RLE_DEBUG) continue;
            System.out.println(new StringBuffer().append("Adding available load of ").append(availableLoad).append(" for ").append(v).append(" to ").append(System.identityHashCode(this)).toString());
        }
    }

    public void killLoadsOfField(XField field) {
        Iterator<AvailableLoad> i = this.getAvailableLoadMap().keySet().iterator();
        while (i.hasNext()) {
            AvailableLoad availableLoad = i.next();
            if (!availableLoad.getField().equals(field)) continue;
            if (RLE_DEBUG) {
                System.out.println(new StringBuffer().append("KILLING Load of ").append(availableLoad).append(" in ").append(this).toString());
            }
            i.remove();
        }
    }

    public void killAllLoads() {
        if (REDUNDANT_LOAD_ELIMINATION) {
            Iterator<AvailableLoad> i = this.getAvailableLoadMap().keySet().iterator();
            while (i.hasNext()) {
                AvailableLoad availableLoad = i.next();
                if (availableLoad.getField().isFinal()) continue;
                if (RLE_DEBUG) {
                    System.out.println(new StringBuffer().append("KILLING load of ").append(availableLoad).append(" in ").append(this).toString());
                }
                i.remove();
            }
        }
    }

    public void killAllLoadsOf(@CheckForNull ValueNumber v) {
        if (REDUNDANT_LOAD_ELIMINATION) {
            Iterator<AvailableLoad> i = this.getAvailableLoadMap().keySet().iterator();
            while (i.hasNext()) {
                AvailableLoad availableLoad = i.next();
                if (availableLoad.getField().isFinal() || availableLoad.getReference() != v) continue;
                if (RLE_DEBUG) {
                    System.out.println(new StringBuffer().append("Killing load of ").append(availableLoad).append(" in ").append(this).toString());
                }
                i.remove();
            }
        }
    }

    public void killLoadsWithSimilarName(String className, String methodName) {
        String packageName = this.extractPackageName(className);
        if (REDUNDANT_LOAD_ELIMINATION) {
            Iterator<AvailableLoad> i = this.getAvailableLoadMap().keySet().iterator();
            while (i.hasNext()) {
                AvailableLoad availableLoad = i.next();
                XField field = availableLoad.getField();
                String fieldPackageName = this.extractPackageName(field.getClassName());
                if (!packageName.equals(fieldPackageName) || !field.isStatic() || methodName.toLowerCase().indexOf(field.getName().toLowerCase()) < 0) continue;
                i.remove();
            }
        }
    }

    private String extractPackageName(String className) {
        return className.substring(className.lastIndexOf(46) + 1);
    }

    void mergeAvailableLoadSets(ValueNumberFrame other, ValueNumberFactory factory, MergeTree mergeTree) {
        if (REDUNDANT_LOAD_ELIMINATION) {
            String s = "";
            if (RLE_DEBUG) {
                s = new StringBuffer().append("Merging ").append(this.availableLoadMapAsString()).append(" and ").append(other.availableLoadMapAsString()).toString();
            }
            boolean changed = false;
            if (other.isBottom()) {
                changed = !this.getAvailableLoadMap().isEmpty();
                this.setAvailableLoadMap(Collections.EMPTY_MAP);
            } else if (!other.isTop()) {
                for (Map.Entry<AvailableLoad, ValueNumber[]> e : this.getAvailableLoadMap().entrySet()) {
                    Object[] otherVN;
                    AvailableLoad load = e.getKey();
                    Object[] myVN = e.getValue();
                    if (Arrays.equals(myVN, otherVN = other.getAvailableLoadMap().get(load))) continue;
                    ValueNumber phi = this.getMergedLoads().get(load);
                    if (phi == null) {
                        phi = factory.createFreshValue();
                        int flags = 8;
                        this.getUpdateableMergedLoads().put(load, phi);
                        for (Object vn : myVN) {
                            mergeTree.mapInputToOutput((ValueNumber)vn, phi);
                            flags |= ((ValueNumber)vn).getFlags();
                        }
                        if (otherVN != null) {
                            for (Object vn : otherVN) {
                                mergeTree.mapInputToOutput((ValueNumber)vn, phi);
                                flags |= ((ValueNumber)vn).getFlags();
                            }
                        }
                        phi.setFlag(flags);
                        if (RLE_DEBUG) {
                            System.out.println(new StringBuffer().append("Creating phi node ").append(phi).append(" for ").append(load).append(" from ").append(Strings.toString(myVN)).append(" x ").append(Strings.toString(otherVN)).append(" in ").append(System.identityHashCode(this)).toString());
                        }
                        changed = true;
                        e.setValue(new ValueNumber[]{phi});
                        continue;
                    }
                    if (RLE_DEBUG) {
                        System.out.println(new StringBuffer().append("Reusing phi node : ").append(phi).append(" for ").append(load).append(" from ").append(Strings.toString(myVN)).append(" x ").append(Strings.toString(otherVN)).append(" in ").append(System.identityHashCode(this)).toString());
                    }
                    if (myVN.length == 1 && ((ValueNumber)myVN[0]).equals(phi)) continue;
                    e.setValue(new ValueNumber[]{phi});
                }
            }
            Map<ValueNumber, AvailableLoad> previouslyKnownAsOther = other.getPreviouslyKnownAs();
            if (this.getPreviouslyKnownAs() != previouslyKnownAsOther && previouslyKnownAsOther.size() != 0) {
                if (this.getPreviouslyKnownAs().size() == 0) {
                    this.assignPreviouslyKnownAs(other);
                } else {
                    this.getUpdateablePreviouslyKnownAs().putAll(previouslyKnownAsOther);
                }
            }
            if (changed) {
                this.phiNodeForLoads = true;
            }
            if (changed && RLE_DEBUG) {
                System.out.println(s);
                System.out.println(new StringBuffer().append("  Result is ").append(this.availableLoadMapAsString()).toString());
                System.out.println(new StringBuffer().append(" Set phi for ").append(System.identityHashCode(this)).toString());
            }
        }
    }

    ValueNumber getMergedValue(int slot) {
        return this.mergedValueList.get(slot);
    }

    void setMergedValue(int slot, ValueNumber value) {
        this.mergedValueList.set(slot, value);
    }

    @Override
    public void copyFrom(Frame<ValueNumber> other) {
        if (this.mergedValueList == null && other.isValid()) {
            this.mergedValueList = new ArrayList();
            int numSlots = other.getNumSlots();
            for (int i = 0; i < numSlots; ++i) {
                this.mergedValueList.add(null);
            }
        }
        if (REDUNDANT_LOAD_ELIMINATION) {
            Map<AvailableLoad, ValueNumber[]> availableLoadMapOther = ((ValueNumberFrame)other).getAvailableLoadMap();
            if (availableLoadMapOther.size() == 0) {
                this.setAvailableLoadMap(Collections.EMPTY_MAP);
            } else {
                this.getUpdateableAvailableLoadMap().clear();
                this.getUpdateableAvailableLoadMap().putAll(availableLoadMapOther);
            }
            this.assignPreviouslyKnownAs(other);
        }
        super.copyFrom(other);
    }

    private void assignPreviouslyKnownAs(Frame<ValueNumber> other) {
        Map<ValueNumber, AvailableLoad> previouslyKnownAsOther = ((ValueNumberFrame)other).getPreviouslyKnownAs();
        if (previouslyKnownAsOther instanceof HashMap) {
            previouslyKnownAsOther = Collections.unmodifiableMap(previouslyKnownAsOther);
            ((ValueNumberFrame)other).setPreviouslyKnownAs(previouslyKnownAsOther);
            this.setPreviouslyKnownAs(previouslyKnownAsOther);
            ++constructedUnmodifiableMap;
        } else {
            this.setPreviouslyKnownAs(previouslyKnownAsOther);
            ++reusedMap;
        }
    }

    @Override
    public String toString() {
        String frameValues = super.toString();
        if (RLE_DEBUG) {
            StringBuffer buf = new StringBuffer();
            buf.append(frameValues);
            Iterator<AvailableLoad> i = this.getAvailableLoadMap().keySet().iterator();
            boolean first = true;
            while (i.hasNext()) {
                AvailableLoad key = i.next();
                ValueNumber[] value = this.getAvailableLoadMap().get(key);
                if (first) {
                    first = false;
                } else {
                    buf.append(',');
                }
                buf.append(new StringBuffer().append(key).append("=").append(ValueNumberFrame.valueToString(value)).toString());
            }
            buf.append(" #");
            buf.append(System.identityHashCode(this));
            if (this.phiNodeForLoads) {
                buf.append(" phi");
            }
            return buf.toString();
        }
        return frameValues;
    }

    private static String valueToString(ValueNumber[] valueNumberList) {
        StringBuffer buf = new StringBuffer();
        buf.append('[');
        boolean first = true;
        for (ValueNumber aValueNumberList : valueNumberList) {
            if (first) {
                first = false;
            } else {
                buf.append(',');
            }
            buf.append(aValueNumberList.getNumber());
        }
        buf.append(']');
        return buf.toString();
    }

    public boolean fuzzyMatch(ValueNumber v1, ValueNumber v2) {
        if (REDUNDANT_LOAD_ELIMINATION) {
            return v1.equals(v2) || this.fromMatchingLoads(v1, v2) || this.haveMatchingFlags(v1, v2);
        }
        return v1.equals(v2);
    }

    public boolean fromMatchingLoads(ValueNumber v1, ValueNumber v2) {
        AvailableLoad load1 = this.getLoad(v1);
        if (load1 == null) {
            load1 = this.getPreviouslyKnownAs().get(v1);
        }
        if (load1 == null) {
            return false;
        }
        AvailableLoad load2 = this.getLoad(v2);
        if (load2 == null) {
            load2 = this.getPreviouslyKnownAs().get(v2);
        }
        if (load2 == null) {
            return false;
        }
        return load1.equals(load2);
    }

    public boolean haveMatchingFlags(ValueNumber v1, ValueNumber v2) {
        int flag2;
        int flag1 = v1.getFlags();
        return (flag1 & (flag2 = v2.getFlags())) != 0;
    }

    public Collection<ValueNumber> valueNumbersForLoads() {
        HashSet<ValueNumber> result = new HashSet<ValueNumber>();
        if (REDUNDANT_LOAD_ELIMINATION) {
            for (Map.Entry<AvailableLoad, ValueNumber[]> e : this.getAvailableLoadMap().entrySet()) {
                if (e.getValue() == null) continue;
                for (ValueNumber v2 : e.getValue()) {
                    result.add(v2);
                }
            }
        }
        return result;
    }

    private void setAvailableLoadMap(Map<AvailableLoad, ValueNumber[]> availableLoadMap) {
        this.availableLoadMap = availableLoadMap;
    }

    private Map<AvailableLoad, ValueNumber[]> getAvailableLoadMap() {
        return this.availableLoadMap;
    }

    private Map<AvailableLoad, ValueNumber[]> getUpdateableAvailableLoadMap() {
        if (!(this.availableLoadMap instanceof HashMap)) {
            this.availableLoadMap = new HashMap<AvailableLoad, ValueNumber[]>();
        }
        return this.availableLoadMap;
    }

    private void setMergedLoads(Map<AvailableLoad, ValueNumber> mergedLoads) {
        this.mergedLoads = mergedLoads;
    }

    private Map<AvailableLoad, ValueNumber> getMergedLoads() {
        return this.mergedLoads;
    }

    private Map<AvailableLoad, ValueNumber> getUpdateableMergedLoads() {
        if (!(this.mergedLoads instanceof HashMap)) {
            this.mergedLoads = new HashMap<AvailableLoad, ValueNumber>();
        }
        return this.mergedLoads;
    }

    private void setPreviouslyKnownAs(Map<ValueNumber, AvailableLoad> previouslyKnownAs) {
        this.previouslyKnownAs = previouslyKnownAs;
    }

    private Map<ValueNumber, AvailableLoad> getPreviouslyKnownAs() {
        return this.previouslyKnownAs;
    }

    private Map<ValueNumber, AvailableLoad> getUpdateablePreviouslyKnownAs() {
        if (this.previouslyKnownAs.size() == 0) {
            this.previouslyKnownAs = new HashMap<ValueNumber, AvailableLoad>(4);
            ++createdEmptyMap;
        } else if (!(this.previouslyKnownAs instanceof HashMap)) {
            this.previouslyKnownAs = new HashMap<ValueNumber, AvailableLoad>(this.previouslyKnownAs);
            ++madeImmutableMutable;
        } else {
            ++reusedMutableMap;
        }
        return this.previouslyKnownAs;
    }

    static {
        Util.runLogAtShutdown(new Runnable(){

            public void run() {
                System.err.println("Getting updatable previously known as:");
                System.err.println("  " + createdEmptyMap + " created empty map");
                System.err.println("  " + madeImmutableMutable + " made immutable map mutable");
                System.err.println("  " + reusedMutableMap + " reused mutable map");
                System.err.println("Copying map:");
                System.err.println("  " + constructedUnmodifiableMap + " made mutable map unmodifiable");
                System.err.println("  " + reusedMap + " reused immutable map");
                System.err.println();
            }
        });
    }
}

