/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.filter;

import java.util.StringTokenizer;

public class SignatureUtil {
    public static String createMethodSignature(String params, String returns) {
        if (params == null && returns == null) {
            return null;
        }
        if (params == null) {
            throw new NullPointerException("params is null but returns is nonnull");
        }
        if (returns == null) {
            throw new NullPointerException("returns is null but params is nonnull");
        }
        StringBuffer buf = new StringBuffer();
        buf.append('(');
        StringTokenizer tok = new StringTokenizer(params, " \t\n\r\f,");
        while (tok.hasMoreTokens()) {
            String param = SignatureUtil.typeToSignature(tok.nextToken());
            buf.append(param);
        }
        buf.append(')');
        buf.append(SignatureUtil.typeToSignature(returns));
        return buf.toString();
    }

    public static String createFieldSignature(String type) {
        if (type == null) {
            return null;
        }
        return SignatureUtil.typeToSignature(type);
    }

    private static String typeToSignature(String type) {
        if (type.endsWith("[]")) {
            return "[" + SignatureUtil.typeToSignature(type.substring(0, type.length() - 2));
        }
        return SignatureUtil.scalarTypeToSiganture(type);
    }

    private static String scalarTypeToSiganture(String type) {
        if (type.equals("boolean")) {
            return "Z";
        }
        if (type.equals("byte")) {
            return "B";
        }
        if (type.equals("char")) {
            return "C";
        }
        if (type.equals("short")) {
            return "S";
        }
        if (type.equals("int")) {
            return "I";
        }
        if (type.equals("long")) {
            return "J";
        }
        if (type.equals("float")) {
            return "F";
        }
        if (type.equals("double")) {
            return "D";
        }
        if (type.equals("void")) {
            return "V";
        }
        return "L" + type.replace('.', '/') + ";";
    }
}

