/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.data.views.calls;

import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.data.ImportException;
import org.openmicroscopy.shoola.env.data.OmeroImageService;
import org.openmicroscopy.shoola.env.data.OmeroSessionServiceImpl;
import org.openmicroscopy.shoola.env.data.model.ImportRequestData;
import org.openmicroscopy.shoola.env.data.model.ImportableFile;
import org.openmicroscopy.shoola.env.data.model.ImportableObject;
import org.openmicroscopy.shoola.env.data.views.BatchCall;
import org.openmicroscopy.shoola.env.data.views.BatchCallTree;
import org.openmicroscopy.shoola.env.data.views.calls.OfflineImportRequestBuilder;
import org.openmicroscopy.shoola.svc.SvcRegistry;
import org.openmicroscopy.shoola.svc.communicator.Communicator;
import org.openmicroscopy.shoola.svc.communicator.CommunicatorDescriptor;

class OfflineImagesImporter
extends BatchCallTree {
    private final ImportableObject target;
    private final Map<ImportableFile, Object> partialResult;
    private final String importSessionKey;

    private static String createImportSession(Registry context) {
        try {
            OmeroSessionServiceImpl service = new OmeroSessionServiceImpl(context);
            return service.createOfflineImportSession();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    OfflineImagesImporter(ImportableObject target) {
        this.target = target;
        this.partialResult = new HashMap<ImportableFile, Object>();
        this.importSessionKey = OfflineImagesImporter.createImportSession(this.context);
    }

    private boolean prepareImport(ImportableFile importData, boolean close) {
        try {
            Boolean b;
            OmeroImageService os = this.context.getImageService();
            Object outcome = os.importFile(this.target, importData, close);
            if (outcome instanceof ImportException) {
                this.partialResult.put(importData, outcome);
                return false;
            }
            if (outcome instanceof Boolean && (!(b = (Boolean)outcome).booleanValue() || importData.getStatus().isMarkedAsDuplicate())) {
                this.partialResult.put(importData, outcome);
                return false;
            }
            return true;
        }
        catch (Exception e) {
            this.partialResult.put(importData, e);
            return false;
        }
    }

    private ImportRequestData[] buildImportBatchRequest(List<ImportableFile> batch) {
        ArrayList<ImportRequestData> data = new ArrayList<ImportRequestData>();
        for (ImportableFile importData : batch) {
            OfflineImportRequestBuilder builder = new OfflineImportRequestBuilder(this.context, this.target, importData);
            data.add(builder.buildRequest(this.importSessionKey));
        }
        return data.toArray(new ImportRequestData[0]);
    }

    private void notifySubmissionError(List<ImportableFile> batch, Exception e) {
        for (ImportableFile f : batch) {
            this.partialResult.put(f, e);
            f.getStatus().notifyOfflineImportFailure(e);
        }
    }

    private void notifySubmissionSuccess(List<ImportableFile> batch) {
        for (ImportableFile f : batch) {
            f.getStatus().notifySuccessfulOfflineImport();
            this.partialResult.put(f, true);
        }
    }

    private void submit(List<ImportableFile> batch) {
        try {
            ImportRequestData[] data = this.buildImportBatchRequest(batch);
            String tokenURL = (String)this.context.lookup("omero.client.import.offline.url");
            CommunicatorDescriptor desc = new CommunicatorDescriptor(1, tokenURL, -1);
            Communicator c = SvcRegistry.getCommunicator(desc);
            Gson writer = new Gson();
            c.enqueueImport(writer.toJson((Object)data), new StringBuilder());
            this.notifySubmissionSuccess(batch);
        }
        catch (Exception e) {
            this.notifySubmissionError(batch, e);
        }
    }

    private void enqueueImportBatch() {
        ArrayList<ImportableFile> batchToSubmit = new ArrayList<ImportableFile>();
        ImportableFile[] importData = this.target.getFiles().toArray(new ImportableFile[0]);
        for (int k = 0; k < importData.length; ++k) {
            boolean isLast = k == importData.length - 1;
            boolean succeeded = this.prepareImport(importData[k], isLast);
            if (!succeeded) continue;
            batchToSubmit.add(importData[k]);
        }
        this.submit(batchToSubmit);
    }

    @Override
    protected void buildTree() {
        this.add(new BatchCall("Importing files"){

            @Override
            public void doCall() {
                OfflineImagesImporter.this.enqueueImportBatch();
            }
        });
    }

    @Override
    protected Object getPartialResult() {
        return this.partialResult;
    }

    @Override
    protected Object getResult() {
        return null;
    }
}

