/*
 * Decompiled with CFR 0.152.
 */
package omero.gateway.util;

import java.awt.Color;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import omero.gateway.model.MaskData;
import omero.gateway.model.ROIData;
import omero.gateway.util.MaskClass;
import omero.gateway.util.ROIComponent;
import omero.model.RoiI;

public class UploadMask {
    private static final int DEFAUL_COLOR = Color.black.getRGB();
    private ROIComponent component;

    private Map<Integer, MaskData> mapToMaskData(Map<Integer, MaskClass> map, int z, int t, int c) throws IOException {
        HashMap<Integer, MaskData> maskDataMap = new HashMap<Integer, MaskData>();
        for (int value : map.keySet()) {
            MaskData mask = map.get(value).asMaskData(z, t, c);
            maskDataMap.put(value, mask);
        }
        return maskDataMap;
    }

    public UploadMask(long imageId) {
        this.component = new ROIComponent(imageId);
    }

    public void addImage(byte[] image, int z, int t, int c) throws IOException {
        Map<Integer, MaskClass> classMap = this.createMasks(image);
        Map<Integer, MaskData> maskMap = this.mapToMaskData(classMap, z, t, c);
        this.component.addMasks(maskMap);
    }

    public void addArray(int[][] image, int z, int t, int c) throws IOException {
        Map<Integer, MaskClass> classMap = this.createMasks(image);
        Map<Integer, MaskData> maskMap = this.mapToMaskData(classMap, z, t, c);
        this.component.addMasks(maskMap);
    }

    private Map<Integer, MaskClass> createMasks(byte[] bytes) throws IOException {
        HashMap<Integer, MaskClass> maskMap = new HashMap<Integer, MaskClass>();
        ByteArrayInputStream imageStream = new ByteArrayInputStream(bytes);
        BufferedImage inputImage = ImageIO.read(imageStream);
        for (int x = 0; x < inputImage.getWidth(); ++x) {
            for (int y = 0; y < inputImage.getHeight(); ++y) {
                MaskClass mask;
                int value = inputImage.getRGB(x, y);
                if (value == DEFAUL_COLOR) continue;
                if (!maskMap.containsKey(value)) {
                    mask = new MaskClass(value);
                    maskMap.put(value, mask);
                } else {
                    mask = (MaskClass)maskMap.get(value);
                }
                mask.add(new Point(x, y));
            }
        }
        return maskMap;
    }

    private Map<Integer, MaskClass> createMasks(int[][] data) throws IOException {
        HashMap<Integer, MaskClass> maskMap = new HashMap<Integer, MaskClass>();
        for (int y = 0; y < data.length; ++y) {
            for (int x = 0; x < data[y].length; ++x) {
                MaskClass mask;
                int value = data[x][y];
                if (value == DEFAUL_COLOR || value == 0) continue;
                if (!maskMap.containsKey(value)) {
                    mask = new MaskClass(value);
                    maskMap.put(value, mask);
                } else {
                    mask = (MaskClass)maskMap.get(value);
                }
                mask.add(new Point(x, y));
            }
        }
        return maskMap;
    }

    public List<RoiI> getROI() {
        List<ROIData> roiList = this.component.getROI();
        ArrayList<RoiI> rList = new ArrayList<RoiI>();
        for (ROIData roi : roiList) {
            rList.add((RoiI)roi.asIObject());
        }
        return rList;
    }
}

