/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.filter.file;

import java.io.File;
import org.openmicroscopy.shoola.util.filter.file.CustomizedFileFilter;

public class CppFilter
extends CustomizedFileFilter {
    public static final String CPP = "cpp";
    public static final String CC = "cc";
    public static final String[] extensions = new String[2];
    private static final String description;

    @Override
    public String getMIMEType() {
        return "application/octet-stream";
    }

    @Override
    public String getExtension() {
        return CPP;
    }

    @Override
    public String getDescription() {
        return description;
    }

    @Override
    public boolean accept(File f) {
        if (f == null) {
            return false;
        }
        if (f.isDirectory()) {
            return true;
        }
        return this.isSupported(f.getName(), extensions);
    }

    @Override
    public boolean accept(String fileName) {
        return this.isSupported(fileName, extensions);
    }

    static {
        CppFilter.extensions[0] = CPP;
        CppFilter.extensions[1] = CC;
        StringBuffer s = new StringBuffer();
        s.append("C++ (");
        for (int i = 0; i < extensions.length; ++i) {
            s.append("*." + extensions[i]);
            if (i >= extensions.length - 1) continue;
            s.append(", ");
        }
        s.append(")");
        description = s.toString();
    }
}

