/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui.drawingtools.figures;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextLayout;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.LineConnectionFigure;
import org.jhotdraw.draw.TextHolderFigure;
import org.jhotdraw.draw.Tool;
import org.jhotdraw.geom.Insets2D;
import org.openmicroscopy.shoola.util.ui.drawingtools.attributes.DrawingAttributes;
import org.openmicroscopy.shoola.util.ui.drawingtools.figures.FigureUtil;
import org.openmicroscopy.shoola.util.ui.drawingtools.texttools.DrawingTextTool;

public class LineConnectionTextFigure
extends LineConnectionFigure
implements TextHolderFigure {
    private boolean editable;
    private Rectangle2D.Double textBounds;

    public LineConnectionTextFigure(String text) {
        this.setText(text);
        this.textBounds = null;
        this.editable = true;
    }

    protected Rectangle2D.Double getTextBounds() {
        if (this.textBounds == null) {
            return new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
        }
        return this.textBounds;
    }

    public void setEditable(boolean b) {
        this.editable = b;
    }

    protected void drawFill(Graphics2D g) {
        super.drawFill(g);
        this.drawText(g);
    }

    protected void drawText(Graphics2D g) {
        if (!((Boolean)DrawingAttributes.SHOWTEXT.get((Figure)this)).booleanValue()) {
            return;
        }
        String text = this.getText();
        if (text != null) {
            double textWidth;
            if ((text = text.trim()).length() == 0) {
                return;
            }
            Rectangle2D.Double r = this.getBounds();
            Font font = (Font)AttributeKeys.FONT_FACE.get((Figure)this);
            font = font.deriveFont(((Double)AttributeKeys.FONT_SIZE.get((Figure)this)).floatValue());
            FontMetrics fm = g.getFontMetrics(font);
            double width = textWidth = (double)fm.stringWidth(text);
            double avgCharWidth = textWidth / (double)text.length();
            double maxTextWidth = avgCharWidth * 100.0;
            if (textWidth > maxTextWidth) {
                width = maxTextWidth;
            }
            double textHeight = (textWidth / width + 1.0) * (double)(fm.getAscent() + fm.getDescent() + fm.getLeading());
            double x = r.x + r.width / 2.0 - width / 2.0;
            double y = r.y + textHeight / 2.0;
            this.textBounds = new Rectangle2D.Double(x, y, width, textHeight);
            FontRenderContext frc = g.getFontRenderContext();
            AttributedString styledText = new AttributedString(text);
            FigureUtil.formatLayout(font, styledText, (Figure)this);
            AttributedCharacterIterator i = styledText.getIterator();
            LineBreakMeasurer measurer = new LineBreakMeasurer(i, frc);
            Color c = (Color)AttributeKeys.STROKE_COLOR.get((Figure)this);
            if (c != null) {
                g.setColor(c);
            }
            int w = (int)width;
            while (measurer.getPosition() < text.length()) {
                TextLayout layout = measurer.nextLayout(w);
                layout.draw(g, (float)x, (float)(y += (double)layout.getAscent()));
                y += (double)(layout.getDescent() + layout.getLeading());
            }
        }
    }

    public void invalidate() {
        super.invalidate();
    }

    public void validate() {
        super.validate();
    }

    public Rectangle2D.Double getDrawingArea() {
        Rectangle2D.Double r = super.getDrawingArea();
        r.add(this.getTextBounds());
        return r;
    }

    public Tool getTool(Point2D.Double p) {
        boolean showText = false;
        if (this.isEditable() && this.getBounds().contains(p)) {
            showText = true;
        }
        if (this.path != null && showText && this.path.outlineContains(p, 10.0)) {
            showText = false;
        }
        if (showText) {
            this.invalidate();
            return new DrawingTextTool(this);
        }
        return null;
    }

    public String getText() {
        return (String)this.getAttribute(AttributeKeys.TEXT);
    }

    public void setText(String newText) {
        boolean b = newText != null && newText.trim().length() > 0;
        this.setAttribute(DrawingAttributes.SHOWTEXT, b);
        this.setAttribute(AttributeKeys.TEXT, newText);
    }

    public int getTextColumns() {
        String t = this.getText();
        int n = 4;
        return t == null ? n : Math.max(t.length(), n);
    }

    public int getTabSize() {
        return 8;
    }

    public TextHolderFigure getLabelFor() {
        return this;
    }

    public Insets2D.Double getInsets() {
        return new Insets2D.Double();
    }

    public Font getFont() {
        return AttributeKeys.getFont((Figure)this);
    }

    public Color getTextColor() {
        return (Color)AttributeKeys.TEXT_COLOR.get((Figure)this);
    }

    public Color getFillColor() {
        return (Color)AttributeKeys.FILL_COLOR.get((Figure)this);
    }

    public float getFontSize() {
        return ((Double)AttributeKeys.FONT_SIZE.get((Figure)this)).floatValue();
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setFontSize(float size) {
    }

    public boolean isTextOverflow() {
        return false;
    }

    public LineConnectionTextFigure clone() {
        LineConnectionTextFigure that = (LineConnectionTextFigure)super.clone();
        that.setText(this.getText());
        return that;
    }
}

