/*
 * Decompiled with CFR 0.152.
 */
package omero.gateway.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import omero.RString;
import omero.gateway.model.AnnotationData;
import omero.gateway.model.BooleanAnnotationData;
import omero.gateway.model.DataObject;
import omero.gateway.model.DatasetData;
import omero.gateway.model.DoubleAnnotationData;
import omero.gateway.model.EllipseData;
import omero.gateway.model.ExperimenterData;
import omero.gateway.model.FileAnnotationData;
import omero.gateway.model.FileData;
import omero.gateway.model.FilesetData;
import omero.gateway.model.FolderData;
import omero.gateway.model.GroupData;
import omero.gateway.model.ImageData;
import omero.gateway.model.LineData;
import omero.gateway.model.LongAnnotationData;
import omero.gateway.model.MapAnnotationData;
import omero.gateway.model.MaskData;
import omero.gateway.model.PixelsData;
import omero.gateway.model.PlateAcquisitionData;
import omero.gateway.model.PlateData;
import omero.gateway.model.PointData;
import omero.gateway.model.PolygonData;
import omero.gateway.model.PolylineData;
import omero.gateway.model.ProjectData;
import omero.gateway.model.ROIData;
import omero.gateway.model.RatingAnnotationData;
import omero.gateway.model.RectangleData;
import omero.gateway.model.ScreenData;
import omero.gateway.model.TagAnnotationData;
import omero.gateway.model.TermAnnotationData;
import omero.gateway.model.TextData;
import omero.gateway.model.TextualAnnotationData;
import omero.gateway.model.TimeAnnotationData;
import omero.gateway.model.WellData;
import omero.gateway.model.WellSampleData;
import omero.gateway.model.XMLAnnotationData;
import omero.model.Annotation;
import omero.model.BooleanAnnotation;
import omero.model.BooleanAnnotationI;
import omero.model.CommentAnnotation;
import omero.model.CommentAnnotationI;
import omero.model.Dataset;
import omero.model.DatasetI;
import omero.model.DoubleAnnotation;
import omero.model.Ellipse;
import omero.model.Experimenter;
import omero.model.ExperimenterGroup;
import omero.model.FileAnnotation;
import omero.model.FileAnnotationI;
import omero.model.Fileset;
import omero.model.Folder;
import omero.model.IObject;
import omero.model.Image;
import omero.model.ImageI;
import omero.model.Label;
import omero.model.Line;
import omero.model.LongAnnotation;
import omero.model.MapAnnotation;
import omero.model.MapAnnotationI;
import omero.model.Mask;
import omero.model.OriginalFile;
import omero.model.Pixels;
import omero.model.Plate;
import omero.model.PlateAcquisition;
import omero.model.PlateAcquisitionI;
import omero.model.PlateI;
import omero.model.Point;
import omero.model.Polygon;
import omero.model.Polyline;
import omero.model.Project;
import omero.model.ProjectI;
import omero.model.Rectangle;
import omero.model.Roi;
import omero.model.Screen;
import omero.model.ScreenI;
import omero.model.TagAnnotation;
import omero.model.TagAnnotationI;
import omero.model.TermAnnotation;
import omero.model.TermAnnotationI;
import omero.model.TimestampAnnotation;
import omero.model.TimestampAnnotationI;
import omero.model.Well;
import omero.model.WellI;
import omero.model.WellSample;
import omero.model.XmlAnnotation;

public class PojoMapper {
    private static Object convert(Object value) {
        if (value instanceof IObject) {
            return PojoMapper.asDataObject((IObject)value);
        }
        if (value instanceof Collection) {
            return PojoMapper.convertToDataObjects((Collection)value);
        }
        if (value instanceof Map) {
            return PojoMapper.asDataObjects((Map)value);
        }
        return null;
    }

    public static DataObject asDataObject(IObject object) {
        if (object == null) {
            throw new IllegalArgumentException("IObject cannot be null.");
        }
        if (object instanceof Project) {
            return new ProjectData((Project)object);
        }
        if (object instanceof Dataset) {
            return new DatasetData((Dataset)object);
        }
        if (object instanceof Folder) {
            return new FolderData((Folder)object);
        }
        if (object instanceof Image) {
            return new ImageData((Image)object);
        }
        if (object instanceof TermAnnotation) {
            return new TermAnnotationData((TermAnnotation)object);
        }
        if (object instanceof TagAnnotation) {
            return new TagAnnotationData((TagAnnotation)object);
        }
        if (object instanceof CommentAnnotation) {
            return new TextualAnnotationData((CommentAnnotation)object);
        }
        if (object instanceof LongAnnotation) {
            LongAnnotation ann = (LongAnnotation)object;
            RString ns = ann.getNs();
            if (ns != null) {
                if ("openmicroscopy.org/omero/insight/rating".equals(ns.getValue())) {
                    return new RatingAnnotationData(ann);
                }
                return new LongAnnotationData(ann);
            }
            return new LongAnnotationData(ann);
        }
        if (object instanceof DoubleAnnotation) {
            return new DoubleAnnotationData((DoubleAnnotation)object);
        }
        if (object instanceof FileAnnotation) {
            return new FileAnnotationData((FileAnnotation)object);
        }
        if (object instanceof BooleanAnnotation) {
            return new BooleanAnnotationData((BooleanAnnotation)object);
        }
        if (object instanceof TimestampAnnotation) {
            return new TimeAnnotationData((TimestampAnnotation)object);
        }
        if (object instanceof XmlAnnotation) {
            return new XMLAnnotationData((XmlAnnotation)object);
        }
        if (object instanceof Pixels) {
            return new PixelsData((Pixels)object);
        }
        if (object instanceof Experimenter) {
            return new ExperimenterData((Experimenter)object);
        }
        if (object instanceof ExperimenterGroup) {
            return new GroupData((ExperimenterGroup)object);
        }
        if (object instanceof Screen) {
            return new ScreenData((Screen)object);
        }
        if (object instanceof Plate) {
            return new PlateData((Plate)object);
        }
        if (object instanceof PlateAcquisition) {
            return new PlateAcquisitionData((PlateAcquisition)object);
        }
        if (object instanceof Well) {
            return new WellData((Well)object);
        }
        if (object instanceof WellSample) {
            return new WellSampleData((WellSample)object);
        }
        if (object instanceof Roi) {
            return new ROIData((Roi)object);
        }
        if (object instanceof Fileset) {
            return new FilesetData((Fileset)object);
        }
        if (object instanceof MapAnnotation) {
            return new MapAnnotationData((MapAnnotation)object);
        }
        return null;
    }

    public static <T extends DataObject> Collection<T> convertToDataObjects(Collection objects) {
        if (objects == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<DataObject> result = new ArrayList<DataObject>(objects.size());
        Iterator i = objects.iterator();
        while (i.hasNext()) {
            DataObject data = PojoMapper.asDataObject((IObject)i.next());
            if (data == null) continue;
            result.add(data);
        }
        return result;
    }

    public static <T extends DataObject> Collection<T> asCastedDataObjects(List objects) {
        if (objects == null) {
            return new HashSet();
        }
        ArrayList<DataObject> set = new ArrayList<DataObject>(objects.size());
        Iterator i = objects.iterator();
        while (i.hasNext()) {
            DataObject data = PojoMapper.asDataObject((IObject)i.next());
            if (data == null) continue;
            set.add(data);
        }
        return set;
    }

    public static <K, V extends DataObject> Map<K, V> asDataObjectMap(Class<K> keyKlass, Class<V> valueKlass, String method, List objects) throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        TreeMap<Object, DataObject> map = new TreeMap<Object, DataObject>();
        for (Object obj : objects) {
            DataObject value = PojoMapper.asDataObject((IObject)obj);
            Method meth = value.getClass().getMethod(method, new Class[0]);
            Object keyValue = meth.invoke((Object)value, (Object[])null);
            map.put(keyValue, value);
        }
        return map;
    }

    public static Map asDataObjects(Map objects) {
        if (objects == null) {
            throw new IllegalArgumentException("The map cannot be null.");
        }
        HashMap map = new HashMap(objects.size());
        Set set = objects.entrySet();
        Iterator i = set.iterator();
        Object convertedKey = null;
        Object convertedValue = null;
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            Object key = entry.getKey();
            Object value = entry.getValue();
            convertedKey = PojoMapper.convert(key);
            convertedValue = PojoMapper.convert(value);
            map.put(convertedKey == null ? key : convertedKey, convertedValue == null ? value : convertedValue);
        }
        return map;
    }

    public static Class<? extends DataObject> getPojoType(Class<? extends IObject> modelType) {
        if (OriginalFile.class.equals(modelType)) {
            return FileData.class;
        }
        if (Project.class.equals(modelType)) {
            return ProjectData.class;
        }
        if (Dataset.class.equals(modelType)) {
            return DatasetData.class;
        }
        if (Image.class.equals(modelType)) {
            return ImageData.class;
        }
        if (BooleanAnnotation.class.equals(modelType)) {
            return BooleanAnnotationData.class;
        }
        if (LongAnnotation.class.equals(modelType)) {
            return LongAnnotationData.class;
        }
        if (TagAnnotation.class.equals(modelType)) {
            return TagAnnotationData.class;
        }
        if (CommentAnnotation.class.equals(modelType)) {
            return TextualAnnotationData.class;
        }
        if (FileAnnotation.class.equals(modelType)) {
            return FileAnnotationData.class;
        }
        if (TermAnnotation.class.equals(modelType)) {
            return TermAnnotationData.class;
        }
        if (Screen.class.equals(modelType)) {
            return ScreenData.class;
        }
        if (Plate.class.equals(modelType)) {
            return PlateData.class;
        }
        if (Well.class.equals(modelType)) {
            return WellData.class;
        }
        if (WellSample.class.equals(modelType)) {
            return WellSampleData.class;
        }
        if (PlateAcquisition.class.equals(modelType)) {
            return PlateAcquisitionData.class;
        }
        if (ExperimenterGroup.class.equals(modelType)) {
            return GroupData.class;
        }
        if (Experimenter.class.equals(modelType)) {
            return ExperimenterData.class;
        }
        if (DoubleAnnotation.class.equals(modelType)) {
            return DoubleAnnotationData.class;
        }
        if (XmlAnnotation.class.equals(modelType)) {
            return XMLAnnotationData.class;
        }
        if (Fileset.class.equals(modelType)) {
            return FilesetData.class;
        }
        if (MapAnnotation.class.equals(modelType)) {
            return MapAnnotationData.class;
        }
        throw new IllegalArgumentException(modelType.getClass().getSimpleName() + " not supported");
    }

    public static Class<? extends IObject> getModelType(String pojoType) {
        try {
            if (FileData.class.getSimpleName().equals(pojoType)) {
                pojoType = FileData.class.getName();
            } else if (ProjectData.class.getSimpleName().equals(pojoType)) {
                pojoType = ProjectData.class.getName();
            } else if (DatasetData.class.getSimpleName().equals(pojoType)) {
                pojoType = DatasetData.class.getName();
            } else if (FolderData.class.getSimpleName().equals(pojoType)) {
                pojoType = FolderData.class.getName();
            } else if (ImageData.class.getSimpleName().equals(pojoType)) {
                pojoType = ImageData.class.getName();
            } else if (BooleanAnnotationData.class.getSimpleName().equals(pojoType)) {
                pojoType = BooleanAnnotationData.class.getName();
            } else if (RatingAnnotationData.class.getSimpleName().equals(pojoType) || LongAnnotationData.class.getSimpleName().equals(pojoType)) {
                pojoType = LongAnnotationData.class.getName();
            } else if (TagAnnotationData.class.getSimpleName().equals(pojoType)) {
                pojoType = TagAnnotationData.class.getName();
            } else if (TextualAnnotationData.class.getSimpleName().equals(pojoType)) {
                pojoType = TextualAnnotationData.class.getName();
            } else if (FileAnnotationData.class.getSimpleName().equals(pojoType)) {
                pojoType = FileAnnotationData.class.getName();
            } else if (TermAnnotationData.class.getSimpleName().equals(pojoType)) {
                pojoType = TermAnnotationData.class.getName();
            } else if (ScreenData.class.getSimpleName().equals(pojoType)) {
                pojoType = ScreenData.class.getName();
            } else if (PlateData.class.getSimpleName().equals(pojoType)) {
                pojoType = PlateData.class.getName();
            } else if (WellData.class.getSimpleName().equals(pojoType)) {
                pojoType = WellData.class.getName();
            } else if (WellSampleData.class.getSimpleName().equals(pojoType)) {
                pojoType = WellSampleData.class.getName();
            } else if (PlateAcquisitionData.class.getSimpleName().equals(pojoType)) {
                pojoType = PlateAcquisitionData.class.getName();
            } else if (FileData.class.getSimpleName().equals(pojoType)) {
                pojoType = FileData.class.getName();
            } else if (GroupData.class.getSimpleName().equals(pojoType)) {
                pojoType = GroupData.class.getName();
            } else if (ExperimenterData.class.getSimpleName().equals(pojoType)) {
                pojoType = ExperimenterData.class.getName();
            } else if (DoubleAnnotationData.class.getSimpleName().equals(pojoType)) {
                pojoType = DoubleAnnotationData.class.getName();
            } else if (XMLAnnotationData.class.getSimpleName().equals(pojoType)) {
                pojoType = XMLAnnotationData.class.getName();
            } else if (FilesetData.class.getSimpleName().equals(pojoType)) {
                pojoType = FilesetData.class.getName();
            } else if (MapAnnotationData.class.getSimpleName().equals(pojoType)) {
                pojoType = MapAnnotationData.class.getName();
            } else if (ROIData.class.getSimpleName().equals(pojoType)) {
                pojoType = ROIData.class.getName();
            } else if (EllipseData.class.getSimpleName().equals(pojoType)) {
                pojoType = EllipseData.class.getName();
            } else if (LineData.class.getSimpleName().equals(pojoType)) {
                pojoType = LineData.class.getName();
            } else if (MaskData.class.getSimpleName().equals(pojoType)) {
                pojoType = MaskData.class.getName();
            } else if (PointData.class.getSimpleName().equals(pojoType)) {
                pojoType = PointData.class.getName();
            } else if (PolygonData.class.getSimpleName().equals(pojoType)) {
                pojoType = PolygonData.class.getName();
            } else if (PolylineData.class.getSimpleName().equals(pojoType)) {
                pojoType = PolylineData.class.getName();
            } else if (RectangleData.class.getSimpleName().equals(pojoType)) {
                pojoType = RectangleData.class.getName();
            } else if (TextData.class.getSimpleName().equals(pojoType)) {
                pojoType = TextData.class.getName();
            }
            Class<?> pojoClass = Class.forName(pojoType);
            return PojoMapper.getModelType(pojoClass);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(pojoType + " not found");
        }
    }

    public static Class<? extends IObject> getModelType(Class<? extends DataObject> pojoType) {
        if (!DataObject.class.isAssignableFrom(pojoType)) {
            throw new IllegalArgumentException(pojoType.getSimpleName() + " is not a DataObject");
        }
        if (FileData.class.equals(pojoType)) {
            return OriginalFile.class;
        }
        if (ProjectData.class.equals(pojoType)) {
            return Project.class;
        }
        if (DatasetData.class.equals(pojoType)) {
            return Dataset.class;
        }
        if (FolderData.class.equals(pojoType)) {
            return Folder.class;
        }
        if (ImageData.class.equals(pojoType)) {
            return Image.class;
        }
        if (BooleanAnnotationData.class.equals(pojoType)) {
            return BooleanAnnotation.class;
        }
        if (RatingAnnotationData.class.equals(pojoType) || LongAnnotationData.class.equals(pojoType)) {
            return LongAnnotation.class;
        }
        if (TagAnnotationData.class.equals(pojoType)) {
            return TagAnnotation.class;
        }
        if (TextualAnnotationData.class.equals(pojoType)) {
            return CommentAnnotation.class;
        }
        if (FileAnnotationData.class.equals(pojoType)) {
            return FileAnnotation.class;
        }
        if (TermAnnotationData.class.equals(pojoType)) {
            return TermAnnotation.class;
        }
        if (ScreenData.class.equals(pojoType)) {
            return Screen.class;
        }
        if (PlateData.class.equals(pojoType)) {
            return Plate.class;
        }
        if (WellData.class.equals(pojoType)) {
            return Well.class;
        }
        if (WellSampleData.class.equals(pojoType)) {
            return WellSample.class;
        }
        if (PlateAcquisitionData.class.equals(pojoType)) {
            return PlateAcquisition.class;
        }
        if (FileData.class.equals(pojoType)) {
            return OriginalFile.class;
        }
        if (GroupData.class.equals(pojoType)) {
            return ExperimenterGroup.class;
        }
        if (ExperimenterData.class.equals(pojoType)) {
            return Experimenter.class;
        }
        if (DoubleAnnotationData.class.equals(pojoType)) {
            return DoubleAnnotation.class;
        }
        if (XMLAnnotationData.class.equals(pojoType)) {
            return XmlAnnotation.class;
        }
        if (FilesetData.class.equals(pojoType)) {
            return Fileset.class;
        }
        if (MapAnnotationData.class.equals(pojoType)) {
            return MapAnnotation.class;
        }
        if (ROIData.class.equals(pojoType)) {
            return Roi.class;
        }
        if (EllipseData.class.equals(pojoType)) {
            return Ellipse.class;
        }
        if (LineData.class.equals(pojoType)) {
            return Line.class;
        }
        if (MaskData.class.equals(pojoType)) {
            return Mask.class;
        }
        if (PointData.class.equals(pojoType)) {
            return Point.class;
        }
        if (PolygonData.class.equals(pojoType)) {
            return Polygon.class;
        }
        if (PolylineData.class.equals(pojoType)) {
            return Polyline.class;
        }
        if (RectangleData.class.equals(pojoType)) {
            return Rectangle.class;
        }
        if (TextData.class.equals(pojoType)) {
            return Label.class;
        }
        throw new IllegalArgumentException(pojoType.getClass().getSimpleName() + " not supported");
    }

    public static String getGraphType(Class<? extends DataObject> dataType) {
        if (dataType.equals(DatasetData.class)) {
            return Dataset.class.getSimpleName();
        }
        if (dataType.equals(ProjectData.class)) {
            return Project.class.getSimpleName();
        }
        if (dataType.equals(ScreenData.class)) {
            return Screen.class.getSimpleName();
        }
        if (dataType.equals(WellData.class)) {
            return Well.class.getSimpleName();
        }
        if (dataType.equals(PlateData.class)) {
            return Plate.class.getSimpleName();
        }
        if (dataType.equals(PlateAcquisitionData.class)) {
            return PlateAcquisition.class.getSimpleName();
        }
        if (dataType.equals(FolderData.class)) {
            return Folder.class.getSimpleName();
        }
        if (dataType.equals(AnnotationData.class)) {
            return Annotation.class.getSimpleName();
        }
        if (dataType.equals(TagAnnotationData.class)) {
            return TagAnnotation.class.getSimpleName();
        }
        if (dataType.equals(BooleanAnnotationData.class)) {
            return BooleanAnnotation.class.getSimpleName();
        }
        if (dataType.equals(TermAnnotationData.class)) {
            return TermAnnotation.class.getSimpleName();
        }
        if (dataType.equals(FileAnnotationData.class)) {
            return FileAnnotation.class.getSimpleName();
        }
        if (dataType.equals(TextualAnnotationData.class)) {
            return CommentAnnotation.class.getSimpleName();
        }
        if (dataType.equals(MapAnnotationData.class)) {
            return MapAnnotation.class.getSimpleName();
        }
        if (dataType.equals(TimeAnnotationData.class)) {
            return TimestampAnnotation.class.getSimpleName();
        }
        if (dataType.equals(XMLAnnotationData.class)) {
            return XmlAnnotation.class.getSimpleName();
        }
        if (dataType.equals(ImageData.class)) {
            return Image.class.getSimpleName();
        }
        if (dataType.equals(ROIData.class)) {
            return Roi.class.getSimpleName();
        }
        throw new IllegalArgumentException("type not supported");
    }

    public static String convertTypeForSearch(Class nodeType) {
        if (nodeType.equals(Image.class) || nodeType.equals(ImageData.class)) {
            return ImageI.class.getName();
        }
        if (nodeType.equals(TagAnnotation.class) || nodeType.equals(TagAnnotationData.class)) {
            return TagAnnotationI.class.getName();
        }
        if (nodeType.equals(BooleanAnnotation.class) || nodeType.equals(BooleanAnnotationData.class)) {
            return BooleanAnnotationI.class.getName();
        }
        if (nodeType.equals(TermAnnotation.class) || nodeType.equals(TermAnnotationData.class)) {
            return TermAnnotationI.class.getName();
        }
        if (nodeType.equals(FileAnnotation.class) || nodeType.equals(FileAnnotationData.class)) {
            return FileAnnotationI.class.getName();
        }
        if (nodeType.equals(CommentAnnotation.class) || nodeType.equals(TextualAnnotationData.class)) {
            return CommentAnnotationI.class.getName();
        }
        if (nodeType.equals(MapAnnotation.class) || nodeType.equals(MapAnnotationData.class)) {
            return MapAnnotationI.class.getName();
        }
        if (nodeType.equals(TimestampAnnotation.class) || nodeType.equals(TimeAnnotationData.class)) {
            return TimestampAnnotationI.class.getName();
        }
        if (nodeType.equals(Dataset.class) || nodeType.equals(DatasetData.class)) {
            return DatasetI.class.getName();
        }
        if (nodeType.equals(Project.class) || nodeType.equals(ProjectData.class)) {
            return ProjectI.class.getName();
        }
        if (nodeType.equals(Screen.class) || nodeType.equals(ScreenData.class)) {
            return ScreenI.class.getName();
        }
        if (nodeType.equals(Well.class) || nodeType.equals(WellData.class)) {
            return WellI.class.getName();
        }
        if (nodeType.equals(Plate.class) || nodeType.equals(PlateData.class)) {
            return PlateI.class.getName();
        }
        if (nodeType.equals(PlateAcquisition.class) || nodeType.equals(PlateAcquisitionData.class)) {
            return PlateAcquisitionI.class.getName();
        }
        throw new IllegalArgumentException("type not supported");
    }

    public static String getHQLEntityName(Class<? extends IObject> clazz) {
        String name = clazz.getSimpleName();
        if (name.endsWith("I")) {
            return name.substring(0, name.length() - 1);
        }
        return name;
    }
}

