/*
 * Decompiled with CFR 0.152.
 */
package ome.services.search;

import java.util.ArrayList;
import ome.model.IObject;
import ome.parameters.Parameters;
import ome.parameters.QueryParameter;
import ome.services.search.SearchAction;
import ome.services.search.SearchValues;
import ome.system.ServiceFactory;
import org.hibernate.Session;
import org.springframework.transaction.annotation.Transactional;

public class HqlQuery
extends SearchAction {
    private static final long serialVersionUID = 1L;
    private final String query;
    private final Parameters params;

    public HqlQuery(SearchValues values, String query, Parameters p) {
        super(values);
        if (query == null || query.length() < 1) {
            throw new IllegalArgumentException("Query string must be non-empty");
        }
        this.query = query;
        this.params = p;
    }

    @Transactional(readOnly=true)
    public Object doWork(Session session, ServiceFactory sf) {
        Parameters _p = this.params;
        if (this.query.contains("IDLIST")) {
            QueryParameter qp;
            if (_p == null) {
                _p = new Parameters();
                qp = null;
            } else {
                qp = _p.get("IDLIST");
            }
            if (qp == null) {
                ArrayList<Long> ids = new ArrayList<Long>();
                if (this.chainedList == null || this.chainedList.size() == 0) {
                    ids.add(-1L);
                } else {
                    for (IObject obj : this.chainedList) {
                        if (obj == null) continue;
                        ids.add(obj.getId());
                    }
                }
                _p.addList("IDLIST", ids);
            }
        }
        return sf.getQueryService().findAllByQuery(this.query, _p);
    }
}

