/*
 * Decompiled with CFR 0.152.
 */
package ome.services.sessions.stats;

import ome.util.messages.InternalMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;

public abstract class LongCounter
implements ApplicationEventPublisherAware {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private ApplicationEventPublisher publisher;
    private int interval = 0;
    private long last = 0L;
    private final Object mutex = new Object();
    protected long count = 0L;

    public LongCounter(int interval) {
        this.interval = interval;
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.publisher = applicationEventPublisher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void increment(int incr) {
        Object object = this.mutex;
        synchronized (object) {
            this.count += (long)incr;
            if (this.count >= this.last + (long)this.interval) {
                this.last = this.count;
                InternalMessage message = this.message();
                try {
                    this.log.info("Publishing " + message);
                    this.publisher.publishEvent((ApplicationEvent)message);
                }
                catch (Throwable t) {
                    this.log.error(message + " produced an error: " + t);
                }
            }
        }
    }

    protected abstract InternalMessage message();
}

