/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer;

import java.util.Collection;
import omero.gateway.SecurityContext;
import omero.gateway.model.ExperimenterData;
import omero.gateway.model.GroupData;
import omero.gateway.model.PlateData;
import omero.gateway.model.ScreenData;
import org.openmicroscopy.shoola.agents.treeviewer.DataBrowserLoader;
import org.openmicroscopy.shoola.agents.treeviewer.browser.Browser;
import org.openmicroscopy.shoola.agents.util.browser.TreeImageSet;
import org.openmicroscopy.shoola.env.data.views.CallHandle;

public class ScreenPlateLoader
extends DataBrowserLoader {
    public static final int SCREEN = 0;
    public static final int PLATE = 1;
    private Class rootType;
    private TreeImageSet parent;
    private TreeImageSet expNode;
    private CallHandle handle;

    private Class getClassType(int type) {
        switch (type) {
            case 0: {
                return ScreenData.class;
            }
            case 1: {
                return PlateData.class;
            }
        }
        return null;
    }

    public ScreenPlateLoader(Browser viewer, SecurityContext ctx, TreeImageSet expNode, int type, TreeImageSet parent) {
        super(viewer, ctx);
        if (expNode == null) {
            throw new IllegalArgumentException("Node not valid.");
        }
        Object ho = expNode.getUserObject();
        if (!(ho instanceof ExperimenterData) && !(ho instanceof GroupData)) {
            throw new IllegalArgumentException("Node not valid.");
        }
        this.rootType = this.getClassType(type);
        this.expNode = expNode;
        this.parent = parent;
    }

    public ScreenPlateLoader(Browser viewer, SecurityContext ctx, TreeImageSet expNode, int type) {
        this(viewer, ctx, expNode, type, null);
    }

    @Override
    public void load() {
        long expID = -1L;
        if (this.expNode.getUserObject() instanceof ExperimenterData) {
            expID = ((ExperimenterData)this.expNode.getUserObject()).getId();
        }
        if (this.parent == null) {
            this.handle = this.dmView.loadContainerHierarchy(this.ctx, ScreenData.class, null, false, expID, this);
        }
    }

    @Override
    public void cancel() {
        this.handle.cancel();
    }

    @Override
    public void handleResult(Object result) {
        if (this.viewer.getState() == 16) {
            return;
        }
        if (this.parent == null) {
            this.viewer.setExperimenterData(this.expNode, (Collection)result);
        }
    }
}

