/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui.colourpicker;

import info.clearthought.layout.TableLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openmicroscopy.shoola.util.ui.colour.HSV;
import org.openmicroscopy.shoola.util.ui.colourpicker.ColourPicker;
import org.openmicroscopy.shoola.util.ui.colourpicker.ColourSlider;
import org.openmicroscopy.shoola.util.ui.colourpicker.HSVWheel;
import org.openmicroscopy.shoola.util.ui.colourpicker.RGBControl;

class HSVColourWheelUI
extends JPanel
implements ChangeListener {
    private static final Dimension WHEEL_SIZE = new Dimension(175, 175);
    private HSVWheel wheel;
    private ColourSlider HSVSlider;
    private ColourSlider alphaSlider;
    private JTextField alphaTextbox;
    private ChangeListener HSVListener;
    private ChangeListener alphaListener;
    private ActionListener alphaTextboxListener;
    private boolean active;
    private RGBControl control;

    private void createUI() {
        this.createWheel();
        this.createHSVSlider();
        this.createAlphaSlider();
        this.createAlphaTextbox();
        int width = this.HSVSlider.getPreferredSize().width;
        double[][] tl = new double[][]{{-2.0, 5.0, width}, {-1.0, -2.0}};
        this.setLayout((LayoutManager)new TableLayout((double[][])tl));
        JPanel empty = new JPanel();
        empty.setOpaque(true);
        this.add((Component)this.wheel, "0, 0");
        this.add((Component)empty, "1, 0");
        this.add((Component)this.HSVSlider, "2, 0");
        this.add((Component)this.alphaSlider, "0, 1");
        empty = new JPanel();
        empty.setOpaque(true);
        this.add((Component)empty, "1, 1");
        JPanel p = new JPanel();
        p.add(this.alphaTextbox);
        this.add((Component)p, "2, 1, LEFT, TOP");
    }

    private void createWheel() {
        this.wheel = new HSVWheel(this.control);
        this.wheel.addListener(this);
        this.wheel.setPreferredSize(WHEEL_SIZE);
    }

    private void createHSVSlider() {
        HSV startcol = new HSV(this.control.getColour());
        HSV endcol = new HSV(this.control.getColour());
        startcol.setValue(0.0f);
        endcol.setValue(1.0f);
        this.HSVSlider = new ColourSlider(0, 255, startcol, endcol);
        this.HSVSlider.setColourSpace(1);
        this.HSVSlider.setChannel(2);
        this.HSVSlider.setOrientation(1);
        this.HSVSlider.setValue((int)(this.control.getValue() * 255.0f));
        this.HSVListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                ColourSlider src = (ColourSlider)changeEvent.getSource();
                HSVColourWheelUI.this.control.setHSVColour(HSVColourWheelUI.this.wheel.getHue(), HSVColourWheelUI.this.wheel.getSaturation(), (float)src.getValue() / 255.0f, (float)HSVColourWheelUI.this.alphaSlider.getValue() / 255.0f);
            }
        };
        this.HSVSlider.addChangeListener(this.HSVListener);
    }

    private void createAlphaSlider() {
        Color s1 = this.control.getColour();
        Color s = new Color(s1.getRed(), s1.getGreen(), s1.getBlue(), 0);
        Color e = new Color(s1.getRed(), s1.getGreen(), s1.getBlue(), 255);
        this.alphaSlider = new ColourSlider(0, 255, s, e);
        this.alphaSlider.setColourSpace(0);
        this.alphaSlider.setOrientation(0);
        this.alphaSlider.setValue((int)(this.control.getAlpha() * 255.0f));
        this.alphaListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                HSVColourWheelUI.this.control.setHSVColour(HSVColourWheelUI.this.wheel.getHue(), HSVColourWheelUI.this.wheel.getSaturation(), (float)HSVColourWheelUI.this.HSVSlider.getValue() / 255.0f, (float)HSVColourWheelUI.this.alphaSlider.getValue() / 255.0f);
            }
        };
        this.alphaSlider.addChangeListener(this.alphaListener);
    }

    private void createAlphaTextbox() {
        this.alphaTextbox = new JTextField("" + (int)(this.control.getAlpha() * 255.0f));
        this.alphaTextbox.setColumns(2);
        this.alphaTextboxListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JTextField src = (JTextField)actionEvent.getSource();
                try {
                    int value = Integer.parseInt(src.getText());
                    if (value >= 0 && value <= 255) {
                        HSVColourWheelUI.this.control.setHSVColour(HSVColourWheelUI.this.wheel.getHue(), HSVColourWheelUI.this.wheel.getSaturation(), (float)HSVColourWheelUI.this.HSVSlider.getValue() / 255.0f, (float)value / 255.0f);
                    } else {
                        ColourPicker.invalidColorValue();
                        HSVColourWheelUI.this.alphaTextbox.setText("" + (int)(HSVColourWheelUI.this.control.getAlpha() * 255.0f));
                    }
                }
                catch (NumberFormatException e) {
                    ColourPicker.invalidColorValue();
                    HSVColourWheelUI.this.alphaTextbox.setText("" + (int)(HSVColourWheelUI.this.control.getAlpha() * 255.0f));
                }
            }
        };
    }

    HSVColourWheelUI(RGBControl c) {
        if (c == null) {
            throw new NullPointerException("No control.");
        }
        this.control = c;
        this.createUI();
        this.active = false;
    }

    void refresh() {
        if (!this.active) {
            return;
        }
        this.removeListeners();
        this.alphaSlider.setValue((int)(this.control.getAlpha() * 255.0f));
        Color col = this.control.getColour();
        Color start = new Color(col.getRed(), col.getGreen(), col.getBlue(), 0);
        Color end = new Color(col.getRed(), col.getGreen(), col.getBlue(), 255);
        this.alphaSlider.setRGBStart(start);
        this.alphaSlider.setRGBEnd(end);
        this.alphaTextbox.setText("" + (int)(this.control.getAlpha() * 255.0f));
        this.wheel.findPuck();
        this.wheel.refresh();
        this.alphaTextbox.repaint();
        HSV startcol = new HSV(this.wheel.getHue(), this.wheel.getSaturation(), 1.0f, 1.0f);
        HSV endcol = new HSV(this.wheel.getHue(), this.wheel.getSaturation(), 0.0f, 1.0f);
        this.HSVSlider.setHSVStart(startcol);
        this.HSVSlider.setHSVEnd(endcol);
        this.HSVSlider.setValue((int)(this.control.getValue() * 255.0f));
        this.wheel.repaint();
        this.HSVSlider.repaint();
        this.alphaSlider.repaint();
        this.addListeners();
        this.repaint();
    }

    void findPuck() {
        this.wheel.findPuck();
    }

    void addListeners() {
        this.HSVSlider.addChangeListener(this.HSVListener);
        this.alphaSlider.addChangeListener(this.alphaListener);
        this.alphaTextbox.addActionListener(this.alphaTextboxListener);
    }

    void removeListeners() {
        this.HSVSlider.removeChangeListener(this.HSVListener);
        this.alphaSlider.removeChangeListener(this.alphaListener);
        this.alphaTextbox.removeActionListener(this.alphaTextboxListener);
    }

    void setActive(boolean act) {
        this.active = act;
    }

    @Override
    public void stateChanged(ChangeEvent arg0) {
        this.control.setHSVColour(this.wheel.getHue(), this.wheel.getSaturation(), (float)this.HSVSlider.getValue() / 255.0f, (float)this.alphaSlider.getValue() / 255.0f);
        this.refresh();
    }
}

