/*
 * Decompiled with CFR 0.152.
 */
package ome.services.util;

import com.google.common.base.Joiner;
import java.lang.management.ManagementFactory;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Locale;
import java.util.TimeZone;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JvmSettingsCheck {
    public static final Logger log = LoggerFactory.getLogger(JvmSettingsCheck.class);
    public static final long TOTAL_PHYSICAL_MEMORY = JvmSettingsCheck._get("TotalPhysicalMemorySize");
    public static final long INITIAL_FREE_PHYSICAL_MEMORY = JvmSettingsCheck._get("FreePhysicalMemorySize");

    public JvmSettingsCheck() {
        String fmt = "%s = %6s";
        Runtime rt = Runtime.getRuntime();
        int mb = 0x100000;
        StringBuilder version = new StringBuilder();
        for (String key : new String[]{"java.version", "os.name", "os.arch", "os.version"}) {
            if (version.length() != 0) {
                version.append("; ");
            }
            version.append(System.getProperty(key));
        }
        Locale locale = Locale.getDefault();
        log.info("Language,Country,Charset,Timezone: " + Joiner.on((char)',').join(Arrays.asList(locale.getLanguage(), locale.getCountry(), Charset.defaultCharset(), TimeZone.getDefault().getID())));
        log.info("Java version: " + version);
        log.info(String.format("%s = %6s", "Max Memory (MB):  ", rt.maxMemory() / 0x100000L));
        log.info(String.format("%s = %6s", "OS Memory (MB):   ", JvmSettingsCheck.getPhysicalMemory() / 0x100000L));
        log.info(String.format("%s = %6s", "Processors:       ", rt.availableProcessors()));
    }

    public static long getPhysicalMemory() {
        return TOTAL_PHYSICAL_MEMORY;
    }

    private static long _get(String name) {
        try {
            MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
            Object attribute = mBeanServer.getAttribute(new ObjectName("java.lang", "type", "OperatingSystem"), name);
            return Long.valueOf(attribute.toString());
        }
        catch (Exception e) {
            log.debug("Failed to get: " + name, (Throwable)e);
            return -1L;
        }
    }

    public static void main(String[] args) {
        if (args.length >= 1 && "--psutil".equals(args[0])) {
            System.out.println("Free:" + INITIAL_FREE_PHYSICAL_MEMORY);
            System.out.println("Total:" + TOTAL_PHYSICAL_MEMORY);
            return;
        }
        new JvmSettingsCheck();
    }
}

