/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.metadata.editor;

import java.awt.Container;
import java.awt.Font;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import omero.gateway.model.AnnotationData;
import org.jdesktop.swingx.JXTaskPane;
import org.openmicroscopy.shoola.agents.metadata.MetadataViewerAgent;
import org.openmicroscopy.shoola.agents.metadata.editor.AnnotationTaskPaneUI;
import org.openmicroscopy.shoola.agents.metadata.editor.AttachmentsTaskPaneUI;
import org.openmicroscopy.shoola.agents.metadata.editor.CommentsTaskPaneUI;
import org.openmicroscopy.shoola.agents.metadata.editor.DummyTaskPaneUI;
import org.openmicroscopy.shoola.agents.metadata.editor.EditorControl;
import org.openmicroscopy.shoola.agents.metadata.editor.EditorModel;
import org.openmicroscopy.shoola.agents.metadata.editor.EditorUI;
import org.openmicroscopy.shoola.agents.metadata.editor.MapTaskPaneUI;
import org.openmicroscopy.shoola.agents.metadata.editor.OtherTaskPaneUI;
import org.openmicroscopy.shoola.agents.metadata.editor.RatingTaskPaneUI;
import org.openmicroscopy.shoola.agents.metadata.editor.TagsTaskPaneUI;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class AnnotationTaskPane
extends JXTaskPane {
    private EditorUI view;
    private EditorModel model;
    private EditorControl controller;
    private AnnotationTaskPaneUI ui;
    private AnnotationType type;

    AnnotationTaskPane(AnnotationType type, EditorUI view, EditorModel model, EditorControl controller) {
        this.setTitle(type.name);
        this.type = type;
        this.view = view;
        this.model = model;
        this.controller = controller;
        this.setAnimated(false);
        this.setCollapsed(true);
        Container c = this.getContentPane();
        c.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.setBackground(UIUtilities.BACKGROUND_COLOR);
        Font font = this.getFont();
        this.setFont(font.deriveFont(font.getSize2D() - 2.0f));
        if (c instanceof JComponent) {
            ((JComponent)c).setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        }
        this.buildUI();
        this.refreshUI();
    }

    void setAnnotationCount(int n) {
        this.setTitle(this.type.name + " (" + n + ")");
    }

    boolean hasDataToSave() {
        return !this.ui.getAnnotationsToSave().isEmpty() || !this.ui.getAnnotationsToRemove().isEmpty();
    }

    List<AnnotationData> getAnnotationsToSave() {
        return this.ui.getAnnotationsToSave();
    }

    List<Object> getAnnotationsToRemove() {
        return this.ui.getAnnotationsToRemove();
    }

    void clearDisplay() {
        this.ui.clearDisplay();
    }

    void refreshUI() {
        this.ui.refreshUI();
        this.setAnnotationCount(this.ui.getUnfilteredAnnotationCount());
    }

    void filter(AnnotationTaskPaneUI.Filter filter) {
        this.ui.filter(filter);
    }

    void onRelatedNodesSet() {
        this.ui.onRelatedNodesSet();
    }

    AnnotationTaskPaneUI getTaskPaneUI() {
        return this.ui;
    }

    private void buildUI() {
        switch (this.type) {
            case TAGS: {
                this.ui = new TagsTaskPaneUI(this.model, this.view, this.controller);
                break;
            }
            case MAP: {
                this.ui = new MapTaskPaneUI(this.model, this.view, this.controller);
                break;
            }
            case ATTACHMENTS: {
                this.ui = new AttachmentsTaskPaneUI(this.model, this.view, this.controller);
                break;
            }
            case COMMENTS: {
                this.ui = new CommentsTaskPaneUI(this.model, this.view, this.controller);
                break;
            }
            case OTHER: {
                this.ui = new OtherTaskPaneUI(this.model, this.view, this.controller);
                break;
            }
            case RATING: {
                this.ui = new RatingTaskPaneUI(this.model, this.view, this.controller);
                break;
            }
            default: {
                this.ui = new DummyTaskPaneUI(this.model, this.view, this.controller);
                MetadataViewerAgent.getRegistry().getLogger().warn((Object)this, "UI for displaying " + this.type.toString() + " annotations not implemented yet!");
            }
        }
        this.add(this.ui);
    }

    public static enum AnnotationType {
        TAGS("Tags"),
        ROIS("ROIs"),
        MAP("Key-Value Pairs"),
        ATTACHMENTS("Attachments"),
        OTHER("Others"),
        RATING("Ratings"),
        COMMENTS("Comments");

        String name = "";

        private AnnotationType(String name) {
            this.name = name;
        }
    }
}

