/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.metadata.rnd;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import omero.gateway.model.ChannelData;
import org.apache.commons.collections4.CollectionUtils;
import org.openmicroscopy.shoola.agents.metadata.HistogramLoader;
import org.openmicroscopy.shoola.agents.metadata.rnd.ChannelSlider;
import org.openmicroscopy.shoola.agents.metadata.rnd.GraphicsPaneUI;
import org.openmicroscopy.shoola.agents.metadata.rnd.PreviewControlBar;
import org.openmicroscopy.shoola.agents.metadata.rnd.PreviewControlBar2;
import org.openmicroscopy.shoola.agents.metadata.rnd.PreviewToolBar;
import org.openmicroscopy.shoola.agents.metadata.rnd.RendererControl;
import org.openmicroscopy.shoola.agents.metadata.rnd.RendererModel;
import org.openmicroscopy.shoola.agents.util.ViewedByItem;
import org.openmicroscopy.shoola.env.rnd.RenderingControl;
import org.openmicroscopy.shoola.env.rnd.RndProxyDef;
import org.openmicroscopy.shoola.env.ui.ChannelDataListRenderer;
import org.openmicroscopy.shoola.util.ui.HistogramPane;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.WrapLayout;
import org.openmicroscopy.shoola.util.ui.slider.TextualTwoKnobsSlider;
import org.openmicroscopy.shoola.util.ui.slider.TwoKnobsSlider;

class GraphicsPane
extends JPanel
implements PropertyChangeListener {
    static final double RATIO = 0.2;
    static final String VIEWEDBY_TITLE = "User Settings:";
    private TwoKnobsSlider codomainSlider;
    private TextualTwoKnobsSlider domainSlider;
    private JLabel maxLabel;
    private JLabel minLabel;
    private GraphicsPaneUI uiDelegate;
    protected RendererModel model;
    protected RendererControl controller;
    private boolean paintVertical;
    private boolean paintHorizontal;
    private int horizontalLine = -1;
    private int verticalLine = -1;
    private JCheckBox greyScale;
    private List<ChannelSlider> sliders;
    private PreviewControlBar controlsBar;
    private PreviewControlBar2 controlsBar2;
    private JPanel viewedBy;
    private PreviewToolBar previewToolBar;
    private List<ViewedByItem> viewedByItems;
    private RndProxyDef selectedDef;
    private HistogramPane histogram;
    private JComboBox histogramChannel;
    private JPanel histogramPane;
    private JCheckBox showHistogram;

    private String formatValue(double value) {
        if (this.model.isIntegerPixelData()) {
            return "" + (int)value;
        }
        return UIUtilities.formatToDecimal(value);
    }

    private void initDomainSlider() {
        int highestBound;
        int max;
        double range;
        int s = (int)this.model.getWindowStart();
        int e = (int)this.model.getWindowEnd();
        int absMin = (int)this.model.getLowestValue();
        int absMax = (int)this.model.getHighestValue();
        int min = (int)this.model.getGlobalMin();
        int lowestBound = (int)((double)min - (range = (double)((max = (int)this.model.getGlobalMax()) - min) * 0.2));
        if (lowestBound < absMin) {
            lowestBound = absMin;
        }
        if ((highestBound = (int)((double)max + range)) > absMax) {
            highestBound = absMax;
        }
        this.domainSlider.setValues(max, min, highestBound, lowestBound, max, min, s, e);
        if (this.model.getMaxC() > 100) {
            this.domainSlider.setInterval(min, max);
        }
    }

    private JPanel buildHistogramPane() {
        Object[] items = new ChannelData[this.model.getChannelData().size()];
        items = this.model.getChannelData().toArray(items);
        final RenderingControl rnd = this.model.getRenderingControls().iterator().next();
        ChannelDataListRenderer cellRnd = new ChannelDataListRenderer(rnd);
        this.histogramChannel = new JComboBox(items){

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(120, super.getPreferredSize().height);
            }
        };
        this.histogramChannel.setRenderer(cellRnd);
        this.histogramChannel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChannelData sel = (ChannelData)GraphicsPane.this.histogramChannel.getSelectedItem();
                int channelIndex = sel.getIndex();
                int[] data = GraphicsPane.this.model.getHistogramData(channelIndex);
                if (data == null) {
                    HistogramLoader loader = new HistogramLoader(GraphicsPane.this.model.getViewer(), GraphicsPane.this.model.getSecurityContext(), GraphicsPane.this.model.getRefImage(), new int[]{channelIndex}, GraphicsPane.this.model.getDefaultZ(), GraphicsPane.this.model.getDefaultT());
                    loader.load();
                }
                GraphicsPane.this.histogram.setData(data);
                double r = GraphicsPane.this.model.getGlobalMax(channelIndex) - GraphicsPane.this.model.getGlobalMin(channelIndex);
                double start = (rnd.getChannelWindowStart(channelIndex) - GraphicsPane.this.model.getGlobalMin(channelIndex)) / r;
                double end = (rnd.getChannelWindowEnd(channelIndex) - GraphicsPane.this.model.getGlobalMin(channelIndex)) / r;
                GraphicsPane.this.histogram.setInputWindow(start, end);
            }
        });
        JPanel p = new JPanel(new BorderLayout());
        p.setBorder(BorderFactory.createLineBorder(Color.lightGray));
        p.setBackground(UIUtilities.BACKGROUND);
        JPanel n = new JPanel(new BorderLayout());
        n.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        n.setBackground(UIUtilities.BACKGROUND);
        n.add((Component)new JLabel("Histogram"), "West");
        n.add((Component)this.histogramChannel, "East");
        p.add((Component)n, "North");
        p.add((Component)this.histogram, "Center");
        p.setVisible(false);
        return p;
    }

    private void initComponents() {
        this.histogram = new HistogramPane();
        this.histogram.setData(null);
        this.viewedBy = new JPanel();
        Font font = this.viewedBy.getFont();
        this.viewedBy.setFont(font.deriveFont(font.getSize2D() - 2.0f));
        this.viewedBy.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.viewedBy.setLayout(new BorderLayout());
        this.controlsBar = new PreviewControlBar(this.controller, this.model);
        this.controlsBar2 = new PreviewControlBar2(this.controller);
        this.uiDelegate = new GraphicsPaneUI(this, this.model);
        this.codomainSlider = new TwoKnobsSlider(0.0, 255.0, this.model.getCodomainStart(), this.model.getCodomainEnd());
        this.codomainSlider.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.codomainSlider.setPaintLabels(false);
        this.codomainSlider.setPaintEndLabels(false);
        this.codomainSlider.setPaintTicks(false);
        this.codomainSlider.setColourGradients(Color.BLACK, Color.WHITE);
        this.codomainSlider.addPropertyChangeListener(this);
        this.domainSlider = new TextualTwoKnobsSlider();
        this.domainSlider.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.initDomainSlider();
        this.domainSlider.getSlider().setPaintLabels(false);
        this.domainSlider.getSlider().setPaintEndLabels(false);
        this.domainSlider.getSlider().setPaintTicks(false);
        this.domainSlider.addPropertyChangeListener(this);
        this.maxLabel = new JLabel(this.formatValue(this.model.getGlobalMax()));
        this.minLabel = new JLabel(this.formatValue(this.model.getGlobalMin()));
        this.maxLabel.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.minLabel.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.greyScale = new JCheckBox("Grayscale");
        this.greyScale.setSelected(this.model.isGreyScale());
        this.greyScale.setBackground(UIUtilities.BACKGROUND);
        this.greyScale.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                GraphicsPane.this.model.setGreyscale(GraphicsPane.this.greyScale.isSelected());
            }
        });
        this.sliders = new ArrayList<ChannelSlider>();
        if (this.model.getModuloT() != null || !this.model.isLifetimeImage()) {
            List<ChannelData> channels = this.model.getChannelData();
            Iterator<ChannelData> i = channels.iterator();
            while (i.hasNext()) {
                this.sliders.add(new ChannelSlider(this, this.model, this.controller, i.next()));
            }
        }
        this.previewToolBar = new PreviewToolBar(this.controller, this.model);
        this.showHistogram = new JCheckBox("Show Histogram");
        this.showHistogram.setBackground(UIUtilities.BACKGROUND);
        this.showHistogram.setSelected(false);
        if (this.model.isBigImage()) {
            this.showHistogram.setEnabled(false);
            this.showHistogram.setToolTipText("Not availabe for large images.");
        }
        this.showHistogram.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (GraphicsPane.this.showHistogram.isSelected()) {
                    int ch = GraphicsPane.this.model.getSelectedChannel();
                    double st = GraphicsPane.this.model.getWindowStart(ch);
                    double end = GraphicsPane.this.model.getWindowEnd(ch);
                    GraphicsPane.this.updateHistogram(st, end, ch);
                }
                GraphicsPane.this.histogramPane.setVisible(GraphicsPane.this.showHistogram.isSelected());
            }
        });
        this.histogramPane = this.buildHistogramPane();
    }

    private void buildGUI() {
        this.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 18;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        if (this.model.isGeneralIndex()) {
            this.add((Component)this.buildGeneralPane(), c);
        } else {
            c.weightx = 0.0;
            this.add((Component)this.buildPane(), c);
            c.weightx = 1.0;
            ++c.gridx;
            this.add((Component)this.buildGeneralPane(), c);
        }
    }

    private JPanel buildGeneralPane() {
        JPanel content = new JPanel();
        content.setBackground(UIUtilities.BACKGROUND_COLOR);
        content.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        content.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 2;
        c.insets = new Insets(1, 2, 1, 2);
        c.gridy = 0;
        c.gridx = 0;
        c.weightx = 1.0;
        c.weighty = 0.0;
        if (this.model.isGeneralIndex()) {
            content.add((Component)this.previewToolBar, c);
            ++c.gridy;
            content.add((Component)new JSeparator(), c);
            ++c.gridy;
        }
        content.add((Component)this.controlsBar, c);
        ++c.gridy;
        content.add((Component)new JSeparator(), c);
        ++c.gridy;
        JPanel checkboxPanel = new JPanel();
        checkboxPanel.setBackground(UIUtilities.BACKGROUND);
        checkboxPanel.setLayout(new BoxLayout(checkboxPanel, 0));
        checkboxPanel.add(this.greyScale);
        checkboxPanel.add(Box.createHorizontalGlue());
        checkboxPanel.add(this.showHistogram);
        content.add((Component)checkboxPanel, c);
        ++c.gridy;
        c.fill = 1;
        c.weighty = 0.1;
        content.add((Component)this.histogramPane, c);
        ++c.gridy;
        c.fill = 2;
        c.weighty = 0.0;
        Iterator<ChannelSlider> i = this.sliders.iterator();
        while (i.hasNext()) {
            content.add((Component)i.next(), c);
            ++c.gridy;
        }
        c.insets = new Insets(3, 1, 3, 1);
        content.add((Component)this.controlsBar2, c);
        ++c.gridy;
        c.insets = new Insets(0, 0, 0, 0);
        c.fill = 2;
        c.weightx = 1.0;
        c.weighty = 0.0;
        content.add((Component)new JSeparator(), c);
        ++c.gridy;
        content.add((Component)new JLabel(VIEWEDBY_TITLE), c);
        ++c.gridy;
        c.fill = 1;
        c.weighty = 0.9;
        content.add((Component)this.viewedBy, c);
        return content;
    }

    private JPanel buildPane() {
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        p.setBackground(UIUtilities.BACKGROUND_COLOR);
        p.add(this.codomainSlider);
        return p;
    }

    GraphicsPane(RendererModel model, RendererControl controller) {
        if (model == null) {
            throw new NullPointerException("No model.");
        }
        if (controller == null) {
            throw new NullPointerException("No controller.");
        }
        this.model = model;
        this.controller = controller;
        this.initComponents();
        this.buildGUI();
    }

    void setSelectedPlane() {
        if (this.previewToolBar != null) {
            this.previewToolBar.setSelectedPlane();
        }
    }

    void setSelectedChannel() {
        Iterator<ChannelSlider> i = this.sliders.iterator();
        while (i.hasNext()) {
            i.next().setSelectedChannel();
        }
    }

    void setInputInterval() {
        for (ChannelSlider slider : this.sliders) {
            double s = this.model.getWindowStart(slider.getIndex());
            double e = this.model.getWindowEnd(slider.getIndex());
            slider.setInterval(s, e);
        }
    }

    int getHistogramChannelIndex() {
        return this.histogramChannel.getSelectedIndex();
    }

    void updateHistogram(Double start, Double end, int channelIndex) {
        if (!this.showHistogram.isSelected()) {
            return;
        }
        int[] data = this.model.getHistogramData(channelIndex);
        if (data == null) {
            HistogramLoader loader = new HistogramLoader(this.model.getViewer(), this.model.getSecurityContext(), this.model.getRefImage(), new int[]{channelIndex}, this.model.getDefaultZ(), this.model.getDefaultT());
            loader.load();
        }
        this.histogram.setData(data);
        if (start == null) {
            start = this.model.getWindowStart();
        }
        if (end == null) {
            end = this.model.getWindowStart();
        }
        double r = this.model.getGlobalMax(channelIndex) - this.model.getGlobalMin(channelIndex) + 1.0;
        double s = (start - this.model.getGlobalMin(channelIndex)) / r;
        double e = (end - this.model.getGlobalMin(channelIndex)) / r;
        this.histogram.setInputWindow(s, e);
        if (this.histogramChannel.getSelectedIndex() != channelIndex) {
            for (int i = 0; i < this.histogramChannel.getItemCount(); ++i) {
                ChannelData ch = (ChannelData)this.histogramChannel.getItemAt(i);
                if (ch.getIndex() != channelIndex) continue;
                this.histogramChannel.setSelectedIndex(i);
                break;
            }
        }
    }

    void setInputRange(boolean booleanValue) {
        if (CollectionUtils.isEmpty(this.sliders)) {
            return;
        }
        Iterator<ChannelSlider> i = this.sliders.iterator();
        while (i.hasNext()) {
            i.next().setInputRange(booleanValue);
        }
    }

    void setCodomainInterval() {
        this.codomainSlider.setInterval(this.model.getCodomainStart(), this.model.getCodomainEnd());
        this.onCurveChange();
    }

    void onCurveChange() {
        this.uiDelegate.invalidate();
        this.uiDelegate.repaint();
    }

    boolean isPaintLine() {
        return this.paintVertical() || this.paintHorizontal();
    }

    boolean isLiveUpdate() {
        return this.previewToolBar != null ? this.previewToolBar.isLiveUpdate() : false;
    }

    boolean isShowHistogram() {
        return this.showHistogram != null ? this.showHistogram.isSelected() : false;
    }

    boolean paintVertical() {
        return this.paintVertical;
    }

    boolean paintHorizontal() {
        return this.paintHorizontal;
    }

    int getHorizontalLine() {
        return this.horizontalLine;
    }

    int getVerticalLine() {
        return this.verticalLine;
    }

    int getPartialMinimum() {
        return (int)this.domainSlider.getSlider().getPartialMinimum();
    }

    int getPartialMaximum() {
        return (int)this.domainSlider.getSlider().getPartialMaximum();
    }

    void onStateChange(boolean b) {
        if (this.codomainSlider != null) {
            this.codomainSlider.setEnabled(b);
        }
        if (this.domainSlider != null) {
            this.domainSlider.setEnabled(b);
        }
    }

    void setColorModelChanged() {
        if (CollectionUtils.isEmpty(this.sliders)) {
            return;
        }
        Iterator<ChannelSlider> i = this.sliders.iterator();
        while (i.hasNext()) {
            i.next().setColorModelChanged();
        }
    }

    void setChannelColor(int index) {
        if (CollectionUtils.isNotEmpty(this.sliders)) {
            for (ChannelSlider slider : this.sliders) {
                if (slider.getIndex() != index) continue;
                slider.setChannelColor();
                break;
            }
        }
        this.repaint();
    }

    void resetViewedBy(RndProxyDef activeRndDef) {
        this.displayViewedBy(this.viewedByItems, activeRndDef);
    }

    void displayViewedBy(List<ViewedByItem> results, RndProxyDef activeRndDef) {
        if (results == null) {
            this.viewedBy.removeAll();
            return;
        }
        this.viewedByItems = results;
        Collections.sort(this.viewedByItems, new ViewedByItemComparator());
        JPanel p = new JPanel();
        p.setLayout(new WrapLayout(0));
        p.setBackground(UIUtilities.BACKGROUND_COLOR);
        for (ViewedByItem item : this.viewedByItems) {
            item.addPropertyChangeListener(this);
            p.add(this.createViewedByPanel(item));
        }
        if (activeRndDef != null) {
            this.highlight(activeRndDef);
        }
        p.setSize(this.viewedBy.getSize());
        this.viewedBy.removeAll();
        this.viewedBy.add((Component)p, "Center");
        this.viewedBy.validate();
    }

    private JPanel createViewedByPanel(ViewedByItem item) {
        JPanel viewedByPanel = new JPanel();
        viewedByPanel.setBackground(UIUtilities.BACKGROUND_COLOR);
        viewedByPanel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        viewedByPanel.add(item);
        return viewedByPanel;
    }

    void highlight(RndProxyDef def) {
        this.selectedDef = def;
        for (ViewedByItem item : this.viewedByItems) {
            JPanel p = (JPanel)item.getParent();
            if (item.getRndDef().getDataID() == def.getDataID()) {
                p.setBorder(BorderFactory.createLineBorder(UIUtilities.STEELBLUE, 2));
                continue;
            }
            p.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        }
    }

    RndProxyDef getSelectedDef() {
        return this.selectedDef;
    }

    JComponent getCodomainSlider() {
        return this.codomainSlider;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        int s;
        String name = evt.getPropertyName();
        Object source = evt.getSource();
        if (!this.previewToolBar.isLiveUpdate()) {
            if ("knobReleased".equals(name)) {
                this.paintHorizontal = false;
                this.paintVertical = false;
                if (source.equals(this.domainSlider)) {
                    this.controller.setInputInterval(this.domainSlider.getStartValue(), this.domainSlider.getEndValue());
                    this.onCurveChange();
                } else if (source.equals(this.codomainSlider)) {
                    s = this.codomainSlider.getStartValueAsInt();
                    int e = this.codomainSlider.getEndValueAsInt();
                    this.controller.setCodomainInterval(s, e);
                    this.onCurveChange();
                }
            } else if ("leftMoved".equals(name)) {
                if (source.equals(this.domainSlider)) {
                    this.verticalLine = (int)this.domainSlider.getStartValue();
                    this.paintHorizontal = false;
                    this.paintVertical = true;
                    this.onCurveChange();
                } else if (source.equals(this.codomainSlider)) {
                    this.horizontalLine = this.codomainSlider.getEndValueAsInt();
                    this.paintHorizontal = true;
                    this.paintVertical = false;
                    this.onCurveChange();
                }
            } else if ("rightMoved".equals(name)) {
                if (source.equals(this.domainSlider)) {
                    this.verticalLine = (int)this.domainSlider.getEndValue();
                    this.horizontalLine = -1;
                    this.paintHorizontal = false;
                    this.paintVertical = true;
                    this.onCurveChange();
                } else if (source.equals(this.codomainSlider)) {
                    this.horizontalLine = this.codomainSlider.getStartValueAsInt();
                    this.verticalLine = -1;
                    this.paintHorizontal = true;
                    this.paintVertical = false;
                    this.onCurveChange();
                }
            }
        } else {
            this.paintHorizontal = false;
            this.paintVertical = false;
            if ("leftMoved".equals(name) || "rightMoved".equals(name)) {
                if (source.equals(this.domainSlider)) {
                    this.controller.setInputInterval(this.domainSlider.getStartValue(), this.domainSlider.getEndValue());
                    this.onCurveChange();
                } else if (source.equals(this.codomainSlider)) {
                    s = this.codomainSlider.getStartValueAsInt();
                    int e = this.codomainSlider.getEndValueAsInt();
                    this.controller.setCodomainInterval(s, e);
                    this.onCurveChange();
                }
            } else if ("knobReleased".equals(name)) {
                if (source.equals(this.domainSlider)) {
                    this.controller.setInputInterval(this.domainSlider.getStartValue(), this.domainSlider.getEndValue());
                } else if (source.equals(this.codomainSlider)) {
                    s = this.codomainSlider.getStartValueAsInt();
                    int e = this.codomainSlider.getEndValueAsInt();
                    this.controller.setCodomainInterval(s, e);
                    this.onCurveChange();
                }
            }
        }
        if ("viewedBy".equals(name)) {
            RndProxyDef def = (RndProxyDef)evt.getNewValue();
            this.highlight(def);
        }
    }

    void updateGreyScale(boolean b) {
        this.greyScale.setSelected(b);
    }

    public void onHistogramLoaded(int ch) {
        double s = this.model.getWindowStart(ch);
        double e = this.model.getWindowEnd(ch);
        this.updateHistogram(s, e, ch);
    }

    class ViewedByItemComparator
    implements Comparator<ViewedByItem> {
        ViewedByItemComparator() {
        }

        @Override
        public int compare(ViewedByItem o1, ViewedByItem o2) {
            String name1 = o1.getExperimenter().getLastName() != null ? o1.getExperimenter().getLastName() : "";
            String name2 = o2.getExperimenter().getLastName() != null ? o2.getExperimenter().getLastName() : "";
            return name1.compareToIgnoreCase(name2);
        }
    }
}

