/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.util;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import omero.gateway.model.ExperimenterData;
import omero.gateway.model.GroupData;
import org.openmicroscopy.shoola.agents.treeviewer.util.DataPane;
import org.openmicroscopy.shoola.agents.treeviewer.util.ExperimenterPane;
import org.openmicroscopy.shoola.agents.util.EditorUtil;
import org.openmicroscopy.shoola.agents.util.ui.PermissionsPane;
import org.openmicroscopy.shoola.env.data.login.UserCredentials;
import org.openmicroscopy.shoola.env.data.model.AdminObject;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

class GroupPane
extends DataPane {
    private ExperimenterPane expPane;
    private JTextField descriptionArea;
    private PermissionsPane permissions;

    private void initComponents(boolean admin, boolean addUsers) {
        this.permissions = new PermissionsPane(admin);
        this.permissions.setBorder(BorderFactory.createTitledBorder("Permissions"));
        this.descriptionArea = new JTextField();
        if (addUsers) {
            this.expPane = new ExperimenterPane(false, null, null);
            this.expPane.setBorder(BorderFactory.createTitledBorder("Owner"));
            this.expPane.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if ("enableSave".equals(evt.getPropertyName())) {
                        GroupPane.this.firePropertyChange("enableSave", evt.getOldValue(), evt.getNewValue());
                    }
                }
            });
        }
    }

    private JPanel buildContentPanel() {
        JPanel content = new JPanel();
        content.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        JComponent label = EditorUtil.getLabel("Name", true);
        c.gridwidth = -1;
        c.fill = 0;
        c.fill = 2;
        c.anchor = 17;
        c.insets = new Insets(0, 2, 2, 0);
        c.weightx = 0.0;
        c.gridx = 0;
        c.gridy = 0;
        content.add((Component)label, c);
        ++c.gridx;
        this.add(Box.createHorizontalStrut(5), c);
        ++c.gridx;
        c.gridwidth = 0;
        c.fill = 2;
        c.weightx = 1.0;
        content.add((Component)this.nameArea, c);
        ++c.gridy;
        label = UIUtilities.setTextFont("Description");
        c.gridwidth = -1;
        c.weightx = 1.0;
        c.fill = 0;
        c.weightx = 0.0;
        c.gridx = 0;
        content.add((Component)label, c);
        ++c.gridx;
        this.add(Box.createHorizontalStrut(5), c);
        ++c.gridx;
        c.gridwidth = 0;
        c.fill = 2;
        c.weightx = 1.0;
        content.add((Component)this.descriptionArea, c);
        c.gridwidth = -1;
        c.weightx = 1.0;
        return content;
    }

    private void buildGUI() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.anchor = 17;
        c.insets = new Insets(0, 2, 2, 0);
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = -1;
        c.weightx = 1.0;
        ++c.gridy;
        this.add((Component)this.buildContentPanel(), c);
        ++c.gridy;
        this.add((Component)this.permissions, c);
        if (this.expPane != null) {
            ++c.gridy;
            this.add((Component)this.expPane, c);
        }
    }

    GroupPane(boolean admin, boolean addUsers) {
        this.initComponents(admin, addUsers);
        this.buildGUI();
    }

    boolean hasRequiredFields() {
        int count = 0;
        if (this.isNameValid()) {
            ++count;
        }
        return count == 1;
    }

    AdminObject getObjectToSave() {
        GroupData data = new GroupData();
        data.setName(this.nameArea.getText().trim());
        data.setDescription(this.descriptionArea.getText().trim());
        Map<ExperimenterData, UserCredentials> m = new HashMap<ExperimenterData, UserCredentials>();
        if (this.expPane != null && this.expPane.hasLoginCredentials()) {
            m = this.expPane.getObjectToSave();
        }
        AdminObject object = new AdminObject(data, m, 0);
        object.setPermissions(this.permissions.getPermissions());
        return object;
    }
}

