/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env;

import java.io.File;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.FilenameUtils;
import org.openmicroscopy.shoola.env.AbnormalExitHandler;
import org.openmicroscopy.shoola.env.Agent;
import org.openmicroscopy.shoola.env.Environment;
import org.openmicroscopy.shoola.env.RootThreadGroup;
import org.openmicroscopy.shoola.env.config.AgentInfo;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.config.RegistryFactory;
import org.openmicroscopy.shoola.env.data.DataServicesFactory;
import org.openmicroscopy.shoola.env.data.events.ActivateAgents;
import org.openmicroscopy.shoola.env.data.events.ConnectedEvent;
import org.openmicroscopy.shoola.env.data.login.LoginService;
import org.openmicroscopy.shoola.env.data.login.UserCredentials;
import org.openmicroscopy.shoola.env.event.AgentEvent;
import org.openmicroscopy.shoola.env.event.AgentEventListener;
import org.openmicroscopy.shoola.env.init.Initializer;
import org.openmicroscopy.shoola.env.init.StartupException;
import org.openmicroscopy.shoola.util.CommonsLangUtils;

public final class Container {
    public static final String TITLE = "Open Microscopy Environment";
    public static final String CONFIG_DIR = "config";
    public static final String LIBS_DIR = "libs";
    public static final String CONFIG_FILE = "container.xml";
    public static final String DOC_DIR = "docs";
    private static Container singleton;
    private String configFile;
    private String homeDir;
    private String pluginDir;
    private Registry registry;
    private Set<Agent> agentsPool;

    public static void startup(String home, String configFile) {
        Container.startup(home, configFile, null);
    }

    private static void runStartupProcedure(String home, String configFile, List<String> cmdLineArgs) {
        AbnormalExitHandler.configure();
        Initializer initManager = null;
        try {
            singleton = new Container(home, configFile, null, cmdLineArgs);
            initManager = new Initializer(singleton);
            initManager.configure();
            initManager.doInit();
            initManager.notifyEnd();
        }
        catch (StartupException se) {
            if (initManager != null) {
                initManager.rollback();
            }
            AbnormalExitHandler.terminate(se);
        }
    }

    static Container getInstance() {
        return singleton;
    }

    public static void startup(final String home, final String configFile, final List<String> cmdLineArgs) {
        if (singleton != null) {
            return;
        }
        RootThreadGroup root = new RootThreadGroup();
        Runnable r = new Runnable(){

            @Override
            public void run() {
                Container.runStartupProcedure(home, configFile, cmdLineArgs);
            }
        };
        Thread t = new Thread(root, r, "Initializer");
        t.start();
    }

    private Container(String home, String configFile, String pluginDir) throws StartupException {
        this(home, configFile, pluginDir, null);
    }

    private Container(String home, String configFile, String pluginDir, List<String> cmdLineArgs) throws StartupException {
        if (CommonsLangUtils.isBlank(configFile) || !FilenameUtils.isExtension((String)configFile, (String)"xml")) {
            configFile = CONFIG_FILE;
        }
        this.configFile = configFile;
        if (CommonsLangUtils.isBlank(FilenameUtils.getPath((String)home))) {
            home = System.getProperty("user.dir");
        }
        File f = new File(home);
        f = f.getAbsoluteFile();
        this.homeDir = f.getAbsolutePath();
        this.pluginDir = pluginDir;
        if (!f.exists() || !f.isDirectory()) {
            throw new StartupException("Can't locate home dir: " + this.homeDir);
        }
        this.agentsPool = new HashSet<Agent>();
        this.registry = RegistryFactory.makeNew();
        if (cmdLineArgs != null && !cmdLineArgs.isEmpty()) {
            this.registry.addCmdLineArgs(cmdLineArgs);
        }
    }

    public String getPluginDir() {
        return this.pluginDir;
    }

    public String getHomeDir() {
        return this.homeDir;
    }

    public String getConfigFileRelative() {
        return this.getConfigFileRelative(this.configFile);
    }

    public String getConfigFileRelative(String file) {
        if (file == null) {
            return null;
        }
        if (file.contains(File.separator)) {
            return file;
        }
        return this.getFileRelative(CONFIG_DIR, file);
    }

    public String getFileRelative(String directory, String file) {
        return this.resolveFilePath(file, directory);
    }

    public String resolveFilePath(String fileName, String directory) {
        StringBuffer relPath = new StringBuffer(directory);
        relPath.append(File.separatorChar);
        relPath.append(fileName);
        File f = new File(this.homeDir, relPath.toString());
        return f.getAbsolutePath();
    }

    public Registry getRegistry() {
        return this.registry;
    }

    public boolean addAgent(Agent a) {
        if (a == null) {
            throw new NullPointerException();
        }
        return this.agentsPool.add(a);
    }

    private void activateAgents() {
        Integer v = (Integer)Container.singleton.registry.lookup("/application/entryPoint");
        int value = 0;
        Integer plugin = (Integer)Container.singleton.registry.lookup("Plugin");
        if (v != null) {
            switch (v) {
                case 0: 
                case 2: {
                    value = v;
                }
            }
        }
        List agents = (List)Container.singleton.registry.lookup("/agents");
        for (AgentInfo agentInfo : agents) {
            int n = agentInfo.getNumber();
            if (!agentInfo.isActive() || n != value) continue;
            Agent a = agentInfo.getAgent();
            a.activate(true);
        }
    }

    public void startService() {
        if (singleton == null) {
            return;
        }
        List agents = (List)Container.singleton.registry.lookup("/agents");
        Iterator i = agents.iterator();
        Environment env = new Environment(this);
        Container.singleton.registry.bind("/env", env);
        while (i.hasNext()) {
            AgentInfo agentInfo = (AgentInfo)i.next();
            if (!agentInfo.isActive()) continue;
            Agent a = agentInfo.getAgent();
            Registry r = agentInfo.getRegistry();
            r.bind("/env", env);
            a.setContext(r);
        }
        this.activateAgents();
    }

    public void exit() {
        Integer v = (Integer)this.getRegistry().lookup("Plugin");
        int value = -1;
        if (v != null) {
            value = v;
        }
        if (value <= 0) {
            System.exit(0);
        } else {
            this.getRegistry().getEventBus().post(new ConnectedEvent(false));
            try {
                DataServicesFactory.getInstance(singleton).shutdown(null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static Container startupInPluginMode(String home, String configFile, String pluginDir, int plugin) throws StartupException {
        return Container.startupInPluginMode(home, configFile, plugin, pluginDir, null);
    }

    public static Container startupInPluginMode(String home, String configFile, int plugin) throws StartupException {
        return Container.startupInPluginMode(home, configFile, plugin, null, null);
    }

    public static Container startupInPluginMode(String home, String configFile, int plugin, AgentEventListener listener) throws StartupException {
        return Container.startupInPluginMode(home, configFile, plugin, null, listener);
    }

    public static Container startupInPluginMode(String home, String configFile, int plugin, String pluginDir, AgentEventListener listener) throws StartupException {
        if (Container.getInstance() != null) {
            Container.singleton.registry.bind("Plugin", plugin);
            LoginService loginSvc = (LoginService)Container.singleton.registry.lookup("/services/Login");
            UserCredentials uc = null;
            if (Container.singleton.registry.lookup("/user/credentials") != null) {
                uc = (UserCredentials)Container.singleton.registry.lookup("/user/credentials");
            }
            if (uc != null) {
                int v = loginSvc.login(uc);
                boolean r = true;
                if (v == 1) {
                    singleton.activateAgents();
                } else {
                    Boolean b = (Boolean)Container.singleton.registry.lookup("/services/Login/splashscreen");
                    if (b != null && !b.booleanValue()) {
                        r = false;
                    }
                }
                if (r) {
                    return Container.getInstance();
                }
                singleton = null;
            }
        }
        Initializer initManager = null;
        try {
            singleton = new Container(home, configFile, pluginDir);
            Container.singleton.registry.bind("Plugin", plugin);
            initManager = new Initializer(singleton);
            initManager.configure();
            initManager.doInit();
            if (singleton == null) {
                throw new RuntimeException("Plugin shuts down during initialization.");
            }
            if (listener != null) {
                Container.singleton.registry.getEventBus().register(listener, ConnectedEvent.class);
            }
            initManager.notifyEnd();
        }
        catch (StartupException se) {
            if (initManager != null) {
                initManager.rollback();
            }
            singleton = null;
            if (se.getPlugin() != null) {
                throw se;
            }
            throw new RuntimeException("Failed to initialize the Container in plugin mode.", se);
        }
        return singleton;
    }

    public static Container startupInHeadlessMode(String home, String configFile, int plugin) throws StartupException {
        if (Container.getInstance() != null) {
            return Container.getInstance();
        }
        Initializer initManager = null;
        try {
            singleton = new Container(home, configFile, null);
            if (plugin >= 0) {
                Container.singleton.registry.bind("Plugin", plugin);
            }
            Container.singleton.registry.bind("Headless", true);
            initManager = new Initializer(singleton, true);
            initManager.configure();
            initManager.doInit();
            initManager.notifyEnd();
            Container.singleton.registry.getEventBus().register(new AgentEventListener(){

                @Override
                public void eventFired(AgentEvent e) {
                    singleton.activateAgents();
                }
            }, ActivateAgents.class);
        }
        catch (StartupException se) {
            if (initManager != null) {
                initManager.rollback();
            }
            singleton = null;
            if (se.getPlugin() != null) {
                throw se;
            }
            throw new RuntimeException("Failed to initialize the Container in headless mode.", se);
        }
        return singleton;
    }

    public static Container startupInHeadlessMode(String home, String configFile) throws StartupException {
        return Container.startupInHeadlessMode(home, configFile, -1);
    }

    public static Container startupInTestMode(String home) {
        if (Container.getInstance() != null) {
            return Container.getInstance();
        }
        Initializer initManager = null;
        try {
            singleton = new Container(home, CONFIG_FILE, null);
            initManager = new Initializer(singleton);
            initManager.configure();
            initManager.doInit();
            initManager.notifyEnd();
        }
        catch (StartupException se) {
            if (initManager != null) {
                initManager.rollback();
            }
            singleton = null;
            throw new RuntimeException("Failed to initialize the Container in test mode.", se);
        }
        return singleton;
    }
}

