/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.data;

import java.io.File;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import omero.api.StatefulServiceInterfacePrx;
import omero.cmd.Request;
import omero.cmd.graphs.ChildOption;
import omero.gateway.SecurityContext;
import omero.gateway.exception.DSAccessException;
import omero.gateway.exception.DSOutOfServiceException;
import omero.gateway.model.AnnotationData;
import omero.gateway.model.DataObject;
import omero.gateway.model.DatasetData;
import omero.gateway.model.ExperimenterData;
import omero.gateway.model.FileAnnotationData;
import omero.gateway.model.FolderData;
import omero.gateway.model.GroupData;
import omero.gateway.model.ImageData;
import omero.gateway.model.PermissionData;
import omero.gateway.model.PlateAcquisitionData;
import omero.gateway.model.PlateData;
import omero.gateway.model.ProjectData;
import omero.gateway.model.ScreenData;
import omero.gateway.model.SearchParameters;
import omero.gateway.model.SearchResult;
import omero.gateway.model.SearchResultCollection;
import omero.gateway.model.TagAnnotationData;
import omero.gateway.model.WellData;
import omero.gateway.model.WellSampleData;
import omero.gateway.util.PojoMapper;
import omero.gateway.util.Requests;
import omero.log.LogMessage;
import omero.model.Annotation;
import omero.model.AnnotationAnnotationLink;
import omero.model.Dataset;
import omero.model.DatasetAnnotationLink;
import omero.model.DatasetImageLink;
import omero.model.Event;
import omero.model.Experimenter;
import omero.model.ExperimenterI;
import omero.model.FileAnnotation;
import omero.model.IObject;
import omero.model.Image;
import omero.model.ImageAnnotationLink;
import omero.model.Plate;
import omero.model.PlateAnnotationLink;
import omero.model.Project;
import omero.model.ProjectAnnotationLink;
import omero.model.ProjectDatasetLink;
import omero.model.Screen;
import omero.model.ScreenAnnotationLink;
import omero.model.ScreenPlateLink;
import omero.model.TagAnnotation;
import omero.model.Well;
import omero.rtypes;
import omero.sys.Parameters;
import omero.sys.ParametersI;
import org.apache.commons.collections4.CollectionUtils;
import org.openmicroscopy.shoola.env.config.AgentInfo;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.data.FSFileSystemView;
import org.openmicroscopy.shoola.env.data.OMEROGateway;
import org.openmicroscopy.shoola.env.data.OmeroDataService;
import org.openmicroscopy.shoola.env.data.ProcessException;
import org.openmicroscopy.shoola.env.data.RequestCallback;
import org.openmicroscopy.shoola.env.data.login.UserCredentials;
import org.openmicroscopy.shoola.env.data.model.DeletableObject;
import org.openmicroscopy.shoola.env.data.util.ModelMapper;

class OmeroDataServiceImpl
implements OmeroDataService {
    private Registry context;
    private OMEROGateway gateway;

    private void cut(SecurityContext ctx, DataObject parent, Set children) throws DSOutOfServiceException, DSAccessException {
        IObject mParent = parent.asIObject();
        Iterator i = children.iterator();
        ArrayList<Long> ids = new ArrayList<Long>(children.size());
        while (i.hasNext()) {
            ids.add(((DataObject)i.next()).getId());
        }
        List links = this.gateway.findLinks(ctx, mParent, ids);
        if (links != null) {
            this.gateway.deleteObjects(ctx, links);
        }
    }

    private List<DataObject> deleteTagSet(SecurityContext ctx, long id) throws DSOutOfServiceException, DSAccessException {
        List l = this.gateway.findAnnotationLinks(ctx, Annotation.class, id, null);
        ArrayList<Long> tagIds = new ArrayList<Long>();
        ArrayList<DataObject> tags = new ArrayList<DataObject>();
        for (AnnotationAnnotationLink link : l) {
            long tagID = link.getChild().getId().getValue();
            if (tagIds.contains(tagID)) continue;
            tagIds.add(tagID);
            tags.add(PojoMapper.asDataObject((IObject)link.getChild()));
        }
        this.gateway.deleteObjects(ctx, l);
        return tags;
    }

    private String getUserName(ExperimenterData user) {
        ExperimenterData loggedIn = this.context.getAdminService().getUserDetails();
        if (user != null && user.getId() != loggedIn.getId()) {
            return user.getUserName();
        }
        return null;
    }

    OmeroDataServiceImpl(OMEROGateway gateway, Registry registry) {
        if (registry == null) {
            throw new IllegalArgumentException("No registry.");
        }
        if (gateway == null) {
            throw new IllegalArgumentException("No gateway.");
        }
        this.context = registry;
        this.gateway = gateway;
    }

    @Override
    public Collection<DataObject> loadContainerHierarchy(SecurityContext ctx, Class rootNodeType, List rootNodeIDs, boolean withLeaves, long userID) throws DSOutOfServiceException, DSAccessException {
        ParametersI param = new ParametersI();
        if (rootNodeIDs == null && userID >= 0L) {
            param.exp(rtypes.rlong((long)userID));
        }
        if (withLeaves) {
            param.leaves();
        } else {
            param.noLeaves();
        }
        if ((rootNodeIDs == null || rootNodeIDs.size() == 0) && (ProjectData.class.equals((Object)rootNodeType) || ScreenData.class.equals((Object)rootNodeType))) {
            param.orphan();
        }
        return this.gateway.loadContainerHierarchy(ctx, rootNodeType, rootNodeIDs, (Parameters)param);
    }

    @Override
    public Collection<DataObject> loadTopContainerHierarchy(SecurityContext ctx, Class rootNodeType, long userID) throws DSOutOfServiceException, DSAccessException {
        ParametersI param = new ParametersI();
        param.exp(rtypes.rlong((long)userID));
        return this.gateway.loadContainerHierarchy(ctx, rootNodeType, null, (Parameters)param);
    }

    @Override
    public Collection<DataObject> findContainerHierarchy(SecurityContext ctx, Class rootNodeType, List leavesIDs, long userID) throws DSOutOfServiceException, DSAccessException {
        ParametersI po = new ParametersI();
        po.leaves();
        po.exp(rtypes.rlong((long)userID));
        return this.gateway.findContainerHierarchy(ctx, rootNodeType, leavesIDs, (Parameters)po);
    }

    @Override
    public Collection<ImageData> getImages(SecurityContext ctx, Class nodeType, List nodeIDs, long userID) throws DSOutOfServiceException, DSAccessException {
        if (nodeType == null) {
            throw new IllegalArgumentException("No type specified.");
        }
        ParametersI po = new ParametersI();
        if (userID >= 0L) {
            po.exp(rtypes.rlong((long)userID));
        }
        return this.gateway.getContainerImages(ctx, nodeType, nodeIDs, (Parameters)po);
    }

    @Override
    public Collection<ImageData> getExperimenterImages(SecurityContext ctx, long userID, boolean orphan) throws DSOutOfServiceException, DSAccessException {
        return this.gateway.getUserImages(ctx, userID, orphan);
    }

    @Override
    public Map getCollectionCount(SecurityContext ctx, Class rootNodeType, String property, List rootNodeIDs) throws DSOutOfServiceException, DSAccessException {
        if (!property.equals("images")) {
            throw new IllegalArgumentException("Property not supported.");
        }
        return this.gateway.getCollectionCount(ctx, rootNodeType, property, rootNodeIDs, new Parameters());
    }

    @Override
    public DataObject createDataObject(SecurityContext ctx, DataObject child, DataObject parent, Collection children) throws DSOutOfServiceException, DSAccessException {
        if (child == null) {
            throw new IllegalArgumentException("The child cannot be null.");
        }
        String userName = this.getUserName(ctx.getExperimenterData());
        IObject obj = ModelMapper.createIObject(child, parent);
        if (obj == null) {
            throw new NullPointerException("Cannot convert the object.");
        }
        IObject created = this.gateway.createObject(ctx, obj, userName);
        if (created == null) {
            return null;
        }
        if (parent != null) {
            IObject link = ModelMapper.linkParentToChild(created, parent.asIObject());
            if (child instanceof TagAnnotationData && link != null) {
                this.gateway.createObject(ctx, link, userName);
            }
        }
        if (children != null && children.size() > 0) {
            Iterator i = children.iterator();
            ArrayList<IObject> links = new ArrayList<IObject>();
            while (i.hasNext()) {
                Object node = i.next();
                if (!(node instanceof DataObject)) continue;
                links.add(ModelMapper.linkParentToChild(((DataObject)node).asIObject(), created));
            }
            if (links.size() > 0) {
                this.gateway.createObjects(ctx, links);
            }
        }
        return PojoMapper.asDataObject(created);
    }

    @Override
    public DataObject updateDataObject(SecurityContext ctx, DataObject object) throws DSOutOfServiceException, DSAccessException {
        if (object == null) {
            throw new DSAccessException("No object to update.");
        }
        if (!object.isDirty()) {
            return object;
        }
        ctx = this.gateway.checkContext(ctx, object);
        if (object instanceof ExperimenterData) {
            return this.updateExperimenter(ctx, (ExperimenterData)object, null);
        }
        if (!object.isLoaded()) {
            return object;
        }
        IObject ho = null;
        IObject oldObject = null;
        oldObject = object.asIObject();
        ho = this.gateway.findIObject(ctx, oldObject);
        if (ho == null) {
            return null;
        }
        ModelMapper.fillIObject(oldObject, ho);
        ModelMapper.unloadCollections(ho);
        IObject updated = this.gateway.updateObject(ctx, ho, new Parameters());
        return PojoMapper.asDataObject(updated);
    }

    @Override
    public void addExistingObjects(SecurityContext ctx, DataObject parent, Collection children) throws DSOutOfServiceException, DSAccessException {
        ctx = this.gateway.checkContext(ctx, parent);
        if (parent instanceof ProjectData) {
            try {
                children.toArray(new DatasetData[0]);
            }
            catch (ArrayStoreException ase) {
                throw new IllegalArgumentException("items can only be datasets.");
            }
        } else {
            if (parent instanceof GroupData) {
                try {
                    ExperimenterData[] exp = children.toArray(new ExperimenterData[0]);
                    ArrayList<ExperimenterData> list = new ArrayList<ExperimenterData>();
                    for (int i = 0; i < exp.length; ++i) {
                        list.add(exp[i]);
                    }
                    this.context.getAdminService().addExperimenters(ctx, (GroupData)parent, list);
                    return;
                }
                catch (ArrayStoreException ase) {
                    throw new IllegalArgumentException("items can only be experimenters.");
                }
            }
            if (parent instanceof DatasetData) {
                try {
                    children.toArray(new ImageData[0]);
                }
                catch (ArrayStoreException ase) {
                    throw new IllegalArgumentException("items can only be images.");
                }
            } else if (parent instanceof ScreenData) {
                try {
                    children.toArray(new PlateData[0]);
                }
                catch (ArrayStoreException ase) {
                    throw new IllegalArgumentException("items can only be plate.");
                }
            } else if (parent instanceof TagAnnotationData) {
                TagAnnotationData tagSet = (TagAnnotationData)parent;
                if (!"openmicroscopy.org/omero/insight/tagset".equals(tagSet.getNameSpace())) {
                    throw new IllegalArgumentException("Parent not supported");
                }
                for (Object object : children) {
                    if (!(object instanceof TagAnnotationData)) {
                        throw new IllegalArgumentException("items can only be Tag.");
                    }
                    TagAnnotationData tag = (TagAnnotationData)object;
                    if (tag.getNameSpace() == null) continue;
                    throw new IllegalArgumentException("items can only be Tag.");
                }
            } else {
                throw new IllegalArgumentException("Parent not supported");
            }
        }
        ArrayList<IObject> objects = new ArrayList<IObject>();
        IObject ioParent = parent.asIObject();
        for (DataObject child : children) {
            IObject ioChild;
            if (child.getGroupId() != ctx.getGroupID() || this.gateway.findLink(ctx, ioParent, ioChild = child.asIObject()) != null) continue;
            objects.add(ModelMapper.linkParentToChild(ioChild, ioParent));
        }
        if (objects.size() != 0) {
            this.gateway.createObjects(ctx, objects);
        }
    }

    @Override
    public void cutAndPaste(SecurityContext ctx, Map toPaste, Map toCut) throws DSOutOfServiceException, DSAccessException {
        Object parent;
        if (toPaste == null) {
            toPaste = new HashMap();
        }
        if (toCut == null) {
            toCut = new HashMap();
        }
        for (Map.Entry entry : toCut.entrySet()) {
            parent = entry.getKey();
            if (!(parent instanceof DataObject)) continue;
            this.cut(ctx, (DataObject)parent, (Set)entry.getValue());
        }
        for (Map.Entry entry : toPaste.entrySet()) {
            parent = entry.getKey();
            if (!(parent instanceof DataObject)) continue;
            this.addExistingObjects(ctx, (DataObject)parent, (Set)entry.getValue());
        }
    }

    @Override
    public List<File> getArchivedImage(SecurityContext ctx, File file, long imageID) throws DSOutOfServiceException, DSAccessException {
        this.context.getLogger().debug((Object)this, file.getAbsolutePath());
        ImageData image = this.gateway.getImage(ctx, imageID, null);
        return this.gateway.getArchivedFiles(ctx, file, image);
    }

    public ExperimenterData updateExperimenter(SecurityContext ctx, ExperimenterData exp, GroupData group) throws DSOutOfServiceException, DSAccessException {
        if (exp == null) {
            throw new DSAccessException("No object to update.");
        }
        ctx = this.gateway.checkContext(ctx, exp);
        UserCredentials uc = (UserCredentials)this.context.lookup("/user/credentials");
        ExperimenterData user = (ExperimenterData)this.context.lookup("/current_user/details");
        this.gateway.updateExperimenter(ctx, exp.asExperimenter(), user.getId());
        if (group != null && exp.getDefaultGroup().getId() != group.getId()) {
            this.gateway.changeCurrentGroup(ctx, exp, group.getId());
        }
        ExperimenterData data = this.gateway.getUserDetails(ctx, uc.getUser().getUsername(), true);
        this.context.bind("/current_user/details", data);
        List agents = (List)this.context.lookup("/agents");
        for (AgentInfo agentInfo : agents) {
            agentInfo.getRegistry().bind("/current_user/details", data);
        }
        return data;
    }

    @Override
    public Collection getImagesPeriod(SecurityContext ctx, Timestamp startTime, Timestamp endTime, long userID, boolean asDataObject) throws DSOutOfServiceException, DSAccessException {
        if (startTime == null && endTime == null) {
            throw new NullPointerException("Time not specified.");
        }
        ParametersI po = new ParametersI();
        po.leaves();
        if (userID >= 0L) {
            po.exp(rtypes.rlong((long)userID));
        }
        if (startTime != null) {
            po.startTime(rtypes.rtime((long)startTime.getTime()));
        }
        if (endTime != null) {
            po.endTime(rtypes.rtime((long)endTime.getTime()));
        }
        return this.gateway.getImages(ctx, (Parameters)po, asDataObject);
    }

    @Override
    public List getImagesAllPeriodCount(SecurityContext ctx, Timestamp startTime, Timestamp endTime, long userID) throws DSOutOfServiceException, DSAccessException {
        if (startTime == null || endTime == null) {
            throw new NullPointerException("Time not specified.");
        }
        Collection imgs = this.getImagesPeriod(ctx, startTime, endTime, userID, false);
        Iterator i = imgs.iterator();
        ArrayList<Timestamp> times = new ArrayList<Timestamp>(imgs.size());
        while (i.hasNext()) {
            Image object = (Image)i.next();
            Event evt = object.getDetails().getCreationEvent();
            if (evt == null) continue;
            times.add(new Timestamp(evt.getTime().getValue()));
        }
        return times;
    }

    @Override
    public SearchResultCollection search(SecurityContext ctx, SearchParameters context) throws DSOutOfServiceException, DSAccessException {
        if (ctx == null) {
            throw new IllegalArgumentException("No security context defined.");
        }
        if (context == null) {
            throw new IllegalArgumentException("No search context defined.");
        }
        if (!context.isValid()) {
            throw new IllegalArgumentException("Search context not valid.");
        }
        SearchResultCollection results = new SearchResultCollection();
        long[] ids = this.convertSearchTermsToIds(context.getQuery());
        if (ids != null) {
            for (long id : ids) {
                List<Object> types = new ArrayList<Class<ImageData>>();
                if (context.getTypes().isEmpty()) {
                    types.add(ImageData.class);
                    types.add(DatasetData.class);
                    types.add(ProjectData.class);
                    types.add(ScreenData.class);
                    types.add(PlateData.class);
                } else {
                    types = context.getTypes();
                }
                for (Class clazz : types) {
                    SearchResult res = new SearchResult();
                    res.setObjectId(id);
                    res.setType(clazz);
                    res.setIdMatch(true);
                    results.add(res);
                }
            }
        }
        if (!results.isEmpty()) {
            this.findByIds(ctx, results);
        }
        SearchResultCollection searchResults = this.gateway.search(ctx, context);
        results.addAll(searchResults);
        if (searchResults.isError()) {
            results.setError(searchResults.getError());
        }
        this.initializeImages(results);
        return results;
    }

    private void findByIds(SecurityContext ctx, SearchResultCollection results) throws DSOutOfServiceException {
        Iterator it = results.iterator();
        while (it.hasNext()) {
            SearchResult r = (SearchResult)it.next();
            IObject obj = null;
            try {
                String type = null;
                if (r.getType().equals(Image.class) || r.getType().equals(ImageData.class)) {
                    type = Image.class.getSimpleName();
                } else if (r.getType().equals(Dataset.class) || r.getType().equals(DatasetData.class)) {
                    type = Dataset.class.getSimpleName();
                } else if (r.getType().equals(Project.class) || r.getType().equals(ProjectData.class)) {
                    type = Project.class.getSimpleName();
                } else if (r.getType().equals(Screen.class) || r.getType().equals(ScreenData.class)) {
                    type = Screen.class.getSimpleName();
                } else if (r.getType().equals(Well.class) || r.getType().equals(WellData.class)) {
                    type = Well.class.getSimpleName();
                } else if (r.getType().equals(Plate.class) || r.getType().equals(PlateData.class)) {
                    type = Plate.class.getSimpleName();
                }
                if (type == null) {
                    return;
                }
                String query = "select x from " + type + " x join fetch x.details.creationEvent where x.id=" + r.getObjectId();
                obj = this.gateway.findIObjectByQuery(ctx, query, true);
            }
            catch (DSAccessException dSAccessException) {
                // empty catch block
            }
            if (obj == null) {
                it.remove();
                continue;
            }
            r.setObject(PojoMapper.asDataObject(obj));
        }
    }

    private void initializeImages(SearchResultCollection results) {
        Map<Long, List<SearchResult>> byGroup = results.getByGroup(ImageData.class);
        for (long groupId : byGroup.keySet()) {
            ArrayList<Long> ids = new ArrayList<Long>();
            for (SearchResult r : byGroup.get(groupId)) {
                ids.add(r.getObjectId());
            }
            SecurityContext ctx = new SecurityContext(groupId);
            try {
                Collection<ImageData> tmp = this.gateway.getContainerImages(ctx, ImageData.class, ids, new Parameters());
                block4: for (ImageData img : tmp) {
                    for (SearchResult r : byGroup.get(groupId)) {
                        if (r.getObjectId() != img.getId()) continue;
                        r.setObject(img);
                        continue block4;
                    }
                }
            }
            catch (Exception exception) {
            }
        }
    }

    private long[] convertSearchTermsToIds(String query) {
        String[] tmp = query.split("\\s|\\s*,\\s*");
        long[] result = new long[tmp.length];
        try {
            for (int i = 0; i < tmp.length; ++i) {
                result[i] = Long.parseLong(tmp[i]);
            }
        }
        catch (NumberFormatException e) {
            return null;
        }
        return result;
    }

    @Override
    public Collection findContainerPaths(SecurityContext ctx, Class type, long id, long userID) throws DSOutOfServiceException, DSAccessException {
        try {
            Class<? extends IObject> parentClass = PojoMapper.getModelType(type);
            if (DatasetData.class.equals((Object)type)) {
                parentClass = Project.class;
            } else if (ImageData.class.equals((Object)type)) {
                parentClass = Dataset.class;
            } else if (PlateData.class.equals((Object)type)) {
                parentClass = Screen.class;
            } else if (TagAnnotationData.class.equals((Object)type)) {
                parentClass = TagAnnotation.class;
            } else if (FileAnnotationData.class.equals((Object)type)) {
                parentClass = FileAnnotation.class;
            } else if (WellSampleData.class.equals((Object)type) || WellData.class.equals((Object)type)) {
                parentClass = Plate.class;
            } else if (PlateAcquisitionData.class.equals((Object)type)) {
                parentClass = Plate.class;
            }
            if (parentClass == null) {
                return new HashSet();
            }
            List links = this.gateway.findLinks(ctx, parentClass, id, userID);
            if (ImageData.class.equals((Object)type) && (links == null || links.size() == 0)) {
                return this.gateway.findPlateFromImage(ctx, id, userID);
            }
            if (PlateAcquisitionData.class.equals((Object)type) && (links == null || links.size() == 0)) {
                return this.gateway.findPlateFromRun(ctx, id, userID);
            }
            if (links == null) {
                return new HashSet();
            }
            Iterator i = links.iterator();
            HashSet<DataObject> nodes = new HashSet<DataObject>();
            Project parent = null;
            ArrayList<Long> ids = new ArrayList<Long>();
            while (i.hasNext()) {
                long parentId;
                if (parentClass.equals(Project.class)) {
                    parent = ((ProjectDatasetLink)i.next()).getParent();
                } else if (parentClass.equals(Dataset.class)) {
                    parent = ((DatasetImageLink)i.next()).getParent();
                } else if (parentClass.equals(Screen.class)) {
                    parent = ((ScreenPlateLink)i.next()).getParent();
                } else if (parentClass.equals(TagAnnotation.class)) {
                    parent = ((AnnotationAnnotationLink)i.next()).getParent();
                } else if (parentClass.equals(FileAnnotation.class)) {
                    IObject link = (IObject)i.next();
                    if (link instanceof ProjectAnnotationLink) {
                        parent = ((ProjectAnnotationLink)link).getParent();
                    } else if (link instanceof DatasetAnnotationLink) {
                        parent = ((DatasetAnnotationLink)link).getParent();
                    } else if (link instanceof ImageAnnotationLink) {
                        parent = ((ImageAnnotationLink)link).getParent();
                    } else if (link instanceof PlateAnnotationLink) {
                        parent = ((PlateAnnotationLink)link).getParent();
                    } else if (link instanceof ScreenAnnotationLink) {
                        parent = ((ScreenAnnotationLink)link).getParent();
                    }
                }
                if (ids.contains(parentId = parent.getId().getValue())) continue;
                IObject object = this.gateway.findIObject(ctx, parent.getClass().getName(), parent.getId().getValue());
                DataObject data = PojoMapper.asDataObject(object);
                if (TagAnnotation.class.equals(parentClass)) {
                    TagAnnotationData tag;
                    if (data instanceof TagAnnotationData && "openmicroscopy.org/omero/insight/tagset".equals((tag = (TagAnnotationData)data).getNameSpace())) {
                        nodes.add(data);
                    }
                } else {
                    nodes.add(data);
                }
                ids.add(parentId);
            }
            return nodes;
        }
        catch (Exception e) {
            throw new DSAccessException(e.getMessage());
        }
    }

    @Override
    public Collection getOriginalFiles(SecurityContext ctx, long pixelsID) throws DSOutOfServiceException, DSAccessException {
        if (pixelsID < 0L) {
            throw new IllegalArgumentException("Pixels set ID not valid.");
        }
        return this.gateway.getOriginalFiles(ctx, pixelsID);
    }

    @Override
    public Collection loadPlateWells(SecurityContext ctx, long plateID, long acquisitionID, long userID) throws DSOutOfServiceException, DSAccessException {
        return this.gateway.loadPlateWells(ctx, plateID, acquisitionID);
    }

    @Override
    public RequestCallback delete(SecurityContext ctx, Collection<DeletableObject> objects) throws DSOutOfServiceException, DSAccessException, ProcessException {
        if (CollectionUtils.isEmpty(objects) || ctx == null) {
            return null;
        }
        Iterator<DeletableObject> it = objects.iterator();
        while (it.hasNext()) {
            DeletableObject object = it.next();
            if (object.getGroupId() == ctx.getGroupID()) continue;
            it.remove();
        }
        if (objects.size() == 0) {
            return null;
        }
        HashMap<String, ArrayList<Long>> toDelete = new HashMap<String, ArrayList<Long>>();
        HashMap options = new HashMap();
        for (DeletableObject delo : objects) {
            String type;
            ArrayList<Long> ids;
            ArrayList<ChildOption> opts = new ArrayList<ChildOption>();
            DataObject data = delo.getObjectToDelete();
            if (!CollectionUtils.isEmpty(delo.getAnnotations())) {
                opts.add((ChildOption)Requests.option().excludeType(PojoMapper.getGraphType(AnnotationData.class)).build());
            }
            if (!delo.deleteContent()) {
                String ns;
                if (data instanceof DatasetData) {
                    opts.add((ChildOption)Requests.option().excludeType(PojoMapper.getGraphType(ImageData.class)).build());
                } else if (data instanceof ProjectData) {
                    opts.add((ChildOption)Requests.option().excludeType(PojoMapper.getGraphType(DatasetData.class)).build());
                } else if (data instanceof ScreenData) {
                    opts.add((ChildOption)Requests.option().excludeType(PojoMapper.getGraphType(PlateData.class)).build());
                } else if (data instanceof PlateData) {
                    opts.add((ChildOption)Requests.option().excludeType(PojoMapper.getGraphType(ImageData.class)).build());
                } else if (data instanceof PlateAcquisitionData) {
                    opts.add((ChildOption)Requests.option().excludeType(PojoMapper.getGraphType(ImageData.class)).build());
                } else if (data instanceof TagAnnotationData && "openmicroscopy.org/omero/insight/tagset".equals(ns = ((TagAnnotationData)data).getNameSpace())) {
                    this.deleteTagSet(ctx, data.getId());
                }
            }
            if ((ids = (ArrayList<Long>)toDelete.get(type = PojoMapper.getGraphType(data.getClass()))) == null) {
                ids = new ArrayList<Long>();
                toDelete.put(type, ids);
            }
            ids.add(delo.getObjectToDelete().getId());
            options.put(type, opts);
        }
        ArrayList<Request> cmds = new ArrayList<Request>();
        for (String type : toDelete.keySet()) {
            cmds.add((Request)((Requests.Delete2Builder)((Requests.Delete2Builder)((Requests.Delete2Builder)Requests.delete().target(type)).id((Iterable)toDelete.get(type))).option((Iterable)options.get(type))).build());
        }
        return this.gateway.submit(cmds, ctx);
    }

    @Override
    public FSFileSystemView getFSRepositories(SecurityContext ctx, long userID) throws DSOutOfServiceException, DSAccessException {
        return this.gateway.getFSRepositories(ctx, userID);
    }

    @Override
    public RequestCallback transfer(SecurityContext ctx, SecurityContext target, List<DataObject> targetNodes, List<DataObject> objects) throws DSOutOfServiceException, DSAccessException, ProcessException {
        boolean notEmpty;
        PermissionData perms;
        ExperimenterData owner;
        DataObject data;
        if (target == null) {
            throw new IllegalArgumentException("No target specified.");
        }
        if (objects == null || objects.size() == 0) {
            throw new IllegalArgumentException("No object to move.");
        }
        Iterator<DataObject> i = objects.iterator();
        HashMap<DataObject, List<IObject>> map = new HashMap<DataObject, List<IObject>>();
        String userName = this.getUserName(ctx.getExperimenterData());
        ExperimenterData exp = this.context.getAdminService().getUserDetails();
        ExperimenterI o = null;
        ArrayList<IObject> targets = new ArrayList<IObject>();
        while (i.hasNext()) {
            data = i.next();
            owner = data.getOwner();
            perms = data.getPermissions();
            if (owner.getId() == exp.getId() || perms.getPermissionsLevel() != 0) continue;
            o = new ExperimenterI(owner.getId(), false);
            break;
        }
        if (!CollectionUtils.isEmpty(targetNodes)) {
            List<IObject> toCreate = new ArrayList<IObject>();
            for (DataObject object : targetNodes) {
                if (object == null) continue;
                if (object.getId() < 0L) {
                    IObject newObject = object.asIObject();
                    if (newObject != null && o != null) {
                        newObject.getDetails().setOwner((Experimenter)o);
                    }
                    toCreate.add(newObject);
                    continue;
                }
                targets.add(object.asIObject());
            }
            if (toCreate.size() > 0) {
                toCreate = this.gateway.saveAndReturnObject(target, toCreate, new HashMap(), userName);
                targets.addAll(toCreate);
            }
        }
        i = objects.iterator();
        boolean bl = notEmpty = !CollectionUtils.isEmpty(targets);
        while (i.hasNext()) {
            data = i.next();
            owner = data.getOwner();
            perms = data.getPermissions();
            ArrayList<IObject> l = new ArrayList<IObject>();
            if (notEmpty) {
                for (IObject newObject : targets) {
                    if (newObject == null) continue;
                    try {
                        IObject link = ModelMapper.linkParentToChild(data.asIObject(), newObject);
                        if (link == null) continue;
                        if (o != null) {
                            link.getDetails().setOwner((Experimenter)o);
                        }
                        l.add(link);
                    }
                    catch (Exception e) {
                        StringBuffer buffer = new StringBuffer();
                        buffer.append("Cannot link ");
                        buffer.append(data.getClass());
                        buffer.append(" to ");
                        buffer.append(newObject.getClass());
                        buffer.append(" ");
                        LogMessage msg = new LogMessage();
                        msg.print(buffer.toString());
                        msg.print((Throwable)e);
                        this.context.getLogger().debug((Object)this, msg);
                    }
                }
            }
            map.put(data, l);
        }
        HashMap<String, String> options = new HashMap<String, String>();
        return this.gateway.transfer(ctx, target, map, options);
    }

    @Override
    public Map<Long, PlateData> loadPlateFromImage(SecurityContext ctx, Collection<Long> ids) throws DSOutOfServiceException, DSAccessException {
        if (CollectionUtils.isEmpty(ids)) {
            throw new IllegalArgumentException("No images specified.");
        }
        HashMap<Long, PlateData> r = new HashMap<Long, PlateData>();
        for (Long id : ids) {
            r.put(id, this.gateway.getImportedPlate(ctx, id));
        }
        return r;
    }

    @Override
    public void closeService(SecurityContext ctx, StatefulServiceInterfacePrx svc) {
        if (ctx == null || svc == null) {
            return;
        }
        this.gateway.closeService(ctx, svc);
    }

    @Override
    public Map<Long, Map<Boolean, List<ImageData>>> getImagesBySplitFilesets(SecurityContext ctx, Class<? extends DataObject> rootType, List<Long> rootIDs) throws DSOutOfServiceException, DSAccessException {
        if (CollectionUtils.isEmpty(rootIDs) || rootType == null) {
            throw new IllegalArgumentException("No objects specified.");
        }
        ParametersI param = new ParametersI();
        Map<Long, Map<Boolean, List<Long>>> m = this.gateway.getImagesBySplitFilesets(ctx, rootType, rootIDs, (Parameters)param);
        HashMap<Long, Map<Boolean, List<ImageData>>> r = new HashMap<Long, Map<Boolean, List<ImageData>>>();
        if (m == null || m.size() == 0) {
            return r;
        }
        ArrayList ids = new ArrayList();
        for (Map<Boolean, List<Long>> map : m.values()) {
            Iterator<List<Long>> j = map.values().iterator();
            while (j.hasNext()) {
                ids.addAll(j.next());
            }
        }
        Collection<ImageData> imgs = this.getImages(ctx, ImageData.class, ids, -1L);
        HashMap<Long, ImageData> idMap = new HashMap<Long, ImageData>(imgs.size());
        for (ImageData img : imgs) {
            idMap.put(img.getId(), img);
        }
        for (Map.Entry<Long, Map<Boolean, List<Long>>> e : m.entrySet()) {
            Iterator<Map.Entry<Boolean, List<Long>>> j = e.getValue().entrySet().iterator();
            HashMap converted = new HashMap();
            while (j.hasNext()) {
                Map.Entry<Boolean, List<Long>> entry = j.next();
                List<Long> l = entry.getValue();
                Iterator<Long> kk = l.iterator();
                ArrayList<ImageData> convertedList = new ArrayList<ImageData>();
                while (kk.hasNext()) {
                    convertedList.add((ImageData)idMap.get(kk.next()));
                }
                converted.put(entry.getKey(), convertedList);
            }
            r.put(e.getKey(), converted);
        }
        return r;
    }

    @Override
    public Map<Long, List<DatasetData>> findDatasetsByImageId(SecurityContext ctx, List<Long> imgIds) throws DSOutOfServiceException, DSAccessException {
        HashMap<Long, List<DatasetData>> result = new HashMap<Long, List<DatasetData>>();
        List queryResult = this.gateway.findDatasetLinks(ctx, imgIds, -1L);
        for (Object tmp : queryResult) {
            if (!(tmp instanceof DatasetImageLink)) continue;
            DatasetImageLink dl = (DatasetImageLink)tmp;
            DatasetData dsd = (DatasetData)PojoMapper.asDataObject((IObject)dl.getParent());
            long imgId = dl.getChild().getId().getValue();
            ArrayList<DatasetData> sets = (ArrayList<DatasetData>)result.get(imgId);
            if (sets == null) {
                sets = new ArrayList<DatasetData>();
                result.put(imgId, sets);
            }
            sets.add(dsd);
        }
        return result;
    }

    @Override
    public Collection<FolderData> saveROIFolders(SecurityContext ctx, Collection<FolderData> folders) throws DSOutOfServiceException, DSAccessException {
        return this.gateway.saveROIFolders(ctx, folders);
    }

    @Override
    public int getROICount(SecurityContext ctx, long imageId) throws DSOutOfServiceException, DSAccessException {
        return this.gateway.getROICount(ctx, imageId);
    }
}

