/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.data.views.calls;

import java.util.ArrayList;
import java.util.List;
import omero.gateway.SecurityContext;
import omero.gateway.model.DataObject;
import omero.gateway.model.ExperimenterData;
import omero.gateway.model.GroupData;
import org.apache.commons.collections4.CollectionUtils;
import org.openmicroscopy.shoola.env.data.AdminService;
import org.openmicroscopy.shoola.env.data.model.AdminObject;
import org.openmicroscopy.shoola.env.data.views.BatchCall;
import org.openmicroscopy.shoola.env.data.views.BatchCallTree;

public class AdminSaver
extends BatchCallTree {
    public static final int DELETE = 0;
    private Object result;
    private BatchCall loadCall;

    private BatchCall deleteObjects(final SecurityContext ctx, final List<DataObject> objects) {
        return new BatchCall("Delete objects"){

            @Override
            public void doCall() throws Exception {
                AdminService os = AdminSaver.this.context.getAdminService();
                ArrayList<DataObject> l = new ArrayList<DataObject>();
                ArrayList<GroupData> groups = new ArrayList<GroupData>();
                ArrayList<ExperimenterData> experimenters = new ArrayList<ExperimenterData>();
                for (DataObject data : objects) {
                    if (data instanceof GroupData) {
                        groups.add((GroupData)data);
                        continue;
                    }
                    if (!(data instanceof ExperimenterData)) continue;
                    experimenters.add((ExperimenterData)data);
                }
                if (groups.size() > 0) {
                    l.addAll(os.deleteGroups(ctx, groups));
                }
                if (experimenters.size() > 0) {
                    l.addAll(os.deleteExperimenters(ctx, experimenters));
                }
                AdminSaver.this.result = l;
            }
        };
    }

    private BatchCall createExperimenters(final SecurityContext ctx, final AdminObject object) {
        return new BatchCall("Create experimenters"){

            @Override
            public void doCall() throws Exception {
                AdminService os = AdminSaver.this.context.getAdminService();
                AdminSaver.this.result = os.createExperimenters(ctx, object);
            }
        };
    }

    private BatchCall resetExperimentersPassword(final SecurityContext ctx, final AdminObject object) {
        return new BatchCall("Reset password"){

            @Override
            public void doCall() throws Exception {
                AdminService os = AdminSaver.this.context.getAdminService();
                AdminSaver.this.result = os.resetExperimentersPassword(ctx, object);
            }
        };
    }

    private BatchCall activateExperimenters(final SecurityContext ctx, final AdminObject object) {
        return new BatchCall("Reset password"){

            @Override
            public void doCall() throws Exception {
                AdminService os = AdminSaver.this.context.getAdminService();
                AdminSaver.this.result = os.activateExperimenters(ctx, object);
            }
        };
    }

    private BatchCall createGroup(final SecurityContext ctx, final AdminObject object) {
        return new BatchCall("Create group"){

            @Override
            public void doCall() throws Exception {
                AdminService os = AdminSaver.this.context.getAdminService();
                AdminSaver.this.result = os.createGroup(ctx, object);
            }
        };
    }

    @Override
    protected void buildTree() {
        this.add(this.loadCall);
    }

    @Override
    protected Object getResult() {
        return this.result;
    }

    public AdminSaver(SecurityContext ctx, AdminObject object) {
        if (object == null) {
            throw new IllegalArgumentException("Object not valid.");
        }
        switch (object.getIndex()) {
            case 1: {
                this.loadCall = this.createExperimenters(ctx, object);
                break;
            }
            case 0: {
                this.loadCall = this.createGroup(ctx, object);
                break;
            }
            case 4: {
                this.loadCall = this.resetExperimentersPassword(ctx, object);
                break;
            }
            case 6: {
                this.loadCall = this.activateExperimenters(ctx, object);
            }
        }
    }

    public AdminSaver(SecurityContext ctx, List<DataObject> objects, int index) {
        if (CollectionUtils.isEmpty(objects)) {
            throw new IllegalArgumentException("No objects to handle");
        }
        switch (index) {
            case 0: {
                this.loadCall = this.deleteObjects(ctx, objects);
            }
        }
    }
}

