/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.ui;

import info.clearthought.layout.TableLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.LineBorder;
import org.openmicroscopy.shoola.env.ui.ActivityComponent;
import org.openmicroscopy.shoola.env.ui.ActivityResultRow;
import org.openmicroscopy.shoola.env.ui.DeleteActivity;
import org.openmicroscopy.shoola.env.ui.IconManager;
import org.openmicroscopy.shoola.util.ui.TitlePanel;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

class ActivityResultDialog
extends JDialog
implements ActionListener,
PropertyChangeListener {
    private static final int CLOSE = 0;
    private ActivityComponent activity;
    private Object result;
    private JButton closeButton;

    private void initComponents() {
        this.closeButton = new JButton("Close");
        this.closeButton.setToolTipText("Close the dialog.");
        this.closeButton.addActionListener(this);
        this.closeButton.setActionCommand("0");
    }

    private JPanel buildStatusBar() {
        JPanel p = new JPanel();
        p.add(this.closeButton);
        JPanel bar = UIUtilities.buildComponentPanelRight(p);
        bar.setBorder(new LineBorder(Color.LIGHT_GRAY));
        return bar;
    }

    private JPanel layoutResult() {
        JPanel p;
        block7: {
            int index;
            TableLayout layout;
            block6: {
                p = new JPanel();
                p.setBackground(UIUtilities.BACKGROUND);
                layout = new TableLayout();
                p.setLayout((LayoutManager)layout);
                index = 0;
                if (!(this.result instanceof Collection)) break block6;
                double[] size = new double[]{-1.0};
                layout.setColumn(size);
                Iterator i = ((Collection)this.result).iterator();
                while (i.hasNext()) {
                    layout.insertRow(index, -2.0);
                    Object r = i.next();
                    ActivityResultRow c = new ActivityResultRow(r, this.activity);
                    p.add((Component)c, "0, " + index + ", FULL, CENTER");
                    if (index % 2 == 0) {
                        c.setBackground(UIUtilities.BACKGROUND_COLOUR_EVEN);
                    } else {
                        c.setBackground(UIUtilities.BACKGROUND_COLOUR_ODD);
                    }
                    ++index;
                }
                break block7;
            }
            if (!(this.result instanceof Map)) break block7;
            double[] size = new double[]{-2.0, 5.0, -1.0};
            layout.setColumn(size);
            for (Map.Entry entry : ((Map)this.result).entrySet()) {
                String key = (String)entry.getKey();
                layout.insertRow(index, -2.0);
                ActivityResultRow c = new ActivityResultRow(key, entry.getValue(), this.activity);
                c.addPropertyChangeListener(this);
                JPanel empty = new JPanel();
                JPanel pp = UIUtilities.buildComponentPanel(UIUtilities.setTextFont(key + ": "), 0, 0);
                Dimension d = c.getPreferredSize();
                d = new Dimension(empty.getPreferredSize().width, d.height);
                empty.setPreferredSize(d);
                empty.setSize(d);
                d = new Dimension(pp.getPreferredSize().width, d.height);
                pp.setPreferredSize(d);
                pp.setSize(d);
                if (index % 2 == 0) {
                    pp.setBackground(UIUtilities.BACKGROUND_COLOUR_EVEN);
                    c.setBackground(UIUtilities.BACKGROUND_COLOUR_EVEN);
                    empty.setBackground(UIUtilities.BACKGROUND_COLOUR_EVEN);
                } else {
                    pp.setBackground(UIUtilities.BACKGROUND_COLOUR_ODD);
                    c.setBackground(UIUtilities.BACKGROUND_COLOUR_ODD);
                    empty.setBackground(UIUtilities.BACKGROUND_COLOUR_ODD);
                }
                p.add((Component)pp, "0, " + index + ", FULL, CENTER");
                p.add((Component)empty, "1, " + index + ", FULL, CENTER");
                p.add((Component)c, "2, " + index + ", FULL, CENTER");
                ++index;
            }
        }
        return p;
    }

    private void buildGUI() {
        Map m;
        Container c = this.getContentPane();
        String title = "Results";
        String text = "Follow the results returned.";
        if (this.result instanceof Map && (m = (Map)this.result).containsKey("stderr")) {
            title = "Errors";
            text = "Follow the errors returned.";
        }
        if (this.activity instanceof DeleteActivity) {
            title = "Errors";
            text = "Follow the errors returned.";
        }
        TitlePanel tp = new TitlePanel(title, text, IconManager.getResults());
        c.setBackground(UIUtilities.BACKGROUND_COLOR);
        JScrollPane pane = new JScrollPane(this.layoutResult());
        pane.getViewport().setBackground(UIUtilities.BACKGROUND_COLOR);
        pane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        pane.setBackground(UIUtilities.BACKGROUND_COLOR);
        pane.setOpaque(false);
        pane.setBorder(new LineBorder(Color.LIGHT_GRAY));
        c.add((Component)((Object)tp), "North");
        c.add((Component)pane, "Center");
        c.add((Component)this.buildStatusBar(), "South");
    }

    private void close() {
        this.setVisible(false);
        this.dispose();
    }

    ActivityResultDialog(JFrame owner, ActivityComponent activity, Object result) {
        this(owner, activity, result, -1);
    }

    ActivityResultDialog(JFrame owner, ActivityComponent activity, Object result, int index) {
        super(owner);
        if (activity == null) {
            throw new IllegalArgumentException("No activity to handle.");
        }
        if (result == null) {
            throw new IllegalArgumentException("No result to handle.");
        }
        this.result = result;
        this.activity = activity;
        this.initComponents();
        this.buildGUI();
        this.pack();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int index = Integer.parseInt(e.getActionCommand());
        switch (index) {
            case 0: {
                this.close();
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        if ("action".equals(name)) {
            this.close();
        }
    }
}

