/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui.drawingtools.figures;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.Collection;
import java.util.LinkedList;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.Handle;
import org.jhotdraw.draw.TextHolderFigure;
import org.jhotdraw.draw.Tool;
import org.jhotdraw.draw.TransformHandleKit;
import org.jhotdraw.geom.Insets2D;
import org.openmicroscopy.shoola.util.roi.model.annotation.MeasurementAttributes;
import org.openmicroscopy.shoola.util.ui.drawingtools.attributes.DrawingAttributes;
import org.openmicroscopy.shoola.util.ui.drawingtools.figures.FigureUtil;
import org.openmicroscopy.shoola.util.ui.drawingtools.figures.RotateEllipseFigure;
import org.openmicroscopy.shoola.util.ui.drawingtools.texttools.TransformedDrawingTextTool;

public class EllipseTextFigure
extends RotateEllipseFigure
implements TextHolderFigure {
    protected boolean fromTransformUpdate;
    protected boolean editable;
    private Rectangle2D.Double textBounds;

    public EllipseTextFigure(String text) {
        this(text, 0.0, 0.0, 0.0, 0.0);
    }

    public EllipseTextFigure(String t, double x, double y, double w, double h) {
        super(x, y, w, h);
        this.setAttributeEnabled(AttributeKeys.TEXT_COLOR, true);
        this.setAttributeEnabled(MeasurementAttributes.HEIGHT, true);
        this.setAttributeEnabled(MeasurementAttributes.WIDTH, true);
        super.setAttribute(MeasurementAttributes.WIDTH, w);
        super.setAttribute(MeasurementAttributes.HEIGHT, h);
        this.setText(t);
        this.textBounds = null;
        this.editable = true;
        this.fromTransformUpdate = true;
    }

    @Override
    public void setAttribute(AttributeKey key, Object newValue) {
        super.setAttribute(key, newValue);
        if (!this.fromTransformUpdate) {
            if (MeasurementAttributes.HEIGHT.getKey().equals(key.getKey())) {
                double newHeight = (Double)MeasurementAttributes.HEIGHT.get((Figure)this);
                this.setHeight(newHeight);
            }
            if (MeasurementAttributes.WIDTH.getKey().equals(key.getKey())) {
                double newWidth = (Double)MeasurementAttributes.WIDTH.get((Figure)this);
                this.setWidth(newWidth);
            }
        }
    }

    @Override
    public void transform(AffineTransform tx) {
        super.transform(tx);
        this.fromTransformUpdate = true;
        MeasurementAttributes.HEIGHT.set((Figure)this, (Object)this.getTransformedEllipse().getBounds2D().getHeight());
        MeasurementAttributes.WIDTH.set((Figure)this, (Object)this.getTransformedEllipse().getBounds2D().getWidth());
        this.fromTransformUpdate = false;
    }

    @Override
    public void setBounds(Point2D.Double anchor, Point2D.Double lead) {
        super.setBounds(anchor, lead);
        this.fromTransformUpdate = true;
        Rectangle2D r = this.getTransformedEllipse().getBounds2D();
        MeasurementAttributes.HEIGHT.set((Figure)this, (Object)r.getHeight());
        MeasurementAttributes.WIDTH.set((Figure)this, (Object)r.getWidth());
        this.fromTransformUpdate = false;
    }

    @Override
    public Collection<Handle> createHandles(int detailLevel) {
        LinkedList<Handle> handles = new LinkedList<Handle>();
        if (detailLevel == 0) {
            TransformHandleKit.addTransformHandles((Figure)this, handles);
        }
        return handles;
    }

    protected Rectangle2D.Double getTextBounds() {
        if (this.textBounds == null) {
            return new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
        }
        return this.textBounds;
    }

    public void setEditable(boolean b) {
        this.editable = b;
    }

    public Tool getTool(Point2D.Double p) {
        if (this.isEditable() && this.contains(p)) {
            this.invalidate();
            return new TransformedDrawingTextTool(this, this.getTransformedShape());
        }
        return null;
    }

    @Override
    protected void drawFill(Graphics2D g) {
        super.drawFill(g);
        this.drawText(g);
    }

    protected void drawText(Graphics2D g) {
        if (!((Boolean)MeasurementAttributes.SHOWTEXT.get((Figure)this)).booleanValue()) {
            return;
        }
        String text = this.getText();
        if (text != null) {
            double textWidth;
            if ((text = text.trim()).length() == 0) {
                return;
            }
            Rectangle r = this.getTransformedShape().getBounds();
            Font font = (Font)AttributeKeys.FONT_FACE.get((Figure)this);
            font = font.deriveFont(((Double)AttributeKeys.FONT_SIZE.get((Figure)this)).floatValue());
            FontMetrics fm = g.getFontMetrics(font);
            double width = textWidth = (double)fm.stringWidth(text);
            double avgCharWidth = textWidth / (double)text.length();
            double maxTextWidth = avgCharWidth * 100.0;
            if (textWidth > maxTextWidth) {
                width = maxTextWidth;
            }
            double textHeight = (textWidth / width + 1.0) * (double)(fm.getAscent() + fm.getDescent() + fm.getLeading());
            double x = r.getCenterX() - width / 2.0;
            double y = r.getCenterY();
            this.textBounds = new Rectangle2D.Double(x, y, width, textHeight);
            FontRenderContext frc = g.getFontRenderContext();
            AttributedString styledText = new AttributedString(text);
            FigureUtil.formatLayout(font, styledText, (Figure)this);
            AttributedCharacterIterator i = styledText.getIterator();
            LineBreakMeasurer measurer = new LineBreakMeasurer(i, frc);
            Color c = (Color)AttributeKeys.STROKE_COLOR.get((Figure)this);
            if (c != null) {
                g.setColor(c);
            }
            int w = (int)width;
            while (measurer.getPosition() < text.length()) {
                TextLayout layout = measurer.nextLayout(w);
                layout.draw(g, (float)x, (float)(y += (double)layout.getAscent()));
                y += (double)(layout.getDescent() + layout.getLeading());
            }
        }
    }

    @Override
    public void invalidate() {
        super.invalidate();
    }

    protected void validate() {
        super.validate();
    }

    @Override
    public Rectangle2D.Double getDrawingArea() {
        Rectangle2D.Double r = super.getDrawingArea();
        r.add(this.getTextBounds());
        return r;
    }

    public String getText() {
        return (String)this.getAttribute(AttributeKeys.TEXT);
    }

    public void setText(String newText) {
        boolean b = newText != null && newText.trim().length() > 0;
        this.setAttribute(DrawingAttributes.SHOWTEXT, b);
        this.setAttribute(AttributeKeys.TEXT, newText);
    }

    public int getTextColumns() {
        String t = this.getText();
        int n = 4;
        return t == null ? n : Math.max(t.length(), n);
    }

    public int getTabSize() {
        return 8;
    }

    public TextHolderFigure getLabelFor() {
        return this;
    }

    public Insets2D.Double getInsets() {
        return new Insets2D.Double();
    }

    public Font getFont() {
        return AttributeKeys.getFont((Figure)this);
    }

    public Color getTextColor() {
        return (Color)AttributeKeys.TEXT_COLOR.get((Figure)this);
    }

    public Color getFillColor() {
        return (Color)AttributeKeys.FILL_COLOR.get((Figure)this);
    }

    public float getFontSize() {
        return ((Double)AttributeKeys.FONT_SIZE.get((Figure)this)).floatValue();
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setFontSize(float size) {
    }

    public boolean isTextOverflow() {
        return false;
    }

    @Override
    public EllipseTextFigure clone() {
        EllipseTextFigure that = (EllipseTextFigure)super.clone();
        that.setText(this.getText());
        that.editable = true;
        that.fromTransformUpdate = true;
        return that;
    }
}

