/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui.slider;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import org.openmicroscopy.shoola.util.ui.NumericalTextField;
import org.openmicroscopy.shoola.util.ui.slider.OneKnobSlider;

public class TextualOneKnobSlider
extends JPanel
implements ActionListener,
ChangeListener,
DocumentListener,
FocusListener {
    public static final int LEFT_TEXT_BOX = 0;
    public static final int RIGHT_TEXT_BOX = 1;
    private OneKnobSlider slider;
    private NumericalTextField field;
    private JLabel fieldLabel;
    private int start;
    private int location;
    private Map<Integer, Integer> converter;

    private void initComponents(int min, int max, int start) {
        this.fieldLabel = new JLabel();
        this.slider = new OneKnobSlider(0, min, max, start);
        this.slider.setShowArrows(false);
        int length = ("" + max).length();
        this.field = new NumericalTextField(min, (double)max);
        this.field.setColumns(length);
        this.field.setText("" + start);
        this.start = start;
    }

    private void attachListeners() {
        this.slider.addChangeListener(this);
        this.installFieldListener();
    }

    private void installFieldListener() {
        this.field.addActionListener(this);
        this.field.addFocusListener(this);
        Document doc = this.field.getDocument();
        doc.addDocumentListener(this);
    }

    private void uninstallFieldListener() {
        this.field.removeActionListener(this);
        this.field.removeFocusListener(this);
        this.field.getDocument().removeDocumentListener(this);
    }

    private void setStartValue() {
        boolean valid = false;
        int val = 0;
        try {
            val = Integer.parseInt(this.field.getText());
            if (this.slider.getMinimum() <= val && val <= this.slider.getMaximum()) {
                valid = true;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (!valid) {
            this.field.selectAll();
            return;
        }
        this.start = val;
        this.slider.setValue(this.start);
    }

    private void handleFocusLost() {
        String s = "" + this.start;
        String startVal = this.field.getText();
        if (startVal == null || !startVal.equals(s)) {
            this.field.setText(s);
        }
    }

    private void buildGUI() {
        switch (this.location) {
            case 0: {
                break;
            }
        }
    }

    public TextualOneKnobSlider(int min, int max, int start) {
        this(min, max, start, 1);
    }

    public TextualOneKnobSlider(int min, int max, int start, int location) {
        this.initComponents(min, max, start);
        this.attachListeners();
        this.location = location;
        this.buildGUI();
    }

    public void setTextValue(String value) {
        if (value != null) {
            this.fieldLabel.setText(value);
        }
    }

    public void setConverter(Map<Integer, Integer> converter) {
        this.converter = converter;
    }

    public void setComponentsEnabled(boolean enabled) {
        this.slider.setEnabled(enabled);
        this.field.setEnabled(enabled);
    }

    public void setFieldEnabled(boolean enabled) {
        this.field.setEnabled(enabled);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        int value = this.slider.getValue();
        if (this.converter != null) {
            this.field.setText("" + this.converter.get(value));
        } else {
            this.field.setText("" + this.slider.getValue());
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.setStartValue();
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.handleFocusLost();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.setStartValue();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.setStartValue();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }

    @Override
    public void focusGained(FocusEvent e) {
    }
}

