/*
 * Decompiled with CFR 0.152.
 */
package ome.util.checksum;

import ome.util.checksum.Adler32ChecksumProviderImpl;
import ome.util.checksum.CRC32ChecksumProviderImpl;
import ome.util.checksum.ChecksumProvider;
import ome.util.checksum.ChecksumProviderFactoryImpl;
import ome.util.checksum.ChecksumType;
import ome.util.checksum.MD5ChecksumProviderImpl;
import ome.util.checksum.Murmur128ChecksumProviderImpl;
import ome.util.checksum.Murmur32ChecksumProviderImpl;
import ome.util.checksum.SHA1ChecksumProviderImpl;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class ChecksumProviderFactoryImplTest {
    private ChecksumProviderFactoryImpl cpf;

    @BeforeClass
    protected void setUp() throws Exception {
        this.cpf = new ChecksumProviderFactoryImpl();
    }

    @Test
    public void testGetProviderWithSHA1ChecksumType() {
        ChecksumProvider cp = this.cpf.getProvider(ChecksumType.SHA1);
        Assert.assertTrue((boolean)(cp instanceof SHA1ChecksumProviderImpl));
    }

    @Test
    public void testGetProviderWithMD5ChecksumType() {
        ChecksumProvider cp = this.cpf.getProvider(ChecksumType.MD5);
        Assert.assertTrue((boolean)(cp instanceof MD5ChecksumProviderImpl));
    }

    @Test
    public void testGetProviderWithAdler32ChecksumType() {
        ChecksumProvider cp = this.cpf.getProvider(ChecksumType.ADLER32);
        Assert.assertTrue((boolean)(cp instanceof Adler32ChecksumProviderImpl));
    }

    @Test
    public void testGetProviderWithCRC32ChecksumType() {
        ChecksumProvider cp = this.cpf.getProvider(ChecksumType.CRC32);
        Assert.assertTrue((boolean)(cp instanceof CRC32ChecksumProviderImpl));
    }

    @Test
    public void testGetProviderWithMurmur32ChecksumType() {
        ChecksumProvider cp = this.cpf.getProvider(ChecksumType.MURMUR32);
        Assert.assertTrue((boolean)(cp instanceof Murmur32ChecksumProviderImpl));
    }

    @Test
    public void testGetProviderWithMurmur128ChecksumType() {
        ChecksumProvider cp = this.cpf.getProvider(ChecksumType.MURMUR128);
        Assert.assertTrue((boolean)(cp instanceof Murmur128ChecksumProviderImpl));
    }
}

