/*
 * Decompiled with CFR 0.152.
 */
package ome.formats.importer.util;

import ome.formats.importer.util.TimeEstimator;
import org.apache.commons.lang.time.StopWatch;

public class ProportionalTimeEstimatorImpl
implements TimeEstimator {
    private final ThreadLocal<StopWatch> swGetter = new ThreadLocal<StopWatch>(){

        @Override
        protected StopWatch initialValue() {
            return new StopWatch();
        }
    };
    private long imageContainerSize = 0L;
    private long timeLeft = 0L;
    private long totalBytes = 0L;
    private long totalTime = 0L;

    public ProportionalTimeEstimatorImpl(long imageContainerSize) {
        this.imageContainerSize = imageContainerSize;
    }

    @Override
    public void start() {
        StopWatch sw = this.swGetter.get();
        sw.reset();
        sw.start();
    }

    @Override
    public void stop() {
        StopWatch sw = this.swGetter.get();
        sw.stop();
        this.updateStats(sw);
    }

    @Override
    public void stop(long uploadedBytes) {
        StopWatch sw = this.swGetter.get();
        sw.stop();
        this.updateStats(sw, uploadedBytes);
    }

    private synchronized void updateStats(StopWatch sw) {
        this.totalTime += sw.getTime();
    }

    private synchronized void updateStats(StopWatch sw, long uploadedBytes) {
        this.totalTime += sw.getTime();
        this.totalBytes += uploadedBytes;
        this.imageContainerSize -= uploadedBytes;
        if (this.totalTime > 0L) {
            float averageBps = (float)this.totalBytes / ((float)this.totalTime / 1000.0f);
            this.timeLeft = (long)Math.ceil((float)this.imageContainerSize / averageBps * 1000.0f);
        }
    }

    @Override
    public synchronized long getUploadTimeLeft() {
        return this.timeLeft;
    }
}

