/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.dataBrowser.actions;

import java.awt.event.ActionEvent;
import omero.gateway.model.DataObject;
import omero.gateway.model.ImageData;
import org.openmicroscopy.shoola.agents.dataBrowser.DataBrowserAgent;
import org.openmicroscopy.shoola.agents.dataBrowser.IconManager;
import org.openmicroscopy.shoola.agents.dataBrowser.actions.DataBrowserAction;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.Browser;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageDisplay;
import org.openmicroscopy.shoola.agents.dataBrowser.view.DataBrowser;
import org.openmicroscopy.shoola.env.data.events.ViewInPluginEvent;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class ViewInPluginAction
extends DataBrowserAction {
    private static final String NAME_IJ = "View in ImageJ...";
    private static final String DESCRIPTION_IJ = "View the selected image in ImageJ.";
    private static final String NAME_KNIME = "View in KNIME...";
    private static final String DESCRIPTION_KNIME = "View the selected image(s) in KNIME.";
    private int plugin;

    @Override
    protected void onDisplayChange(ImageDisplay node) {
        if (node == null) {
            this.setEnabled(false);
            return;
        }
        this.setEnabled(node.getHierarchyObject() instanceof ImageData);
    }

    public ViewInPluginAction(DataBrowser model, int plugin) {
        super(model);
        this.plugin = plugin;
        IconManager icons = IconManager.getInstance();
        switch (plugin) {
            case 1: {
                this.putValue("Name", NAME_IJ);
                this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION_IJ));
                this.putValue("SmallIcon", icons.getIcon(56));
                break;
            }
            case 2: {
                this.putValue("Name", NAME_KNIME);
                this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION_KNIME));
                this.putValue("SmallIcon", icons.getIcon(58));
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Browser browser = this.model.getBrowser();
        if (browser == null) {
            return;
        }
        ImageDisplay node = browser.getLastSelectedDisplay();
        if (node == null) {
            return;
        }
        Object object = node.getHierarchyObject();
        if (DataBrowserAgent.runAsPlugin() >= 0 && object instanceof ImageData) {
            ViewInPluginEvent event = new ViewInPluginEvent(this.model.getSecurityContext(), (DataObject)object, this.plugin);
            event.setDataObjects(browser.getSelectedDataObjects());
            DataBrowserAgent.getRegistry().getEventBus().post(event);
        }
    }
}

